/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.hermes.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.Tiny.util.OrderSnUtil;
import com.zhlh.hermes.mongo.dao.InsuBackTrackDao;
import com.zhlh.hermes.mongo.dao.InsuOrderDao;
import com.zhlh.hermes.mongo.entity.InsuBackTrack;
import com.zhlh.hermes.mongo.entity.InsuOrder;
import com.zhlh.hermes.service.RecordService;
import com.zhlh.hermes.service.model.InsuTraceDto;
import com.zhlh.hermes.service.model.UserRecordReqDto;
import com.zhlh.hermes.service.model.UserRecordResDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class RecordServiceImpl
implements RecordService {
    @Autowired
    private InsuBackTrackDao insuBackTrackDao;
    @Autowired
    private InsuOrderDao insuOrderDao;

    @Override
    public InsuTraceDto getVedioSeriesNoByOrderSn(String orderSn) {
        InsuBackTrack insuBackTrack;
        InsuTraceDto insuTraceDto = null;
        if (CommonUtil.isNotEmpty((String)orderSn) && (insuBackTrack = this.insuBackTrackDao.getVedioSeriesNoByOrderSn(orderSn)) != null) {
            insuTraceDto = new InsuTraceDto();
            insuTraceDto.setVedioSeriesNo(insuBackTrack.getVedioSeriesNo());
        }
        return insuTraceDto;
    }

    @Override
    public void saveRevord(UserRecordReqDto userRecordReqDto) {
        InsuBackTrack insuBackTrack = new InsuBackTrack();
        BeanUtil.quickCopy((Object)userRecordReqDto, (Object)insuBackTrack);
        insuBackTrack.setCreateTime(new Date());
        insuBackTrack.setIsAccess(1);
        insuBackTrack.setTypeVersion("1.0");
        insuBackTrack.setStartTime(DateUtil.parseDate((String)userRecordReqDto.getStartTime(), (String)"yyyyMMdd HHmmss"));
        insuBackTrack.setCreateTime(new Date());
        this.insuBackTrackDao.save((Object)insuBackTrack);
        if (userRecordReqDto.getTypeId() == 3) {
            InsuOrder insuOrder = new InsuOrder();
            BeanUtil.quickCopy((Object)userRecordReqDto, (Object)insuOrder);
            insuOrder.setInProductId(OrderSnUtil.randomOrderSn());
            insuOrder.setStatus("1");
            insuOrder.setCreateTime(new Date());
            this.insuOrderDao.save((Object)insuOrder);
        }
    }

    @Override
    public UserRecordResDto queryAllRecordsByPros(String productName, String orderSn, String appName, String appCertNo, int pageNo, int pageSize) {
        ArrayList<String> props = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String[] propsstrings = new String[props.size()];
        String[] valuesstrings = new String[props.size()];
        if (CommonUtil.isNotEmpty((String)productName)) {
            props.add("productName");
            values.add(productName);
        }
        if (CommonUtil.isNotEmpty((String)orderSn)) {
            props.add("orderSn");
            values.add(orderSn);
        }
        if (CommonUtil.isNotEmpty((String)appName)) {
            props.add("appName");
            values.add(appName);
        }
        if (CommonUtil.isNotEmpty((String)appCertNo)) {
            props.add("appCertNo");
            values.add(appCertNo);
        }
        Page page = this.insuBackTrackDao.paginationQuery(props.toArray(propsstrings), values.toArray(valuesstrings), pageNo, pageSize);
        ArrayList<InsuTraceDto> recordList = new ArrayList<InsuTraceDto>();
        List insuBackTrackList = page.getContent();
        if (insuBackTrackList != null && insuBackTrackList.size() > 0) {
            for (InsuBackTrack insuBackTrack : insuBackTrackList) {
                InsuTraceDto record = new InsuTraceDto();
                BeanUtil.quickCopy((Object)insuBackTrack, (Object)record);
                recordList.add(record);
            }
        }
        UserRecordResDto userRecordResDto = new UserRecordResDto();
        userRecordResDto.setRecordList(recordList);
        userRecordResDto.setCount(page.getTotalElements());
        userRecordResDto.setTotalPage(page.getTotalPages());
        return userRecordResDto;
    }

    @Override
    public InsuTraceDto queryInsuTraceByVedioSerNo(UserRecordReqDto userRecordReqDto) {
        InsuBackTrack insuBackTrack = this.insuBackTrackDao.getInsuBackTraceByVedioSerNo(userRecordReqDto.getVedioSeriesNo(), userRecordReqDto.getTypeId());
        InsuTraceDto insuTraceDto = null;
        if (insuBackTrack != null) {
            insuTraceDto = new InsuTraceDto();
            BeanUtil.quickCopy((Object)insuBackTrack, (Object)insuTraceDto);
            insuTraceDto.setCreateTime(DateUtil.formatDateTime((Date)insuBackTrack.getCreateTime()));
            insuTraceDto.setStartTime(DateUtil.formatDateTime((Date)insuBackTrack.getStartTime()));
        }
        return insuTraceDto;
    }
}

