/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.hermes.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.hermes.mongo.dao.InsuProductDao;
import com.zhlh.hermes.mongo.entity.InsuProduct;
import com.zhlh.hermes.service.ProductService;
import com.zhlh.hermes.service.model.ProductDto;
import com.zhlh.hermes.service.model.ProductReqDto;
import com.zhlh.hermes.service.model.ProductResDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class ProductServiceImpl
implements ProductService {
    @Autowired
    private InsuProductDao productDao;

    @Override
    public void saveProduct(ProductReqDto productReqDto) {
        InsuProduct product = new InsuProduct();
        BeanUtil.quickCopy((Object)productReqDto, (Object)product);
        product.setStatus(1);
        product.setDelete(0);
        product.setCreateTime(new Date());
        this.productDao.save((Object)product);
    }

    @Override
    public ProductResDto queryAllProducts(String productName, int pageNo, int pageSize) {
        Page insuProductPage = this.productDao.queryProductsByProductName(productName, 0, pageNo, pageSize);
        ProductResDto productResDto = new ProductResDto();
        List insuproductList = insuProductPage.getContent();
        if (insuproductList != null && insuproductList.size() > 0) {
            ArrayList<ProductDto> productDtoList = new ArrayList<ProductDto>();
            for (InsuProduct insuProduct : insuproductList) {
                ProductDto productDto = new ProductDto();
                BeanUtil.quickCopy((Object)insuProduct, (Object)productDto);
                productDto.setProductStatus(insuProduct.getStatus());
                productDto.setProductLongTerm(insuProduct.getLongTerm() == 1 ? "\u77ed\u671f\u9669" : "\u957f\u671f\u9669");
                productDto.setInProductId(insuProduct.getId());
                productDto.setCreateTime(DateUtil.formatDate((Date)insuProduct.getCreateTime()));
                productDtoList.add(productDto);
            }
            productResDto.setProductList(productDtoList);
        }
        productResDto.setCount(insuProductPage.getTotalElements());
        productResDto.setTotalPage(insuProductPage.getTotalPages());
        return productResDto;
    }

    @Override
    public void modifyProduct(ProductReqDto productReqDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CommonUtil.isNotEmpty((String)productReqDto.getProductName())) {
            map.put("productName", productReqDto.getProductName());
        }
        if (productReqDto.getLongTerm() != 0) {
            map.put("longTerm", productReqDto.getLongTerm());
        }
        if (productReqDto.getStatus() != null) {
            map.put("status", productReqDto.getStatus());
        }
        InsuProduct product = new InsuProduct();
        product.setId(productReqDto.getInProductId());
        this.productDao.updateProp((Object)product, map);
    }

    @Override
    public void deleteProduct(ProductReqDto productReqDto) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("delete", 1);
        InsuProduct product = new InsuProduct();
        product.setId(productReqDto.getInProductId());
        this.productDao.updateProp((Object)product, map);
    }

    @Override
    public ProductResDto queryEffectiveProducts() {
        ArrayList<String> props = new ArrayList<String>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        String[] propsstrings = new String[props.size()];
        Object[] valuesstrings = new Object[props.size()];
        props.add("status");
        values.add(1);
        props.add("delete");
        values.add(0);
        List efcfectiveProductList = this.productDao.queryProductsByStatusAndDeleteFlag(props.toArray(propsstrings), values.toArray(valuesstrings));
        ProductResDto productResDto = new ProductResDto();
        if (efcfectiveProductList != null && efcfectiveProductList.size() > 0) {
            ArrayList<ProductDto> productDtoList = new ArrayList<ProductDto>();
            for (InsuProduct insuProduct : efcfectiveProductList) {
                ProductDto productDto = new ProductDto();
                productDto.setInProductId(insuProduct.getId());
                productDto.setProductName(insuProduct.getProductName());
                productDtoList.add(productDto);
            }
            productResDto.setProductList(productDtoList);
        }
        return productResDto;
    }
}

