/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.hermes.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.hermes.mongo.dao.InsuProductContextDao;
import com.zhlh.hermes.mongo.dao.InsuProductDao;
import com.zhlh.hermes.mongo.entity.InsuProduct;
import com.zhlh.hermes.mongo.entity.InsuProductContext;
import com.zhlh.hermes.service.ProductApplicationService;
import com.zhlh.hermes.service.model.ProductApplicationDto;
import com.zhlh.hermes.service.model.ProductApplicationReqDto;
import com.zhlh.hermes.service.model.ProductApplicationResDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class ProductApplicationServiceImpl
implements ProductApplicationService {
    @Autowired
    private InsuProductContextDao insuProductContextDao;
    @Autowired
    private InsuProductDao insuProductDao;

    @Override
    public void saveProductApplicationConfig(ProductApplicationReqDto productApplicationReqDto) {
        InsuProductContext productContext = new InsuProductContext();
        BeanUtil.quickCopy((Object)productApplicationReqDto, (Object)productContext);
        productContext.setCreateTime(new Date());
        productContext.setDelete(0);
        this.insuProductContextDao.save((Object)productContext);
    }

    @Override
    public void modifyProductApplicationConfig(ProductApplicationReqDto productApplicationReqDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CommonUtil.isNotEmpty((String)productApplicationReqDto.getContext())) {
            map.put("context", productApplicationReqDto.getContext());
        }
        if (productApplicationReqDto.getBsProductId() != null) {
            map.put("bsProductId", productApplicationReqDto.getBsProductId());
        }
        InsuProductContext productContext = new InsuProductContext();
        productContext.setId(productApplicationReqDto.getProductApplicationId());
        this.insuProductContextDao.updateProp((Object)productContext, map);
    }

    @Override
    public void deleteProductApplicationConfig(ProductApplicationReqDto productApplicationReqDto) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("delete", 1);
        InsuProductContext productContext = new InsuProductContext();
        productContext.setId(productApplicationReqDto.getProductApplicationId());
        this.insuProductContextDao.updateProp((Object)productContext, map);
    }

    @Override
    public ProductApplicationResDto queryAllProductApplication(String inProductId, String context, int pageNo, int pageSize) {
        ArrayList<String> props = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        String[] propsstrings = new String[props.size()];
        Object[] valuesstrings = new Object[props.size()];
        if (CommonUtil.isNotEmpty((String)inProductId)) {
            props.add("inProductId");
            values.add(inProductId);
        }
        if (CommonUtil.isNotEmpty((String)context)) {
            props.add("context");
            values.add(context);
        }
        props.add("delete");
        values.add(0);
        Page insuProductContextPage = this.insuProductContextDao.queryProdAndAppByProductIdAndContext(props.toArray(propsstrings), values.toArray(valuesstrings), pageNo, pageSize);
        ProductApplicationResDto productApplicationResDto = new ProductApplicationResDto();
        List insuProductContextList = insuProductContextPage.getContent();
        if (insuProductContextList != null && insuProductContextList.size() > 0) {
            ArrayList<ProductApplicationDto> productApplicationDtoList = new ArrayList<ProductApplicationDto>();
            for (InsuProductContext insuProductContext : insuProductContextList) {
                ProductApplicationDto productApplicationDto = new ProductApplicationDto();
                InsuProduct product = (InsuProduct)this.insuProductDao.find((Serializable)((Object)insuProductContext.getInProductId()));
                BeanUtil.quickCopy((Object)insuProductContext, (Object)productApplicationDto);
                if (product != null) {
                    productApplicationDto.setProductName(product.getProductName());
                }
                productApplicationDto.setProductApplicationId(insuProductContext.getId());
                productApplicationDto.setCreateTime(DateUtil.formatDate((Date)insuProductContext.getCreateTime()));
                productApplicationDtoList.add(productApplicationDto);
            }
            productApplicationResDto.setProductList(productApplicationDtoList);
            productApplicationResDto.setCount(insuProductContextPage.getTotalElements());
            productApplicationResDto.setTotalPage(insuProductContextPage.getTotalPages());
            return productApplicationResDto;
        }
        return null;
    }
}

