/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.hermes.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.hermes.mongo.dao.InsuOrderDao;
import com.zhlh.hermes.mongo.dao.InsuProductDao;
import com.zhlh.hermes.mongo.entity.InsuOrder;
import com.zhlh.hermes.mongo.entity.InsuProduct;
import com.zhlh.hermes.service.OrderService;
import com.zhlh.hermes.service.model.InsuOrderDto;
import com.zhlh.hermes.service.model.OrderResDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    @Autowired
    private InsuOrderDao insuOrderDao;
    @Autowired
    private InsuProductDao insuProductDao;

    @Override
    public OrderResDto queryAllOrdersByPros(String context, String policyNo, String productName, String orderSn, String appName, String appCertNo, int pageNo, int pageSize) {
        ArrayList<String> props = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String[] propsstrings = new String[props.size()];
        String[] valuesstrings = new String[props.size()];
        if (CommonUtil.isNotEmpty((String)context)) {
            props.add("context");
            values.add(context);
        }
        if (CommonUtil.isNotEmpty((String)policyNo)) {
            props.add("policyNo");
            values.add(policyNo);
        }
        if (CommonUtil.isNotEmpty((String)productName)) {
            props.add("productName");
            values.add(productName);
        }
        if (CommonUtil.isNotEmpty((String)orderSn)) {
            props.add("orderSn");
            values.add(orderSn);
        }
        if (CommonUtil.isNotEmpty((String)appName)) {
            props.add("appName");
            values.add(appName);
        }
        if (CommonUtil.isNotEmpty((String)appCertNo)) {
            props.add("appCertNo");
            values.add(appCertNo);
        }
        Page page = this.insuOrderDao.paginationQuery(props.toArray(propsstrings), values.toArray(valuesstrings), pageNo, pageSize);
        ArrayList<InsuOrderDto> orderDtoList = new ArrayList<InsuOrderDto>();
        List insuOrderList = page.getContent();
        if (insuOrderList != null && insuOrderList.size() > 0) {
            for (InsuOrder order : insuOrderList) {
                InsuOrderDto orderDto = new InsuOrderDto();
                BeanUtil.quickCopy((Object)order, (Object)orderDto);
                InsuProduct insuProduct = (InsuProduct)this.insuProductDao.find((Serializable)((Object)order.getInProductId()));
                orderDto.setCreateTime(DateUtil.formatDate((Date)order.getCreateTime()));
                orderDto.setProductName(insuProduct.getProductName());
                orderDtoList.add(orderDto);
            }
        }
        OrderResDto orderResDto = new OrderResDto();
        orderResDto.setInsuOrderDtoList(orderDtoList);
        orderResDto.setCount(page.getTotalElements());
        orderResDto.setTotalPage(page.getTotalPages());
        return orderResDto;
    }
}

