/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.hermes.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.hermes.mongo.dao.InsuNodesDao;
import com.zhlh.hermes.mongo.entity.InsuNode;
import com.zhlh.hermes.service.NodeService;
import com.zhlh.hermes.service.model.NodeDto;
import com.zhlh.hermes.service.model.NodeReqDto;
import com.zhlh.hermes.service.model.NodeResDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class NodeServiceImpl
implements NodeService {
    @Autowired
    private InsuNodesDao insuNodesDao;

    @Override
    public void saveNode(NodeReqDto nodeReqDto) {
        InsuNode node = new InsuNode();
        BeanUtil.quickCopy((Object)nodeReqDto, (Object)node);
        node.setStatus(1);
        node.setCreateTime(new Date());
        this.insuNodesDao.save((Object)node);
    }

    @Override
    public void modifyNode(NodeReqDto nodeReqDto) {
        InsuNode node = new InsuNode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        node.setId(nodeReqDto.getId());
        if (!StringUtils.isEmpty((Object)nodeReqDto.getNodeId())) {
            map.put("nodeId", nodeReqDto.getNodeId());
        }
        if (!StringUtils.isEmpty((Object)nodeReqDto.getStatus())) {
            map.put("status", nodeReqDto.getStatus());
        }
        if (!StringUtils.isEmpty((Object)nodeReqDto.getNodeName())) {
            map.put("nodeName", nodeReqDto.getNodeName());
        }
        this.insuNodesDao.updateProp((Object)node, map);
    }

    @Override
    public void deleteNode(String id) {
        InsuNode node = new InsuNode();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        node.setId(id);
        map.put("isDel", 1);
        this.insuNodesDao.updateProp((Object)node, map);
    }

    @Override
    public NodeResDto queryAllNodes(String nodeName, Integer pageNo, Integer pageSize) {
        Page insuNodesPage = this.insuNodesDao.queryInsuNodesByNodeName(nodeName, pageNo, pageSize);
        NodeResDto nodeResDto = new NodeResDto();
        List insuNodesList = insuNodesPage.getContent();
        if (insuNodesList != null && insuNodesList.size() > 0) {
            ArrayList<NodeDto> nodeDtoList = new ArrayList<NodeDto>();
            for (InsuNode insuNodes : insuNodesList) {
                NodeDto nodeDto = new NodeDto();
                BeanUtil.quickCopy((Object)insuNodes, (Object)nodeDto);
                nodeDto.setStatus(insuNodes.getStatus() == 0 ? "\u4e0d\u53ef\u7528" : "\u53ef\u7528");
                nodeDto.setCreateTime(DateUtil.formatDate((Date)insuNodes.getCreateTime()));
                nodeDtoList.add(nodeDto);
            }
            nodeResDto.setNodeList(nodeDtoList);
        }
        nodeResDto.setCount(insuNodesPage.getTotalElements());
        nodeResDto.setTotalPage(insuNodesPage.getTotalPages());
        return nodeResDto;
    }
}

