/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.util;

import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static DateTimeFormatter dateTimeHmsFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");

    public static String getCurrentDateTime() {
        return new DateTime().toString(dateTimeFormatter);
    }

    public static String getCurrentDate() {
        return new DateTime().toString(dateFormatter);
    }

    public static String getNow(String pattern) {
        DateTimeFormatter format = DateTimeFormat.forPattern((String)pattern);
        return new DateTime().toString(format);
    }

    public static String getCurrentHmsDate() {
        return new DateTime().toString(dateTimeHmsFormatter);
    }

    public static DateTime praseDate(String dataStr) {
        return DateTime.parse((String)dataStr, (DateTimeFormatter)dateFormatter);
    }

    public static int getMonthsDifference(String start, String end) {
        DateTime date1 = DateUtil.praseDate(start);
        DateTime date2 = DateUtil.praseDate(end);
        Months month = Months.monthsBetween((ReadableInstant)date1, (ReadableInstant)date2);
        return month.getMonths();
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getMonthsDifference("2015-02-10", "2016-03-11"));
    }
}

