/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelper {
    protected static final Logger monitor = LoggerFactory.getLogger((String)"monitor");
    protected static final Logger http = LoggerFactory.getLogger((String)"http");
    private static final String REQUEST = "Request";
    private static final String RESPONSE = "Response";
    private static final String LEVEL_INFO = "info";
    private static final String LEVEL_ERROR = "error";

    public static void logRequest(String iName, String sessionId, String content) {
        LogHelper.logSegMessage(http, iName, REQUEST, sessionId, content, LEVEL_INFO);
    }

    public static void logResponse(String iName, String sessionId, String content) {
        LogHelper.logSegMessage(http, iName, RESPONSE, sessionId, content, LEVEL_INFO);
    }

    public static void logMonitor(String iName, String sessionId, String content) {
        LogHelper.logSegMessage(monitor, iName, RESPONSE, sessionId, content, LEVEL_ERROR);
    }

    private static void logSegMessage(Logger logger, String iName, String messageType, String sessionId, String content, String level) {
        String logStr = "[Interfaces]: {}, [Type]: {}, [SessionId]: {}, [Content]: {}";
        if (LEVEL_INFO.equals(level)) {
            logger.info(logStr, new Object[]{iName, messageType, sessionId, content});
        } else if (LEVEL_ERROR.equals(level)) {
            logger.error(logStr, new Object[]{iName, messageType, sessionId, content});
        }
    }
}

