/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.business.citycode;

import com.zhlh.gaia.common.business.citycode.CityCode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CityCodeManager {
    private static HashMap<String, CityCode> codeBase = new HashMap();

    public static String getCityCodeByLicense(String license) {
        CityCode code = codeBase.get(license.substring(0, 2));
        if (code == null) {
            code = codeBase.get(license.substring(0, 1));
        }
        if (code == null) {
            return null;
        }
        return code.code;
    }

    public static void initialize(String filepath) {
        try {
            CityCodeManager.loadFromCSV(filepath);
        }
        catch (Exception e) {
            System.err.println("load CityCode data from CSV error:" + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void loadFromCSV(String filepath) throws IOException {
        File csvData = new File(filepath);
        CSVFormat fmt = CSVFormat.EXCEL.withDelimiter(';');
        CSVParser parser = CSVParser.parse((File)csvData, (Charset)Charset.forName("GBK"), (CSVFormat)fmt);
        int sumCount = 0;
        for (CSVRecord csvRecord : parser) {
            ++sumCount;
            try {
                CityCode code = new CityCode(csvRecord.get(0), csvRecord.get(1), csvRecord.get(2));
                CityCode other = codeBase.get(code.vehicleLicenseHeader);
                if (other == null) {
                    codeBase.put(code.vehicleLicenseHeader, code);
                    continue;
                }
                if (other.code.endsWith("0000") || !code.code.endsWith("0000")) continue;
                other.code = code.code;
            }
            catch (Exception e) {
                System.err.println(csvRecord.get(0) + " : " + e.getMessage());
            }
        }
    }
}

