/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.exception;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.RegexUtil;
import com.zhlh.gaia.common.exception.ErrorCode;
import com.zhlh.gaia.common.exception.ParamException;
import com.zhlh.gaia.common.exception.ServiceException;
import com.zhlh.gaia.common.exception.SystemException;
import com.zhlh.gaia.dto.BaseResDto;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHelper {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHelper.class);

    public static void notNull(Object object, ErrorCode errorCode) {
        if (object == null) {
            ExceptionHelper.throwException(errorCode);
        }
    }

    public static void notEmpty(Collection object, ErrorCode errorCode) {
        if (CommonUtil.isEmpty((Collection)object)) {
            ExceptionHelper.throwException(errorCode);
        }
    }

    public static void notEmpty(String string, ErrorCode errorCode) {
        if (CommonUtil.isEmpty((String)string)) {
            ExceptionHelper.throwException(errorCode);
        }
    }

    public static void regexParam(String string, String regex, ErrorCode errorCode) {
        if (!RegexUtil.regexValidate((String)regex, (String)string)) {
            ExceptionHelper.throwException(errorCode);
        }
    }

    public static void beTrue(Boolean boo, ErrorCode errorCode) {
        if (!boo.booleanValue()) {
            ExceptionHelper.throwException(errorCode);
        }
    }

    public static void throwException(ErrorCode errorCode) {
        int code = errorCode.code();
        if (10000 <= code && code < 20000) {
            throw new ParamException(errorCode);
        }
        if (20000 <= code && code < 30000) {
            throw new ServiceException(errorCode);
        }
        if (30000 <= code && code < 40000) {
            throw new SystemException(errorCode);
        }
    }

    public static void throwServiceException(ErrorCode errorCode, String errorMessage) {
        throw new ServiceException(errorCode.code(), errorCode.toString() + errorMessage);
    }

    public static void transErrorMsg(Throwable e, BaseResDto resDto) {
        log.error("Exception", e);
        if (e instanceof SystemException) {
            resDto.setErrCode(((SystemException)e).getCode());
            resDto.setErrMsg(e.getMessage());
        } else if (e instanceof ServiceException) {
            resDto.setErrCode(((ServiceException)e).getCode());
            resDto.setErrMsg(e.getMessage());
        } else if (e instanceof ParamException) {
            resDto.setErrCode(((ParamException)e).getCode());
            resDto.setErrMsg(e.getMessage());
        } else {
            resDto.setErrCode(ErrorCode.SYS_ERROR.code());
            resDto.setErrMsg(ErrorCode.SYS_ERROR.toString());
        }
    }
}

