/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.aspect;

import com.alibaba.fastjson.JSON;
import com.zhlh.gaia.common.exception.ExceptionHelper;
import com.zhlh.gaia.common.util.BeanUtil;
import com.zhlh.gaia.dto.BaseResDto;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ServiceAspect {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAspect.class);

    @Around(value="execution(public * com.zhlh.gaia.api.CarInsuranceService.*(..))")
    public Object aroundServiceMethod(ProceedingJoinPoint pjp) {
        Object returnVal;
        long start = System.currentTimeMillis();
        String serviceName = pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName();
        try {
            returnVal = pjp.proceed();
        }
        catch (Throwable throwable) {
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            Method method = signature.getMethod();
            Class<?> returnType = method.getReturnType();
            returnVal = BeanUtil.invokeNewInstance(returnType);
            ExceptionHelper.transErrorMsg(throwable, (BaseResDto)returnVal);
        }
        LOG.info("[Service]: {}, [Args]: {}, [Return]: {}, [Cost]: {}.", new Object[]{serviceName, JSON.toJSONString((Object)pjp.getArgs()), JSON.toJSONString((Object)returnVal), System.currentTimeMillis() - start + "ms"});
        return returnVal;
    }
}

