/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public final class Executor
extends ThreadPoolExecutor {
    public static int executorCoreThreads = 500;
    public static int executorQueueSize = 200;
    public static int executorMaxThreads = 1000;
    public static long executorKeepAliveMS = 30000L;
    Stat stat = new Stat();
    public static final Timer timer = new Timer("executor-timer", true);

    public static Executor instance() {
        return SingletonHolder.instance;
    }

    public static void restart() {
        SingletonHolder.restart();
    }

    public Stat getStat() {
        return this.stat;
    }

    public void resetStat() {
        this.stat = new Stat();
    }

    public Future<?> submit(String type, Runnable task) {
        return this.submit(type, Executors.callable(task));
    }

    public <T> Future<T> submit(String type, Callable<T> task) {
        TaskWrapper<T> future = new TaskWrapper<T>(type, this.stat, task);
        return super.submit(future);
    }

    public void schedule(String type, Runnable task, long delay) {
        timer.schedule((TimerTask)new WrapperTimerTask(type, task), delay);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit("anonym1", task);
    }

    @Override
    @Deprecated
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit("anonym2", Executors.callable(task));
    }

    @Override
    @Deprecated
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit("anonym3", Executors.callable(task, result));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        if (callable instanceof TaskWrapper) {
            return (TaskWrapper)callable;
        }
        return super.newTaskFor(callable);
    }

    Executor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, workQueue, threadFactory, handler);
    }

    public static class WrapperTimerTask
    extends TimerTask {
        final String name;
        final Runnable task;

        public WrapperTimerTask(String name, Runnable task) {
            this.name = name;
            this.task = task;
        }

        @Override
        public void run() {
            Executor.instance().submit(this.name, this.task);
        }
    }

    public static final class Stat {
        final ConcurrentHashMap<String, Number[]> stat = new ConcurrentHashMap(20);

        void whenJobStart(String name) {
            Number[] entry = this.stat.get(name);
            if (entry == null) {
                Number[] newEntry = new Number[]{new AtomicInteger(), new AtomicInteger(), new AtomicLong()};
                Number[] oldEntry = this.stat.putIfAbsent(name, newEntry);
                entry = oldEntry != null ? oldEntry : newEntry;
            }
            ((AtomicInteger)entry[0]).incrementAndGet();
        }

        void whenJobStop(String name, long cost) {
            Number[] entry = this.stat.get(name);
            if (entry != null) {
                ((AtomicInteger)entry[1]).incrementAndGet();
                ((AtomicLong)entry[2]).addAndGet(cost);
            }
        }

        public String printRunning() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Number[]> entry : this.stat.entrySet()) {
                int val = entry.getValue()[0].intValue() - entry.getValue()[1].intValue();
                if (val <= 0) continue;
                sb.append(entry.getKey()).append(':').append(val).append('\n');
            }
            return sb.toString().trim();
        }

        public String printFinished() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Number[]> entry : this.stat.entrySet()) {
                long val = entry.getValue()[1].longValue();
                if (val <= 0L) continue;
                sb.append(entry.getKey()).append(':').append(val).append('\n');
            }
            return sb.toString().trim();
        }

        public String printFinishedCosts() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Number[]> entry : this.stat.entrySet()) {
                long val = entry.getValue()[2].longValue();
                if (val <= 0L) continue;
                sb.append(entry.getKey()).append(':').append(val).append("ms\n");
            }
            return sb.toString().trim();
        }

        public String printAverageCosts() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Number[]> entry : this.stat.entrySet()) {
                double val = entry.getValue()[2].doubleValue();
                int count = entry.getValue()[1].intValue();
                if (!(val > 0.0) || count <= 0) continue;
                sb.append(entry.getKey()).append(':').append(val / (double)count).append("ms\n");
            }
            return sb.toString().trim();
        }
    }

    public static final class DiscardAndLogPolicy
    implements RejectedExecutionHandler {
        static final int STAT_REPRINT_TIMEOUT = 600000;
        volatile long nextPrintTIme = 0L;

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (r instanceof TaskWrapper) {
                String task = "TaskWrapper(" + ((TaskWrapper)r).type + ")";
            } else {
                String task = String.valueOf(r);
            }
            long cur = System.currentTimeMillis();
            if (e instanceof Executor && cur > this.nextPrintTIme) {
                this.printExecStatus((Executor)e, cur);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printExecStatus(Executor e, long cur) {
            DiscardAndLogPolicy discardAndLogPolicy = this;
            synchronized (discardAndLogPolicy) {
                if (cur <= this.nextPrintTIme) {
                    return;
                }
                this.nextPrintTIme = cur + 600000L;
            }
            this.doPrintExeStat(e);
        }

        private void doPrintExeStat(Executor e) {
            Stat stat = e.getStat();
            System.out.println("discard debug: exe status:\n==============================\n>>>> running:\n" + stat.printRunning() + "\n>>>> finished:\n" + stat.printFinished() + "\n>>>> finished cost:\n" + stat.printFinishedCosts() + "\n>>>> avg cost:\n" + stat.printAverageCosts() + "\n==============================");
        }
    }

    static final class SingletonHolder {
        static volatile Executor instance;

        SingletonHolder() {
        }

        public static void restart() {
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(executorQueueSize);
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("MyExecutor-%d").daemon(true).build();
            final Executor oldInstance = instance;
            instance = new Executor(executorCoreThreads, executorMaxThreads, executorKeepAliveMS, TimeUnit.MILLISECONDS, queue, (ThreadFactory)threadFactory, new DiscardAndLogPolicy());
            if (oldInstance != null) {
                instance.submit("sys.reset-exec", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        oldInstance.shutdown();
                    }
                });
            }
        }

        static {
            SingletonHolder.restart();
        }
    }

    public static final class TaskWrapper<V>
    extends FutureTask<V>
    implements Callable<V> {
        final String type;
        final Stat _stat;
        final long[] startTime;

        public TaskWrapper(String type, Stat stat, Callable<V> task) {
            this(type, stat, task, new long[1]);
        }

        private TaskWrapper(final String type, final Stat stat, final Callable<V> task, final long[] startTime) {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    startTime[0] = System.currentTimeMillis();
                    stat.whenJobStart(type);
                    return task.call();
                }
            });
            this.type = type;
            this._stat = stat;
            this.startTime = startTime;
        }

        @Override
        protected void done() {
            long start = this.startTime[0];
            if (start > 0L) {
                long cost = System.currentTimeMillis() - start;
                this.startTime[0] = 0L;
                this._stat.whenJobStop(this.type, cost);
            }
        }

        @Override
        public V call() throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

