/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.wechat.helper;

import com.thoughtworks.xstream.XStream;
import com.zhlh.Tiny.wechat.helper.handle.MessageProcessingHandler;
import com.zhlh.Tiny.wechat.model.Articles;
import com.zhlh.Tiny.wechat.model.InMessage;
import com.zhlh.Tiny.wechat.model.OutMessage;
import com.zhlh.Tiny.wechat.util.XStreamFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinMessageManager {
    private static final Logger log = LoggerFactory.getLogger(WeiXinMessageManager.class);

    public static String processing(String responseInputString, MessageProcessingHandler messageProcessingHandler) {
        InMessage inMessage = WeiXinMessageManager.parsingInMessage(responseInputString);
        OutMessage oms = null;
        String xml = "";
        try {
            Object obj;
            String type = inMessage.getMsgType();
            Method getOutMessage = messageProcessingHandler.getClass().getMethod("getOutMessage", new Class[0]);
            Method alMt = messageProcessingHandler.getClass().getMethod("allType", InMessage.class);
            Method mt = messageProcessingHandler.getClass().getMethod(type + "TypeMsg", InMessage.class);
            if (alMt != null) {
                if (messageProcessingHandler == null) {
                    log.info("messageProcessingHandler is null");
                }
                if (inMessage == null) {
                    log.info("inMessage is null");
                }
                alMt.invoke((Object)messageProcessingHandler, inMessage);
            }
            if (mt != null) {
                mt.invoke((Object)messageProcessingHandler, inMessage);
            }
            if ((obj = getOutMessage.invoke((Object)messageProcessingHandler, new Object[0])) != null) {
                oms = (OutMessage)obj;
            }
            try {
                Method aftMt = messageProcessingHandler.getClass().getMethod("afterProcess", InMessage.class, OutMessage.class);
                aftMt.invoke((Object)messageProcessingHandler, inMessage, oms);
            }
            catch (Exception exception) {
                // empty catch block
            }
            obj = getOutMessage.invoke((Object)messageProcessingHandler, new Object[0]);
            if (obj != null) {
                oms = (OutMessage)obj;
                WeiXinMessageManager.setMsgInfo(oms, inMessage);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (oms != null) {
            XStream xs = XStreamFactory.init(true);
            xs.alias("xml", oms.getClass());
            xs.alias("item", Articles.class);
            xml = xs.toXML((Object)oms);
        }
        return xml;
    }

    private static void setMsgInfo(OutMessage oms, InMessage msg) throws Exception {
        if (oms != null) {
            Class<?> outMsg = oms.getClass().getSuperclass();
            Field CreateTime = outMsg.getDeclaredField("CreateTime");
            Field ToUserName = outMsg.getDeclaredField("ToUserName");
            Field FromUserName = outMsg.getDeclaredField("FromUserName");
            ToUserName.setAccessible(true);
            CreateTime.setAccessible(true);
            FromUserName.setAccessible(true);
            CreateTime.set(oms, new Date().getTime());
            ToUserName.set(oms, msg.getFromUserName());
            FromUserName.set(oms, msg.getToUserName());
        }
    }

    private static InMessage parsingInMessage(String responseInputString) {
        XStream xs = XStreamFactory.init(true);
        xs.ignoreUnknownElements();
        xs.alias("xml", InMessage.class);
        InMessage msg = (InMessage)xs.fromXML(responseInputString);
        return msg;
    }
}

