/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.zhlh.Tiny.util.EscapeUtil;
import java.security.MessageDigest;

public class Md5Util {
    private static final char[] HEX_CHARS_LOWER = "0123456789abcdef".toCharArray();
    private static final char[] HEX_CHARS_UPPER = "0123456789ABCDEF".toCharArray();

    public static void main(String[] args) {
        Md5Util.makeToken("MinSheng");
    }

    private static void makeToken(String name) {
        System.out.println(name + " , Test\u73af\u5883Token:" + Md5Util.makeToken("test", name));
        System.out.println(name + " , Pro\u73af\u5883Token:" + Md5Util.makeToken("pro", name));
    }

    private static String makeToken(String type, String name) {
        String test = "_arthas_h5_";
        String pro = "_arthas_pro_";
        type = "test".equals(type) ? test : pro;
        String token = Md5Util.md5AsUpperHex(name + type + name);
        token = token.substring(0, 8) + "-" + token.substring(8, 16) + "-" + token.substring(16, 24) + "-" + token.substring(24, 32);
        return token;
    }

    public static byte[] md5(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return digest.digest(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] md5(String s) {
        return Md5Util.md5(Md5Util.toBytes(s));
    }

    public static String md5AsUpperHex(String s) {
        return Md5Util.md5AsUpperHex(Md5Util.toBytes(s));
    }

    public static String md5AsLowerHex(String s) {
        return Md5Util.md5AsLowerHex(Md5Util.toBytes(s));
    }

    public static String md5AsUpperHex(byte[] bytes) {
        return Md5Util.asHex(Md5Util.md5(bytes), false);
    }

    public static String md5AsLowerHex(byte[] bytes) {
        return Md5Util.asHex(Md5Util.md5(bytes), true);
    }

    private static byte[] toBytes(String s) {
        if (s == null) {
            s = "";
        }
        return s.getBytes(EscapeUtil.CHARSET_UTF8);
    }

    private static String asHex(byte[] bytes, boolean lowerCase) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException();
        }
        char[] template = lowerCase ? HEX_CHARS_LOWER : HEX_CHARS_UPPER;
        char[] chars = new char[32];
        for (int i = 0; i < chars.length; i += 2) {
            byte b = bytes[i / 2];
            chars[i] = template[b >>> 4 & 0xF];
            chars[i + 1] = template[b & 0xF];
        }
        return new String(chars);
    }
}

