/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.wechat.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.EncryptUtil;
import com.zhlh.Tiny.util.HttpUtil;
import com.zhlh.Tiny.util.WebUtil;
import com.zhlh.Tiny.wechat.WeiXinConfig;
import com.zhlh.Tiny.wechat.helper.WeiXinCache;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinHelper {
    public static final Map<String, WeiXinCache> CACHE = new HashMap<String, WeiXinCache>();
    private static final Logger log = LoggerFactory.getLogger(WeiXinHelper.class);
    private static final String CACHE_ACCESS_TOKEN_KEY = "access_token";
    public static final String CACHE_JS_API_TICKET_KEY = "jsapi_ticket";

    public static String getOpenid(String code) {
        log.info("code:" + code);
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + WeiXinConfig.appId + "&secret=" + WeiXinConfig.secret + "&code=" + code + "&grant_type=authorization_code";
        String result = HttpUtil.post(url, "");
        log.info("get code binding\u6d88\u606f\u53d1\u9001\u5b8c\u6210\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + result);
        System.out.println("result:" + result);
        try {
            JSONObject json = JSON.parseObject((String)result);
            String openid = json.getString("openid");
            log.info("openid:" + openid);
            return openid;
        }
        catch (JSONException e) {
            log.error("Error occurred when getOpenId methods of WeixinUserServiceImpl.", (Throwable)e);
            e.printStackTrace();
            return "";
        }
    }

    public static String doGetUserInfo(String code) {
        try {
            String secret = WeiXinConfig.secret;
            String appid = WeiXinConfig.appId;
            log.info("secret:" + secret);
            log.info("appid:" + appid);
            String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code";
            String result = HttpUtil.get(url);
            JSONObject json = JSON.parseObject((String)result);
            String openId = json.getString("openid");
            String accessToken = json.getString(CACHE_ACCESS_TOKEN_KEY);
            String userInfoUrl = String.format("https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN", accessToken, openId);
            return HttpUtil.get(userInfoUrl);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAccessToken() {
        try {
            String accessToken = WeiXinHelper.getAccessTokenFromCache();
            if (CommonUtil.isNotEmpty(accessToken)) {
                return accessToken;
            }
            String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + WeiXinConfig.appId + "&secret=" + WeiXinConfig.secret;
            String result = HttpUtil.get(url);
            JSONObject json = JSON.parseObject((String)result);
            accessToken = json.getString(CACHE_ACCESS_TOKEN_KEY);
            WeiXinHelper.putAccessTokenToCache(accessToken);
            return accessToken;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void main(String[] args) {
        WeiXinHelper.getAccessTokenFromCache();
    }

    private static String getAccessTokenFromCache() {
        WeiXinCache cache = CACHE.get(CACHE_ACCESS_TOKEN_KEY);
        if (cache == null) {
            return "";
        }
        if (new Date().getTime() > cache.getExpiry().getTime()) {
            return "";
        }
        return cache.getValue().toString();
    }

    private static void putAccessTokenToCache(String accessToken) {
        WeiXinCache cache = new WeiXinCache();
        cache.setValue(accessToken);
        cache.setExpiry(DateUtils.addSeconds((Date)new Date(), (int)5400));
        CACHE.put(CACHE_ACCESS_TOKEN_KEY, cache);
    }

    public static boolean checkSignature(String signature, String timestamp, String nonce) throws NoSuchAlgorithmException {
        Object[] tmpArr = new String[]{timestamp, nonce, WeiXinConfig.token};
        Arrays.sort(tmpArr);
        String tmpStr = WeiXinHelper.getArrayStr((String[])tmpArr);
        String sha1 = WeiXinHelper.makeSHA1(tmpStr);
        return signature.equals(sha1);
    }

    private static String getArrayStr(String[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
        }
        return sb.toString();
    }

    private static String makeSHA1(String tmpStr) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(tmpStr.getBytes());
        byte[] tmpArr = md.digest();
        return WeiXinHelper.byteToHex(tmpArr);
    }

    private static String byteToHex(byte[] arr) {
        String hs = "";
        String tmp = "";
        for (int i = 0; i < arr.length; ++i) {
            tmp = Integer.toHexString(arr[i] & 0xFF);
            if (tmp.length() < 2) {
                tmp = "0" + tmp;
            }
            hs = hs + tmp;
        }
        return hs;
    }

    public static String getOauth2BaseUrl(String redirectUrl) {
        redirectUrl = WebUtil.encodeUrl(redirectUrl);
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeiXinConfig.appId + "&redirect_uri=%s&response_type=code&scope=snsapi_base&state=%s#wechat_redirect";
        return String.format(url, redirectUrl, "");
    }

    public static String getOauth2UserInfoUrl(String redirectUrl) {
        redirectUrl = WebUtil.encodeUrl(redirectUrl);
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeiXinConfig.appId + "&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=%s#wechat_redirect";
        return String.format(url, redirectUrl, "");
    }

    public static Map<String, String> getJSConfig() {
        String urlJsapiTicket = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=";
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("appId", WeiXinConfig.appId);
        long timestamp = System.currentTimeMillis() / 1000L;
        config.put("timestamp", timestamp + "");
        String nonceStr = RandomStringUtils.random((int)16, (boolean)true, (boolean)false);
        config.put("nonceStr", nonceStr);
        config.put("signature", WeiXinHelper.getJSConfigSignature(timestamp, nonceStr, urlJsapiTicket));
        return config;
    }

    private static String getJSConfigSignature(long timestamp, String nonceStr, String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("jsapi_ticket=").append(WeiXinHelper.getJSAPITicket()).append("&");
        sb.append("noncestr=").append(nonceStr).append("&");
        sb.append("timestamp=").append(timestamp).append("&");
        sb.append("url=").append(url);
        return EncryptUtil.sha1(sb.toString());
    }

    public static String getJSAPITicket() {
        String ticket = WeiXinHelper.getJSAPITicketFromCache();
        if (CommonUtil.isNotEmpty(ticket)) {
            return ticket;
        }
        String url = String.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi", WeiXinHelper.getAccessToken());
        String resp = HttpUtil.get(url);
        if (CommonUtil.isEmpty(resp)) {
            return "";
        }
        JSONObject jsonResp = JSON.parseObject((String)resp);
        if (jsonResp == null) {
            return "";
        }
        int errCode = jsonResp.getIntValue("errcode");
        if (errCode != 0) {
            return "";
        }
        ticket = jsonResp.getString("ticket");
        WeiXinHelper.putJSAPITicketToCache(ticket);
        return ticket;
    }

    private static String getJSAPITicketFromCache() {
        WeiXinCache cache = CACHE.get(CACHE_JS_API_TICKET_KEY);
        if (cache == null) {
            return "";
        }
        if (new Date().getTime() > cache.getExpiry().getTime()) {
            return "";
        }
        return cache.getValue().toString();
    }

    private static void putJSAPITicketToCache(String jsApiTicket) {
        WeiXinCache cache = new WeiXinCache();
        cache.setValue(jsApiTicket);
        cache.setExpiry(DateUtils.addSeconds((Date)new Date(), (int)5400));
        CACHE.put(CACHE_JS_API_TICKET_KEY, cache);
    }

    public static boolean isWeiXin(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgent)) {
            Pattern p = Pattern.compile("MicroMessenger/(\\d+).+");
            Matcher m = p.matcher(userAgent);
            String version = null;
            if (m.find()) {
                version = m.group(1);
            }
            return null != version && NumberUtils.toInt((String)version) >= 5;
        }
        return false;
    }
}

