/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.web.xml;

import cn.remex.util.Judgment;
import cn.remex.util.MapHelper;
import cn.remex.util.StringHelper;
import cn.remex.web.WebBsCvo;
import cn.remex.web.WebXmlHelper;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import org.apache.oro.text.regex.MatchResult;

public class XmlCvo
extends WebBsCvo {
    private static final long serialVersionUID = -5945791165016264396L;
    private Map<String, Object> parameters;
    private String pack;

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public XmlCvo(String pack) {
        this.pack = pack;
    }

    public XmlCvo() {
    }

    public String obtainXmlNode(String xml, Class<?> clazz) {
        XStreamAlias xsa = clazz.getAnnotation(XStreamAlias.class);
        if (null != xsa) {
            return this.obtainXmlNode(xml, xsa.value());
        }
        return this.obtainXmlNode(this.pack, StringHelper.getClassSimpleName(clazz));
    }

    public String obtainXmlNode(String xml, String className) {
        if (Judgment.nullOrBlank((Object)xml) || Judgment.nullOrBlank((Object)className)) {
            return null;
        }
        String fu = StringHelper.upperFirstLetter((String)className);
        String uc = className.toUpperCase();
        String lc = className.toLowerCase();
        String eflag = "(</" + className + ">)|(</" + fu + ">)|(</" + uc + ">)|(</" + lc + ">)";
        String s = "(((<" + className + ">)|(<" + fu + ">)|(<" + uc + ">)|(<" + lc + ">)){1}" + "(.*)" + "(" + eflag + "){1})";
        MatchResult mr = StringHelper.match((String)xml, (String)s, null);
        String returnXml = mr.group(1);
        System.out.println(returnXml);
        return returnXml;
    }

    @Override
    protected <T> T unpack(Class<T> clazz, String nodeName) {
        String xml = null;
        if (clazz != null && (null != (xml = this.obtainXmlNode(this.pack, clazz)) || null != (xml = this.obtainXmlNode(this.pack, nodeName)))) {
            return WebXmlHelper.unmarshall(clazz, xml, nodeName);
        }
        if (null == xml && null != this.parameters && "head".equals(nodeName)) {
            return (T)MapHelper.toObject(this.parameters, clazz);
        }
        return null;
    }
}

