/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.web;

import cn.remex.exception.JaxbException;
import cn.remex.reflect.ReflectUtil;
import cn.remex.util.Assert;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;

public final class WebXmlHelper {
    private static final Map<Class<?>, JAXBContext> JAXBCONTEXTS = new HashMap();
    private static final String xmlPrex = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    private static HashMap<Class<?>, XStream> _UnmarshallXStreamMap = new HashMap();
    private static HashMap<String, XStream> _MarshallXStreamMap = new HashMap();
    private static HashMap<Class<?>, XStream> _MarshallDefinXStreamMap = new HashMap();

    private static JAXBContext getJAXBContext(Class<?> clazz) {
        if (JAXBCONTEXTS.containsKey(clazz)) {
            return JAXBCONTEXTS.get(clazz);
        }
        try {
            JAXBContext curJaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            JAXBCONTEXTS.put(clazz, curJaxbContext);
            return curJaxbContext;
        }
        catch (JAXBException e) {
            throw new JaxbException("\u65e0\u6cd5\u751f\u6210JaxbContext\u5b9e\u4f8b\uff0c\u76ee\u6807\u7c7b\u4e3a\uff1a" + clazz.getName(), (Throwable)e);
        }
    }

    private static <T> String useJaxbMarshall(Class<T> clazz, Object XMLObject, String orgnCharset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXBContext curJaxbContext = WebXmlHelper.getJAXBContext(clazz);
        try {
            Marshaller marshaller = curJaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)orgnCharset);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(XMLObject, (OutputStream)baos);
            return baos.toString(orgnCharset);
        }
        catch (Exception e) {
            throw new JaxbException("\u89e3\u7ec4\u62a5\u6587\u5931\u8d25,\u5f02\u5e38\u539f\u56e0\u662f\uff1a", (Throwable)e);
        }
    }

    private static <T> T useJaxbUnmarshall(Class<T> clazz, String responseXml, String orgnCharset) {
        JAXBContext curJaxbContext = WebXmlHelper.getJAXBContext(clazz);
        Object ret = null;
        try {
            ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(responseXml.getBytes(orgnCharset));
            Unmarshaller curUnmarshaller = curJaxbContext.createUnmarshaller();
            Marshaller marshaller = curJaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)orgnCharset);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            ret = curUnmarshaller.unmarshal((InputStream)tInputStringStream);
            tInputStringStream.close();
        }
        catch (Exception e) {
            throw new JaxbException("\u89e3\u7ec4\u62a5\u6587\u5931\u8d25\uff0c\u62a5\u6587\u5185\u5bb9\u662f\uff1a" + responseXml + ",\u5f02\u5e38\u539f\u56e0\u662f\uff1a", (Throwable)e);
        }
        return (T)ret;
    }

    public static <T> T unmarshall(Class<T> c, String nodeName, String xml) {
        return WebXmlHelper.unmarshall(c, nodeName, xml, "UTF-8");
    }

    public static <T> T unmarshall(Class<T> c, String xml, String nodeName, String sourceCharset) {
        if (c.isAnnotationPresent(XmlRootElement.class)) {
            return WebXmlHelper.useJaxbUnmarshall(c, xml, sourceCharset);
        }
        XStream xStream = _UnmarshallXStreamMap.get(c);
        if (null == xStream) {
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
            xStream.processAnnotations(c);
            xStream.ignoreUnknownElements();
            xStream.aliasSystemAttribute(null, "class");
            xStream.alias(nodeName, c);
            _UnmarshallXStreamMap.put(c, xStream);
        }
        Assert.notNullAndEmpty((String)xml, (String)"XStream\u4e0d\u80fd\u5c06null\u5b57\u7b26\u4e32\u6216\u8005empty\u5b57\u7b26\u4e32\u6839\u636exml\u6807\u51c6\u8f6c\u5316\u4e3a\u5bf9\u8c61\u3002");
        return (T)xStream.fromXML(xml);
    }

    public static String marshall(Object object, Class<? extends Object> body, Class<? extends Object> extend) {
        return WebXmlHelper.marshall(object, body, extend, "body", "extend", "UTF-8");
    }

    public static <T> String marshall(Object bsRvo, Class<? extends Object> bodyClass, Class<? extends Object> extendClass, String bodyNode, String extendNode, String sourceCharset) {
        if (bsRvo.getClass().isAnnotationPresent(XmlRootElement.class)) {
            return WebXmlHelper.useJaxbMarshall(bsRvo.getClass(), bsRvo, sourceCharset);
        }
        String hashKey = ReflectUtil.hashCode(extendClass = extendClass == null ? Void.class : extendClass, bodyClass = bodyClass == null ? Void.class : bodyClass);
        XStream xStream = _MarshallXStreamMap.get(hashKey);
        if (null == xStream) {
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
            xStream.processAnnotations(bsRvo.getClass());
            xStream.autodetectAnnotations(true);
            xStream.aliasSystemAttribute(null, "class");
            xStream.aliasSystemAttribute(null, "reference");
            if (extendClass != null) {
                xStream.alias(extendNode, extendClass);
            }
            if (bodyClass != null) {
                xStream.alias(bodyNode, bodyClass);
                final XStream curXstream = xStream;
                xStream.registerConverter(new Converter(){

                    public boolean canConvert(Class type) {
                        if (!_MarshallDefinXStreamMap.containsKey(type) && type.getName().indexOf("$$EnhancerByCGLIB$$") > 0) {
                            curXstream.omitField(type, "CGLIB$BOUND");
                            curXstream.omitField(type, "CGLIB$CALLBACK_0");
                        }
                        return false;
                    }

                    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                        return null;
                    }

                    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    }
                });
            }
            _MarshallXStreamMap.put(hashKey, xStream);
        }
        return new StringBuffer().append(xmlPrex).append(xStream.toXML(bsRvo)).toString();
    }
}

