/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.soa.server.bus;

import cn.remex.RemexConstants;
import cn.remex.bs.BsNotFoundException;
import cn.remex.core.RemexApplication;
import cn.remex.rmi.RmiService;
import cn.remex.rmi.RmiServiceImpl;
import cn.remex.soa.SoaConfig;
import cn.remex.soa.server.bus.ProviderInfo;
import cn.remex.soa.xmlbeans.ProviderRegisterInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;
import org.springframework.remoting.rmi.RmiServiceExporter;

public class SoaBusConfig {
    private static Map<String, TreeMap<String, ProviderInfo>> providerRegisterInfoConfig = new HashMap<String, TreeMap<String, ProviderInfo>>();
    private static Map<String, ProviderInfo> providerHosts = new HashMap<String, ProviderInfo>();

    public static Map<String, TreeMap<String, ProviderInfo>> getProviderRegisterInfoConfig() {
        return providerRegisterInfoConfig;
    }

    public static void setProviderRegisterInfoConfig(Map<String, TreeMap<String, ProviderInfo>> providerRegisterInfoConfig) {
        SoaBusConfig.providerRegisterInfoConfig = providerRegisterInfoConfig;
    }

    public static Map<String, ProviderInfo> getProviderHosts() {
        return providerHosts;
    }

    public static void setProviderHosts(Map<String, ProviderInfo> providerHosts) {
        SoaBusConfig.providerHosts = providerHosts;
    }

    public static void register(ProviderRegisterInfo registerInfo) {
        ProviderInfo providerInfo = new ProviderInfo(registerInfo.getAddress(), registerInfo.getPort(), true);
        String address_port = providerInfo.getKey();
        if (providerHosts.containsKey(address_port)) {
            providerInfo = providerHosts.get(address_port);
        }
        providerInfo.setStatus(true);
        providerHosts.put(address_port, providerInfo);
        for (String serviceKey : registerInfo.getServices()) {
            ProviderInfo serviceRegisterInfo;
            TreeMap<String, ProviderInfo> serviceProviderMap = providerRegisterInfoConfig.get(serviceKey);
            if (null == serviceProviderMap) {
                serviceProviderMap = new TreeMap();
                providerRegisterInfoConfig.put(serviceKey, serviceProviderMap);
            }
            if (null == (serviceRegisterInfo = serviceProviderMap.get(address_port))) {
                serviceProviderMap.put(address_port, providerInfo);
                continue;
            }
            RemexConstants.logger.warn((Object)("\u66f4\u65b0\u670d\u52a1\u6ce8\u518c:" + serviceKey + "\uff0c\u670d\u52a1\u5730\u5740\uff1a" + address_port));
        }
    }

    public static boolean containsProviderService(String bsName, String bsCmd) {
        return providerRegisterInfoConfig.containsKey(bsName + ":" + bsCmd);
    }

    public static void startSoaServer() {
        try {
            System.setProperty("java.rmi.server.hostname", SoaConfig.getHostName());
            RemexApplication.registerBeanDefinition((String)"registry", RmiRegistryFactoryBean.class, (String)"singleton", (Object[])new Object[]{"port", SoaConfig.getPort()}, null);
            RemexApplication.registerBeanDefinition((String)"service", RmiServiceImpl.class, (String)"singleton", null, null);
            RemexApplication.registerBeanDefinition((String)"serviceExporter", RmiServiceExporter.class, (String)"singleton", (Object[])new Object[]{"serviceName", "RmiService", "servicePort", SoaConfig.getServicePort(), "serviceInterface", RmiService.class}, (String[])new String[]{"registry", "registry", "service", "service"});
            RemexApplication.getBean((String)"serviceExporter");
            RemexConstants.logger.info((Object)"RMI\u670d\u52a1\u542f\u52a8\u6210\u529f\uff01");
        }
        catch (Exception e) {
            RemexConstants.logger.error((Object)"RMI\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static ProviderInfo obtainProviderInfo(String bsName, String bsCmd) {
        TreeMap<String, ProviderInfo> serviceInfo = providerRegisterInfoConfig.get(bsName + ":" + bsCmd);
        ProviderInfo retInfo = null;
        ProviderInfo firstInfo = null;
        boolean isFirst = true;
        for (ProviderInfo info : serviceInfo.values()) {
            if (info.isStatus()) {
                retInfo = info;
                break;
            }
            if (!isFirst) continue;
            firstInfo = info;
            isFirst = false;
        }
        if (null != firstInfo) {
            serviceInfo.put(firstInfo.getKey(), serviceInfo.remove(firstInfo.getKey()));
        }
        if (null != retInfo) {
            return retInfo;
        }
        throw new BsNotFoundException("\u63d0\u4f9b\u670d\u52a1\u4e3b\u673a\u72b6\u6001\u5747\u4e0d\u6b63\u5e38\uff1a" + bsName + ":" + bsCmd);
    }
}

