/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.soa.server.bus;

import cn.remex.RemexConstants;
import cn.remex.bs.BsRvo;
import cn.remex.bs.Extend;
import cn.remex.bs.Head;
import cn.remex.quartz.SchedulerJob;
import cn.remex.rmi.RmiCvo;
import cn.remex.rmi.RmiRvo;
import cn.remex.soa.client.SoaClient;
import cn.remex.soa.server.bus.ProviderInfo;
import cn.remex.soa.server.bus.SoaBusConfig;
import cn.remex.soa.server.bus.SoaBusController;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SoaBusAlivedJob
extends SchedulerJob {
    public void jobExecute(JobExecutionContext cxt) throws JobExecutionException {
        for (ProviderInfo info : SoaBusConfig.getProviderHosts().values()) {
            if (!info.isStatus()) {
                RemexConstants.logger.warn((Object)(info.getAddress() + ":" + info.getPort() + "\u670d\u52a1\u63d0\u4f9b\u72b6\u6001\u5f02\u5e38,\u76ee\u524d\u5c1a\u672a\u6062\u590d\uff01"));
                continue;
            }
            boolean isBad = false;
            try {
                RmiCvo rmiCvo = new RmiCvo();
                Head head = SoaClient.obtainHead();
                head.setBs("SoaProviderStatusBs");
                head.setBsCmd("obtainProviderInfo");
                rmiCvo.setHead(head);
                rmiCvo.setBody(null);
                rmiCvo.setExtend(new Extend(true, "OK"));
                RmiRvo rmiRvo = new RmiRvo();
                rmiRvo.setHead(new Head());
                BsRvo rvo = SoaBusController.invokeService(info, false, head.getBs(), head.getBsCmd(), rmiCvo, rmiRvo);
                isBad = !rvo.getExtend().isStatus();
            }
            catch (Exception e) {
                isBad = true;
                RemexConstants.logger.error((Object)("\u670d\u52a1\u63d0\u4f9b\u72b6\u6001\u5f02\u5e38\uff1a" + info.getKey()), (Throwable)e);
            }
            info.setStatus(!isBad);
        }
    }
}

