/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.soa.client;

import cn.remex.RemexConstants;
import cn.remex.bs.BsRvo;
import cn.remex.bs.Extend;
import cn.remex.bs.Head;
import cn.remex.core.RemexApplication;
import cn.remex.reflect.ReflectUtil;
import cn.remex.rmi.RmiCvo;
import cn.remex.rmi.RmiRvo;
import cn.remex.rmi.RmiService;
import cn.remex.soa.SoaConfig;
import cn.remex.soa.SoaException;
import cn.remex.soa.SoaUtils;
import cn.remex.util.DateHelper;
import cn.remex.util.Judgment;
import cn.remex.util.StringHelper;
import com.caucho.hessian.client.HessianProxyFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import org.apache.oro.text.regex.MatchResult;

public class SoaClient
implements RemexConstants {
    private static HessianProxyFactory hessianProxyFactory = new HessianProxyFactory();

    public static void setConnectionTimeout(long ms) {
        hessianProxyFactory.setConnectTimeout(ms);
    }

    public static void setReadTimeout(long ms) {
        hessianProxyFactory.setReadTimeout(ms);
    }

    public static BsRvo invokeService(String rssr, Object body, Extend extend) {
        return SoaClient.invokeService(rssr, SoaClient.obtainHead(), body, extend, null, 0);
    }

    public static BsRvo invokeService(String rssr, Object body, Extend extend, String host, int port) {
        return SoaClient.invokeService(rssr, SoaClient.obtainHead(), body, extend, host, port);
    }

    public static Head obtainHead() {
        Head head = (Head)RemexApplication.getBean(Head.class, (String[])new String[0]);
        if (SoaConfig.isHasHeadConfig()) {
            ReflectUtil.setProperties((Object)head, SoaConfig.getHeadConfig(), (ReflectUtil.SPFeature[])new ReflectUtil.SPFeature[0]);
        }
        head.setTransDate(DateHelper.getNow((String)"yyyy-MM-dd hh:mm:ss"));
        return head;
    }

    public static void main(String[] args) {
        SoaClient.invokeService("remex:soa://AitpQueryVehicleInfoBs:execute", null, new Object(), null, null, 0);
    }

    public static BsRvo invokeService(String rssr, Head head, Object body, Extend extend, String host, int port) {
        logger.info((Object)("\u68c0\u67e5\u670d\u52a1RSSR\u5b57\u7b26\u4e32\uff1a" + rssr));
        MatchResult rssrParts = StringHelper.match((String)rssr, (String)"remex:soa(:(\\w+))?://(([\\w\\d\\-._]+)(:(\\d+))?/)?((\\w+)/)?(\\w+)(:(\\w+))?", (String)"\u975e\u6cd5\u7684Remex Soa Search Route");
        String rssrType = rssrParts.group(2);
        String rssrHost = rssrParts.group(4);
        String rssrPort = rssrParts.group(6);
        String rssrApp = rssrParts.group(8);
        String rssrBs = rssrParts.group(9);
        String rssrBsCmd = rssrParts.group(11);
        String type = Judgment.nullOrBlank((Object)rssrType) ? SoaConfig.getBusServer().get("type") : rssrType;
        host = Judgment.nullOrBlank((Object)rssrHost) ? host : rssrHost;
        port = Judgment.nullOrBlank((Object)rssrPort) ? port : Integer.parseInt(rssrPort);
        String app = Judgment.nullOrBlank((Object)rssrApp) ? "Remex2" : rssrApp;
        head.setBs(rssrBs);
        head.setBsCmd(Judgment.nullOrBlank((Object)rssrBsCmd) ? "execute" : rssrBsCmd);
        if (Judgment.nullOrBlank((Object)head.getSessionId())) {
            head.setSessionId("0");
        }
        if (Judgment.nullOrBlank((Object)head.getFlowNo())) {
            head.setFlowNo("0");
        }
        if (Judgment.nullOrBlank((Object)head.getTransNo())) {
            head.setTransNo("" + ("" + rssr + head.getChannelOper()).hashCode() + (int)Math.random() * 1000);
        }
        try {
            head.setTraderIP(InetAddress.getLocalHost().getHostAddress().toString());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        logger.info((Object)("\u51c6\u5907\u53d1\u8d77\u670d\u52a1\u8bf7\u6c42\uff1atype=" + type + ";host=" + host + ";port=" + port + ";app=" + app + ";bs=" + rssrBs + ";bsCmd=" + rssrBsCmd));
        if ("xml".equals(type)) {
            return SoaClient.invokeXml(host, port, head, extend, body);
        }
        if ("hessian".equals(type)) {
            return SoaClient.invokeHessian(host, port, app, head, extend, body);
        }
        if ("rmi".equals(type)) {
            return SoaClient.invokeRmi(host, port, head, extend, body);
        }
        return SoaClient.invokeHessian(host, port, app, head, extend, body);
    }

    private static BsRvo invokeHessian(String host, int port, String app, Head head, Extend extend, Object body) {
        RmiCvo rmiCvo = new RmiCvo();
        rmiCvo.setHead(head);
        rmiCvo.setBody(body);
        rmiCvo.setExtend(extend);
        RmiRvo rmiRvo = new RmiRvo();
        rmiRvo.setHead(new Head());
        String url = Judgment.nullOrBlank((Object)host) ? SoaConfig.obtainHessianUrl() : SoaConfig.obtainHessianUrl(host, port, app);
        logger.info((Object)("Hessian\u670d\u52a1\u8c03\u7528\uff1aurl=" + url));
        try {
            SoaUtils.saveSoaXml(rmiCvo, true);
            RmiService api = (RmiService)hessianProxyFactory.create(RmiService.class, url);
            BsRvo bsRvo = api.invoke(rmiCvo, rmiRvo);
            SoaUtils.saveSoaXml(bsRvo, true);
            return bsRvo;
        }
        catch (MalformedURLException e) {
            throw new SoaException("Hessian\u670d\u52a1URL\u9519\u8bef,\u8bf7\u5728application.xml\u4e2d\u7684soaConfig \u7684 bsuServer Map\u4e2d\u6b63\u786e\u914d\u7f6eHessian Url\u5c5e\u6027\uff0chessianUrl = http://host:port/hs/SoaService", e);
        }
    }

    private static BsRvo invokeXml(String host, int port, Head head, Extend extend, Object body) {
        throw new SoaException("\u7cfb\u7edf\u6682\u4e0d\u652f\u6301Xml\u65b9\u5f0f\u8c03\u7528Soa\u670d\u52a1\u3002");
    }

    private static BsRvo invokeRmi(String host, int port, Head head, Extend extend, Object body) {
        RmiCvo rmiCvo = new RmiCvo();
        rmiCvo.setHead(head);
        rmiCvo.setBody(body);
        rmiCvo.setExtend(extend);
        RmiRvo rmiRvo = new RmiRvo();
        rmiRvo.setHead(new Head());
        String url = Judgment.nullOrBlank((Object)host) ? SoaConfig.obtainServiceUrl() : SoaConfig.obtainServiceUrl(host, port);
        RmiService rmis = SoaConfig.obtainRmiService(url);
        SoaUtils.saveSoaXml(rmiCvo, true);
        BsRvo bsRvo = rmis.invoke(rmiCvo, rmiRvo);
        SoaUtils.saveSoaXml(bsRvo, true);
        return bsRvo;
    }

    static {
        SoaClient.setConnectionTimeout(180000L);
        SoaClient.setReadTimeout(180000L);
    }
}

