/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.soa;

import cn.remex.core.RemexApplication;
import cn.remex.rmi.RmiService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

public class SoaConfig {
    private static boolean hasRemexSoaConfig;
    private static String mode;
    private static String type;
    private static String hostName;
    private static String address;
    private static int port;
    private static int servicePort;
    private static int xmlServicePort;
    private static boolean hessianHasStarted;
    private static Map<String, Object> headConfig;
    private static boolean hasHeadConfig;
    private static Map<String, Object> busServer;
    private static boolean refreshStubOnConnectFailure;
    private static boolean cacheStub;
    private static String serviceUrl;
    private static String xmlServiceUrl;
    private static String hessianUrl;
    public static String winSoaXmlPath;
    public static String linuxSoaXmlPath;
    public static String winSoaClientXmlPath;
    public static String linuxSoaClientXmlPath;

    public static String getWinSoaXmlPath() {
        return winSoaXmlPath;
    }

    public void setWinSoaXmlPath(String winSoaXmlPath) {
        SoaConfig.winSoaXmlPath = winSoaXmlPath;
    }

    public static String getLinuxSoaXmlPath() {
        return linuxSoaXmlPath;
    }

    public static String getWinSoaClientXmlPath() {
        return winSoaClientXmlPath;
    }

    public void setWinSoaClientXmlPath(String winSoaClientXmlPath) {
        SoaConfig.winSoaClientXmlPath = winSoaClientXmlPath;
    }

    public static String getLinuxSoaClientXmlPath() {
        return linuxSoaClientXmlPath;
    }

    public void setLinuxSoaClientXmlPath(String linuxSoaClientXmlPath) {
        SoaConfig.linuxSoaClientXmlPath = linuxSoaClientXmlPath;
    }

    public void setLinuxSoaXmlPath(String linuxSoaXmlPath) {
        SoaConfig.linuxSoaXmlPath = linuxSoaXmlPath;
    }

    public static String obtainServiceUrl(String address, int prot) {
        return "rmi://" + address + ":" + prot + "/RmiService";
    }

    public static String obtainServiceUrl() {
        if (null == serviceUrl) {
            serviceUrl = "rmi://" + hostName + ":" + port + "/RmiService";
        }
        return serviceUrl;
    }

    public static String obtainXmlServiceUrl(String address, int port) {
        return "http://" + address + ":" + port + "/web/XmlService";
    }

    public static String obtainHessianUrl(String address, int port, String app) {
        return "http://" + address + ":" + port + "/" + app + "/hs/SoaService";
    }

    public static String obtainHessianUrl() {
        if (null == hessianUrl) {
            hessianUrl = "http://" + hostName + ":" + port + "/hs/SoaService";
        }
        return hessianUrl;
    }

    public static String obtainXmlServiceUrl() {
        if (null == serviceUrl) {
            xmlServiceUrl = "http://" + hostName + ":" + port + "/web/XmlService";
        }
        return xmlServiceUrl;
    }

    public static RmiService obtainRmiService(String serviceUrl) {
        if (RemexApplication.getContext().containsBean(serviceUrl)) {
            return (RmiService)RemexApplication.getBean((String)serviceUrl);
        }
        RmiService rmis = (RmiService)RemexApplication.getBean((String)serviceUrl, RmiProxyFactoryBean.class, (String)"prototype", (Object[])new Object[]{"serviceUrl", serviceUrl, "serviceInterface", RmiService.class, "refreshStubOnConnectFailure", refreshStubOnConnectFailure, "cacheStub", cacheStub}, (String[])new String[0]);
        return rmis;
    }

    public void setBusServer(Map<String, Object> busServerConfig) {
        busServer = busServerConfig;
        serviceUrl = "rmi://" + busServerConfig.get("address") + ":" + (busServerConfig.get("port") == null ? Integer.valueOf(port) : busServerConfig.get("port")) + "/RmiService";
        xmlServiceUrl = "http://" + busServerConfig.get("address") + ":" + (busServerConfig.get("xmlServicePort") == null ? Integer.valueOf(xmlServicePort) : busServerConfig.get("xmlServicePort")) + "/web/XmlService";
        hessianUrl = (String)busServerConfig.get("hessianUrl");
    }

    public void setHeadConfig(Map<String, Object> headConfig) {
        SoaConfig.headConfig = headConfig;
        hasHeadConfig = null != headConfig && headConfig.size() > 0;
    }

    public static String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        SoaConfig.mode = mode;
    }

    public static String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        SoaConfig.hostName = hostName;
    }

    public static String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        SoaConfig.address = address;
    }

    public static int getPort() {
        return port;
    }

    public void setPort(int port) {
        SoaConfig.port = port;
    }

    public static int getServicePort() {
        return servicePort;
    }

    public void setServicePort(int servicePort) {
        SoaConfig.servicePort = servicePort;
    }

    public static int getXmlServicePort() {
        return xmlServicePort;
    }

    public static void setXmlServicePort(int xmlServicePort) {
        SoaConfig.xmlServicePort = xmlServicePort;
    }

    public static Map<String, Object> getHeadConfig() {
        return headConfig;
    }

    public static boolean isHasRemexSoaConfig() {
        return hasRemexSoaConfig;
    }

    public static boolean isHasHeadConfig() {
        return hasHeadConfig;
    }

    public static String getServiceUrl() {
        return serviceUrl;
    }

    public static Map<String, Object> getBusServer() {
        return busServer;
    }

    public static String getType() {
        return type;
    }

    public void setType(String type) {
        SoaConfig.type = type;
    }

    public static boolean isHessianHasStarted() {
        return hessianHasStarted;
    }

    public void setHessianHasStarted(boolean hessianHasStarted) {
        SoaConfig.hessianHasStarted = hessianHasStarted;
    }

    static {
        mode = "client";
        type = "rmi";
        hostName = "127.0.0.1";
        address = "127.0.0.1";
        port = 8088;
        servicePort = 8089;
        xmlServicePort = 7001;
        hessianHasStarted = false;
        busServer = new HashMap<String, Object>();
        refreshStubOnConnectFailure = true;
        cacheStub = true;
        serviceUrl = null;
        xmlServiceUrl = null;
        hessianUrl = null;
        winSoaXmlPath = null == RemexApplication.getBean((String)"CONFIG") || null == ((Map)RemexApplication.getBean((String)"CONFIG")).get("Soa_XmlFilePath_Win") ? "D:\\AppRoot\\Remex2\\SoaXmls\\" : (String)((Map)RemexApplication.getBean((String)"CONFIG")).get("Soa_XmlFilePath_Win");
        linuxSoaXmlPath = null == RemexApplication.getBean((String)"CONFIG") || null == ((Map)RemexApplication.getBean((String)"CONFIG")).get("Soa_XmlFilePath_Linux") ? "/data/Remex2/SoaXmls/" : (String)((Map)RemexApplication.getBean((String)"CONFIG")).get("Soa_XmlFilePath_Linux");
        winSoaClientXmlPath = null == RemexApplication.getBean((String)"CONFIG") || null == ((Map)RemexApplication.getBean((String)"CONFIG")).get("SoaClient_XmlFilePath_Win") ? "D:\\AppRoot\\Remex2\\SoaClientXmls\\" : (String)((Map)RemexApplication.getBean((String)"CONFIG")).get("SoaClient_XmlFilePath_Win");
        linuxSoaClientXmlPath = null == RemexApplication.getBean((String)"CONFIG") || null == ((Map)RemexApplication.getBean((String)"CONFIG")).get("SoaClient_XmlFilePath_Linux") ? "/data/Remex2/SoaClientXmls/" : (String)((Map)RemexApplication.getBean((String)"CONFIG")).get("SoaClient_XmlFilePath_Linux");
    }
}

