/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.net;

import cn.remex.exception.NetException;
import cn.remex.exception.RIOException;
import cn.remex.exception.StringHandleException;
import cn.remex.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public final class HttpHelper {
    public static String sendXml(String url, String requestXml) {
        return HttpHelper.sendXml(url, requestXml, "UTF-8");
    }

    public static String sendXml(String url, String requestXml, String charset) {
        Assert.notNull((Object)requestXml, (String)"\u53d1\u9001\u7684xml\u62a5\u6587\u5185\u5bb9\u4e0d\u80fd\u4e3aNull\uff01");
        String responseStr = null;
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            HttpURLConnection httpConnection = (HttpURLConnection)new URL(url).openConnection();
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "text/html");
            httpConnection.setRequestProperty("Accept-Charset", charset);
            httpConnection.setRequestProperty("contentType", charset);
            httpConnection.setDoOutput(true);
            httpConnection.setDoInput(true);
            httpConnection.setAllowUserInteraction(true);
            httpConnection.connect();
            output = new BufferedOutputStream(httpConnection.getOutputStream());
            byte[] buffer = requestXml.getBytes(charset);
            output.write(buffer);
            output.flush();
            BufferedInputStream inputStream = new BufferedInputStream(httpConnection.getInputStream());
            buffer = new byte[1024];
            int count = 0;
            ByteArrayOutputStream streamXML = new ByteArrayOutputStream();
            input = new BufferedInputStream(inputStream);
            while ((count = input.read(buffer)) != -1) {
                streamXML.write(buffer, 0, count);
            }
            byte[] iXMLData = streamXML.toByteArray();
            httpConnection.disconnect();
            responseStr = new String(iXMLData, charset);
            Assert.notNull((Object)responseStr, (String)"\u5bf9\u65b9\u670d\u52a1\u76f8\u5e94\u62a5\u6587\u4e3anull!");
        }
        catch (Exception e) {
            throw new NetException("HttpPostXml\u5931\u8d25\uff0curl\u4e3a\uff1a" + url, (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                    output.flush();
                    output.close();
                }
                catch (Exception f) {
                    f.printStackTrace();
                }
            }
        }
        return responseStr;
    }

    public static void doReq(String url, String body) throws HttpException, IOException {
        PostMethod postMethod = new PostMethod(url);
        NameValuePair data = new NameValuePair("data", body);
        postMethod.setRequestBody(new NameValuePair[]{data});
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod((HttpMethod)postMethod);
        postMethod.releaseConnection();
    }

    public static String obtainHttpPack(InputStream input) {
        byte[] buffer = new byte[1024];
        int count = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BufferedInputStream bfInput = new BufferedInputStream(input);
            while ((count = bfInput.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new RIOException("\u4eceHttpServletRequest\u4e2d\u8bfb\u53d6\u6d41\u5f02\u5e38\uff01", (Throwable)e);
        }
        try {
            String content = baos.toString("UTF-8");
            return content;
        }
        catch (UnsupportedEncodingException e) {
            throw new StringHandleException("\u8bfb\u53d6Post\u8bf7\u6c42\u62a5\u6587\u65f6\uff0c\u8fdb\u884cUTF-8\u8f6c\u7801\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
    }
}

