/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.bs;

import cn.remex.RemexConstants;
import cn.remex.bs.Bs;
import cn.remex.bs.BsCvo;
import cn.remex.bs.BsException;
import cn.remex.bs.BsNotFoundException;
import cn.remex.bs.BsRvo;
import cn.remex.bs.Extend;
import cn.remex.bs.anno.BsAnnotation;
import cn.remex.core.RemexApplication;
import cn.remex.core.RemexRefreshable;
import cn.remex.exception.IllegalBsArgumentException;
import cn.remex.exception.NestedException;
import cn.remex.reflect.ReflectUtil;
import cn.remex.util.Judgment;
import cn.remex.util.PackageUtil;
import cn.remex.util.StringHelper;
import cn.remex.validator.RemexValidateContext;
import cn.remex.validator.RemexValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BsFactory
implements RemexRefreshable {
    private static Map<String, Class<?>> bsMap = new HashMap();
    private static List<String> bsPackages = new ArrayList<String>();

    public void setBsPackages(List<String> bsPackages) {
        BsFactory.bsPackages = bsPackages;
        BsFactory.scanPackagesForBs();
    }

    private static Map<String, Class<?>> scanPackagesForBs() {
        bsPackages.add("cn.remex");
        bsMap = new HashMap();
        for (String bsPackage : bsPackages) {
            RemexConstants.logger.info((Object)("sacnPackeagesForBs:" + bsPackage));
            Set orbs = PackageUtil.getClasses((String)bsPackage);
            for (Class c : orbs) {
                if (!Bs.class.isAssignableFrom(c) && !c.isAnnotationPresent(BsAnnotation.class) || c.isInterface()) continue;
                String bsName = StringHelper.getClassSimpleName((Type)c);
                if (bsMap.containsKey(bsName)) {
                    throw new IllegalBsArgumentException("\u521d\u59cb\u5316Bs\u51fa\u9519,\u6709\u91cd\u590d\u7684bsName", bsName);
                }
                bsMap.put(bsName, c);
            }
        }
        return bsMap;
    }

    public static Map<String, Method> obtainBsCmd(String bsName) {
        Class<?> bsClass = bsMap.get(bsName);
        HashMap<String, Method> bsCmdMap = new HashMap<String, Method>();
        for (Method m : bsClass.getMethods()) {
            Class<?>[] pts = m.getParameterTypes();
            Class<?> rt = m.getReturnType();
            if (!BsRvo.class.isAssignableFrom(rt) || pts == null || pts.length != 2 || !BsCvo.class.isAssignableFrom(pts[0]) || !BsRvo.class.isAssignableFrom(pts[1])) continue;
            bsCmdMap.put(m.getName(), m);
        }
        return bsCmdMap;
    }

    public static List<String> obtainServiceList() {
        ArrayList<String> serviceMap = new ArrayList<String>();
        for (String bsName : bsMap.keySet()) {
            Map<String, Method> bsCmdMap = BsFactory.obtainBsCmd(bsName);
            for (String bsCmd : bsCmdMap.keySet()) {
                serviceMap.add(bsName + ":" + bsCmd);
            }
        }
        return serviceMap;
    }

    public static Map<String, Class<?>> getBsMap() {
        return bsMap;
    }

    public static void setBsMap(Map<String, Class<?>> bsMap) {
        BsFactory.bsMap = bsMap;
    }

    public static List<String> getBsPackages() {
        return bsPackages;
    }

    public static boolean containsBs(String bsName) {
        Class<?> bs = bsMap.get(bsName);
        return null != bs;
    }

    public static Object createBs(String bsName) {
        Class<?> bs = bsMap.get(bsName);
        if (null == bs) {
            throw new BsNotFoundException("\u4e1a\u52a1\u670d\u52a1" + bsName + "\u672a\u5f00\u53d1\u6216\u8005\u88ab\u7ba1\u7406\u5458\u6452\u5f03\uff0c\u8bf7\u8054\u7cfb\u7ad9\u70b9\u7ba1\u7406\u5458\uff01");
        }
        try {
            return RemexApplication.getBean(bs, (String[])new String[0]);
        }
        catch (Exception e) {
            throw new IllegalBsArgumentException(bsName, (Throwable)e);
        }
    }

    public static BsRvo executeBs(BsCvo bsCvo, BsRvo bsRvo) {
        boolean bsAnnoIsPresent = false;
        BsAnnotation bsAnno = null;
        try {
            RemexValidateContext rc = RemexValidator.validate((Object)bsCvo, (Class[])new Class[0]);
            if (rc.hasConstraintViolation()) {
                throw new BsException(rc.getDefaultConstraintMsg());
            }
            String bsName = bsCvo.getHead().getBs();
            String bsCmd = bsCvo.getHead().getBsCmd();
            bsCmd = Judgment.nullOrBlank((Object)bsCmd) ? "execute" : bsCmd;
            RemexConstants.logger.info((Object)("Executing Bs=" + bsName + ";bsCmd=" + bsCmd));
            Object bs = BsFactory.createBs(bsName);
            Method declareBsCmdMethod = ReflectUtil.getMethod(bsMap.get(bsName), (String)bsCmd, (Class[])new Class[]{BsCvo.class, BsRvo.class});
            bsAnnoIsPresent = declareBsCmdMethod.isAnnotationPresent(BsAnnotation.class);
            if (bsAnnoIsPresent) {
                bsAnno = declareBsCmdMethod.getAnnotation(BsAnnotation.class);
                if (bsAnno.bsCvoBodyClass() != Void.class) {
                    bsCvo.setBodyClass(bsAnno.bsCvoBodyClass());
                }
                if (null == bsCvo.getExtendClass()) {
                    bsCvo.setExtendClass(bsAnno.bsCvoExtendClass());
                }
            }
            ReflectUtil.copyProperties((Object)bsRvo.getHead(), (Object)bsCvo.getHead(), (ReflectUtil.SPFeature[])new ReflectUtil.SPFeature[0]);
            Method cglibBsCmdMethod = ReflectUtil.getMethod(bs.getClass(), (String)bsCvo.getHead().getBsCmd(), (Class[])new Class[]{BsCvo.class, BsRvo.class});
            bsRvo = (BsRvo)ReflectUtil.invokeMethod((Method)cglibBsCmdMethod, (Object)bs, (Object[])new Object[]{bsCvo, bsRvo});
            RemexValidateContext rr = RemexValidator.validate((Object)bsRvo, (Class[])new Class[0]);
            if (rr.hasConstraintViolation()) {
                throw new BsException(rr.getDefaultConstraintMsg());
            }
        }
        catch (Exception e) {
            Extend rvoExtend;
            String errorCode;
            RemexConstants.logger.error((Object)"\u8c03\u7528\u672c\u5730Bs\u670d\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            String msg = Judgment.nullOrBlank((Object)e.getMessage()) ? e.toString() : e.getMessage();
            String string = errorCode = e instanceof NestedException ? ((NestedException)e).getErrorCode() : "E00001";
            if (bsAnnoIsPresent) {
                try {
                    rvoExtend = bsAnno.bsRvoExtendClass().getConstructor(Boolean.TYPE, String.class).newInstance(false, msg);
                }
                catch (Exception e1) {
                    rvoExtend = new Extend(false, msg);
                }
            } else {
                rvoExtend = new Extend(false, msg.toString());
            }
            rvoExtend.setErrorCode(errorCode);
            rvoExtend.setErrorMsg(msg);
            bsRvo.setExtend(rvoExtend);
        }
        return bsRvo;
    }

    public void refresh() {
        BsFactory.scanPackagesForBs();
    }

    static {
        BsFactory.scanPackagesForBs();
    }
}

