/*
 * Decompiled with CFR 0.152.
 */
package cn.remex;

import cn.remex.RemexAuthUtils;
import cn.remex.RemexConstants;
import cn.remex.core.RemexApplication;
import cn.remex.exception.FilterException;
import cn.remex.exception.NestedException;
import cn.remex.reflect.ReflectUtil;
import cn.remex.util.Judgment;
import cn.remex.web.RemexRewritUrl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemexFilter
implements Filter,
RemexConstants {
    private FilterConfig filterConfig = null;
    private ArrayList<String> permitDir = new ArrayList();
    private ArrayList<String> permitServiceDir = new ArrayList();
    private HashMap<String, String> publicUri = new HashMap();
    private String loginUri = "/RemexUI/opensource/login.jsp";
    private String errorUri = "/RemexUI/opensource/error.jsp";
    private String urlRoot = null;

    public void destroy() {
    }

    public void doFilter(ServletRequest sRequest, ServletResponse sResponse, FilterChain chain) throws IOException, ServletException {
        boolean logIt;
        long startTime = System.currentTimeMillis();
        HttpServletRequest request = (HttpServletRequest)sRequest;
        HttpServletResponse response = (HttpServletResponse)sResponse;
        String uri = request.getRequestURI();
        String svlPath = request.getServletPath();
        String uriParams = request.getQueryString();
        try {
            if (RemexAuthUtils.needAuthenticate && !this.isPublic(request) && !((Boolean)ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod(RemexAuthUtils.authenticateBtx.getClass(), (String)"authenticate", (Class[])new Class[]{HttpServletRequest.class}), (Object)RemexAuthUtils.authenticateBtx, (Object[])new Object[]{request})).booleanValue()) {
                request.setAttribute("redirectURI", (Object)(this.urlRoot + request.getServletPath()));
                request.getRequestDispatcher(this.loginUri).forward((ServletRequest)request, (ServletResponse)response);
            } else if (RemexRewritUrl.isRemexWebEncodeUrl(svlPath)) {
                request.getRequestDispatcher(RemexRewritUrl.decodeUrl(svlPath)).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                chain.doFilter(sRequest, sResponse);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u670d\u52a1\u8fdb\u5165struts\u4e4b\u524d\u5df2\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            request.setAttribute("exception", (Object)e);
            request.getRequestDispatcher(this.errorUri).forward((ServletRequest)request, (ServletResponse)response);
        }
        boolean bl = logIt = uri.endsWith("jsp") || uri.endsWith("action");
        if (logIt) {
            StringBuilder msg = new StringBuilder();
            msg.append("Handle request [").append(uri).append("?").append(uriParams).append("] took ").append(System.currentTimeMillis() - startTime).append(" ms.").append("\r\n==============================================================\r\n");
            timeLogger.info((Object)msg);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        try {
            RemexApplication.refresh();
        }
        catch (NestedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FilterException("RemexFilter\u521d\u59cb\u5316\u9519\u8bef\uff0c\u9879\u76ee\u542f\u52a8\u5931\u8d25\uff01", (Throwable)e);
        }
        String className = this.filterConfig.getInitParameter("AuthenticateBean");
        String needAuthenticateString = this.filterConfig.getInitParameter("needAuthenticate");
        String needLogMsg = this.filterConfig.getInitParameter("needLogMsg");
        String loginUri = this.filterConfig.getInitParameter("loginUri");
        if (Judgment.notEmpty((Object)loginUri)) {
            this.loginUri = loginUri;
        }
        for (String dir : this.filterConfig.getInitParameter("permitDir").split(";")) {
            this.permitDir.add(dir.trim());
        }
        for (String uri : this.filterConfig.getInitParameter("publicUri").split(";")) {
            String[] uriParts = uri.split("\\?");
            this.publicUri.put(uriParts[0].trim(), uriParts.length == 2 ? uriParts[1].trim() : null);
        }
        for (String dir : this.filterConfig.getInitParameter("permitServiceDir").split(";")) {
            this.permitServiceDir.add(dir.trim());
        }
        this.urlRoot = this.filterConfig.getServletContext().getContextPath();
        if ("true".equals(needAuthenticateString)) {
            logger.info((Object)"\u7cfb\u7edf\u914d\u7f6e\u4e3a\u9700\u8981\u8eab\u4efd\u9a8c\u8bc1\uff0c\u5f53\u524d\u91c7\u7528Filter\uff0bURI\u9a8c\u8bc1\u6a21\u5f0f\u3002");
            if (Judgment.nullOrBlank((Object)className)) {
                className = "cn.remex.cert.AuthenticateBean";
            }
            String authenticateBeanClassName = className;
            try {
                RemexAuthUtils.authenticateBtx = ReflectUtil.invokeNewInstance((String)"cn.remex.cert.AuthenticateBtx");
                ReflectUtil.invokeMethod((String)"setNeedLogMsg", (Object)RemexAuthUtils.authenticateBtx, (Object[])new Object[]{needLogMsg});
                RemexAuthUtils.needAuthenticate = true;
                System.out.println("\u7cfb\u7edf\u914d\u7f6e\u4e3a\u9700\u8981\u8eab\u4efd\u9a8c\u8bc1\uff0cAuthenticateBean\u662f" + authenticateBeanClassName);
                Class.forName(authenticateBeanClassName).newInstance();
            }
            catch (Exception e) {
                System.out.println("\u52a0\u8f7d\u9a8c\u8bc1\u6a21\u5757\u5931\u8d25!");
                RemexAuthUtils.needAuthenticate = false;
            }
        } else {
            System.out.println("\u7cfb\u7edf\u914d\u7f6e\u4e3a\u901a\u884c\u6a21\u5f0f\uff0c\u65e0\u9700\u9a8c\u8bc1\u5373\u53ef\u8bbf\u95ee\u3002");
        }
    }

    private boolean isPublic(HttpServletRequest request) {
        String uri = request.getServletPath();
        for (String dir : this.permitDir) {
            if (!uri.startsWith(dir)) continue;
            return true;
        }
        String queryString = request.getQueryString();
        String permitQuery = this.publicUri.get(uri);
        if (this.publicUri.containsKey(uri) && (null == permitQuery || null != queryString && queryString.startsWith(permitQuery))) {
            return true;
        }
        for (String dir : this.permitServiceDir) {
            if (!uri.startsWith(dir)) continue;
            return true;
        }
        return false;
    }
}

