/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.zhlh.Tiny.util.CommonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;

public class IdCardUtil {
    private static Hashtable<String, String> city = new Hashtable();
    static final Date MINIMAL_BIRTH_DATE = new Date(-2209017600000L);
    String id;
    Integer sex;
    String birthDay;
    String province;
    Boolean validate;

    public IdCardUtil(String id) {
        this.id = id;
        this.validate = this.validate(id);
        this.sex = IdCardUtil.getSex(id);
        this.birthDay = IdCardUtil.getBirthDay(id);
        this.province = IdCardUtil.getProvince(id);
    }

    public Integer getSex() {
        return this.sex;
    }

    public String getBirthDay() {
        return this.birthDay;
    }

    public Boolean getValidate() {
        return this.validate;
    }

    public String[] guessPeriodOfValidity() {
        String[] days = this.birthDay.split("-");
        int birthYear = Integer.parseInt(days[0]);
        if (birthYear >= 1990) {
            return new String[]{birthYear + 16 + days[1] + days[2], birthYear + 16 + 10 + days[1] + days[2]};
        }
        if (birthYear >= 1980 && birthYear <= 1989) {
            return new String[]{"2015" + days[1] + days[2], "2035" + days[1] + days[2]};
        }
        if (birthYear < 1960) {
            return new String[]{"2005" + days[1] + days[2], "\u957f\u671f\u6709\u6548"};
        }
        return new String[]{"2005" + days[1] + days[2], "2025" + days[1] + days[2]};
    }

    public boolean validate(String IDStr) {
        if (CommonUtil.isEmpty(IDStr)) {
            return false;
        }
        if ((IDStr = IDStr.toUpperCase()).length() != 18 && IDStr.length() != 15) {
            return false;
        }
        String Ai = IDStr.length() == 18 ? IDStr.substring(0, 17) : IDStr.substring(0, 6) + "19" + IDStr.substring(6, 15);
        if (!StringUtils.isNumeric((CharSequence)Ai)) {
            return false;
        }
        String strYear = Ai.substring(6, 10);
        String strMonth = Ai.substring(10, 12);
        String strDay = Ai.substring(12, 14);
        GregorianCalendar gc = new GregorianCalendar();
        try {
            Date birthDate = new SimpleDateFormat("yyyy-MM-dd").parse(IdCardUtil.getBirthDay(IDStr));
            if (null == birthDate || gc.get(1) - Integer.parseInt(strYear) > 150 || birthDate.after(new Date()) || birthDate.before(MINIMAL_BIRTH_DATE)) {
                return false;
            }
        }
        catch (NumberFormatException | ParseException e) {
            return false;
        }
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) == 0) {
            return false;
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) == 0) {
            return false;
        }
        if (city.get(Ai.substring(0, 2)) == null) {
            return false;
        }
        Ai = Ai + IdCardUtil.calculateVerifyCode(Ai);
        return IDStr.length() != 18 || Ai.equals(IDStr);
    }

    public static Integer getSex(String id) {
        return (id.length() == 18 ? Integer.parseInt(id.substring(16, 17)) : (id.length() == 15 ? Integer.parseInt(id.substring(15)) : 1)) % 2 == 0 ? 2 : 1;
    }

    public static String getBirthDay(String id) {
        String Ai = id.length() == 18 ? id : id.substring(0, 6) + "19" + id.substring(6, 15);
        String strYear = Ai.substring(6, 10);
        String strMonth = Ai.substring(10, 12);
        String strDay = Ai.substring(12, 14);
        return strYear + "-" + strMonth + "-" + strDay;
    }

    public static Integer getAge(String id) {
        if (CommonUtil.isEmpty(id)) {
            return -1;
        }
        if (id.length() == 18 || id.length() == 15) {
            String idNew = id.length() == 18 ? id : id.substring(0, 6) + "19" + id.substring(6, 15);
            int year = Integer.parseInt(idNew.substring(6, 10));
            Calendar calendar = Calendar.getInstance();
            int age = calendar.get(1) - year;
            return age;
        }
        return -1;
    }

    public static String getProvince(String id) {
        return city.get(id.substring(0, 2));
    }

    static char calculateVerifyCode(CharSequence cardNumber) {
        char[] Vi = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int[] Wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            char ch = cardNumber.charAt(i);
            sum += (ch - 48) * Wi[i];
        }
        return Vi[sum % 11];
    }

    private static void init() {
        city.put("11", "\u5317\u4eac");
        city.put("12", "\u5929\u6d25");
        city.put("13", "\u6cb3\u5317");
        city.put("14", "\u5c71\u897f");
        city.put("15", "\u5185\u8499\u53e4");
        city.put("21", "\u8fbd\u5b81");
        city.put("22", "\u5409\u6797");
        city.put("23", "\u9ed1\u9f99\u6c5f");
        city.put("31", "\u4e0a\u6d77");
        city.put("32", "\u6c5f\u82cf");
        city.put("33", "\u6d59\u6c5f");
        city.put("34", "\u5b89\u5fbd");
        city.put("35", "\u798f\u5efa");
        city.put("36", "\u6c5f\u897f");
        city.put("37", "\u5c71\u4e1c");
        city.put("41", "\u6cb3\u5357");
        city.put("42", "\u6e56\u5317");
        city.put("43", "\u6e56\u5357");
        city.put("44", "\u5e7f\u4e1c");
        city.put("45", "\u5e7f\u897f");
        city.put("46", "\u6d77\u5357");
        city.put("50", "\u91cd\u5e86");
        city.put("51", "\u56db\u5ddd");
        city.put("52", "\u8d35\u5dde");
        city.put("53", "\u4e91\u5357");
        city.put("54", "\u897f\u85cf");
        city.put("61", "\u9655\u897f");
        city.put("62", "\u7518\u8083");
        city.put("63", "\u9752\u6d77");
        city.put("64", "\u5b81\u590f");
        city.put("65", "\u65b0\u7586");
        city.put("71", "\u53f0\u6e7e");
        city.put("81", "\u9999\u6e2f");
        city.put("82", "\u6fb3\u95e8");
        city.put("91", "\u56fd\u5916");
    }

    static {
        IdCardUtil.init();
    }
}

