/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.zhlh.Tiny.util.CommonUtil;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static DateTimeFormatter dateTimeHmsFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");
    public static final String PATTERN_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, PATTERN_DATE);
    }

    public static String formatDateTime(Date dateTime) {
        return DateUtil.formatDate(dateTime, PATTERN_DATE_TIME);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.addDays((Date)date, (int)amount);
    }

    public static Date truncate(Date date, int field) {
        return DateUtils.truncate((Date)date, (int)field);
    }

    public static Date parseDate(String strDate, String pattern) {
        if (CommonUtil.isEmpty(strDate)) {
            return null;
        }
        SimpleDateFormat fmtDate = null;
        ParsePosition pos = new ParsePosition(0);
        fmtDate = new SimpleDateFormat(pattern);
        try {
            return fmtDate.parse(strDate, pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.format(date);
    }

    public static String getCurrentDateTime() {
        return new DateTime().toString(dateTimeFormatter);
    }

    public static String getCurrentDate() {
        return new DateTime().toString(dateFormatter);
    }

    public static String getNow(String pattern) {
        DateTimeFormatter format = DateTimeFormat.forPattern((String)pattern);
        return new DateTime().toString(format);
    }

    public static String getCurrentHmsDate() {
        return new DateTime().toString(dateTimeHmsFormatter);
    }

    public static DateTime praseDate(String dataStr) {
        return DateTime.parse((String)dataStr, (DateTimeFormatter)dateFormatter);
    }

    public static int getMonthsDifference(String start, String end) {
        DateTime date1 = DateUtil.praseDate(start);
        DateTime date2 = DateUtil.praseDate(end);
        Months month = Months.monthsBetween((ReadableInstant)date1, (ReadableInstant)date2);
        return month.getMonths();
    }
}

