/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.zhlh.Tiny.util.CookieUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtil {
    public static final Pattern intranetIpPattern = Pattern.compile("(^127\\.)|(^10\\.)|(^172\\.1[6-9]\\.)|(^172\\.2[0-9]\\.)|(^172\\.3[0-1]\\.)|(^192\\.168\\.)|(^::1$)");
    private static final Logger LOG = LoggerFactory.getLogger(CookieUtil.class);

    public static String getBasePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String port = request.getServerPort() == 80 ? "" : ":" + request.getServerPort();
        String basePath = request.getScheme() + "://" + request.getServerName() + port + contextPath;
        return basePath;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    public static boolean isGet(HttpServletRequest request) {
        return "get".equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPost(HttpServletRequest request) {
        return "post".equalsIgnoreCase(request.getMethod());
    }

    public static String getIp(HttpServletRequest req) {
        return req.getRemoteAddr();
    }

    public static boolean isIntranet(HttpServletRequest req) {
        return WebUtil.isIntranet(WebUtil.getIp(req));
    }

    public static boolean isIntranet(String ip) {
        return intranetIpPattern.matcher(ip).find();
    }

    public static String getUrl(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        String queryString = req.getQueryString();
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }

    public static String encodeUrl(String url) {
        try {
            if (StringUtils.isEmpty((CharSequence)url)) {
                return "";
            }
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String decodeUrl(String url) {
        try {
            if (StringUtils.isEmpty((CharSequence)url)) {
                return "";
            }
            URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
}

