/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class CookieUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CookieUtil.class);
    private static final int DEFAULT_MAX_AGE = 604800;

    public static String getValueByName(String name, HttpServletRequest request) {
        String value = "";
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)name);
        if (cookie != null) {
            value = cookie.getValue();
        }
        LOG.info("Util: CookieUtil.getValueByName, Args: {}, Return: {}.", (Object)name, (Object)value);
        return value;
    }

    public static void add(String name, String value, int expiry, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(request.getServerName());
        cookie.setPath("/");
        cookie.setMaxAge(expiry);
        response.addCookie(cookie);
        LOG.info("Util: CookieUtil.add, Args: [{}, {}, {}].", new Object[]{name, value, expiry});
    }

    public static void add(String name, String value, HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.add(name, value, 604800, request, response);
    }

    public static void delete(String name, HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.add(name, "", 0, request, response);
    }
}

