/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.page.intercepetor;

import com.zhlh.Tiny.page.bean.Page;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MybatisSpringPageInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisSpringPageInterceptor.class);
    public static final String MYSQL = "mysql";
    public static final String ORACLE = "oracle";
    protected String databaseType;
    protected ThreadLocal<Page> pageThreadLocal = new ThreadLocal();

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        if (!databaseType.equalsIgnoreCase(MYSQL) && !databaseType.equalsIgnoreCase(ORACLE)) {
            throw new PageNotSupportException("Page not support for the type of database, database type [" + databaseType + "]");
        }
        this.databaseType = databaseType;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String databaseType = properties.getProperty("databaseType");
        if (databaseType != null) {
            this.setDatabaseType(databaseType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            Page page = this.pageThreadLocal.get();
            if (page == null) {
                return invocation.proceed();
            }
            RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
            StatementHandler delegate = (StatementHandler)ReflectUtil.getFieldValue(handler, "delegate");
            BoundSql boundSql = delegate.getBoundSql();
            Connection connection = (Connection)invocation.getArgs()[0];
            this.prepareAndCheckDatabaseType(connection);
            if (page.getTotalPage() > -1) {
                if (log.isTraceEnabled()) {
                    log.trace("\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u603b\u9875\u6570, \u4e0d\u9700\u8981\u518d\u67e5\u8be2\u603b\u6570.");
                }
            } else {
                Object parameterObj = boundSql.getParameterObject();
                MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue(delegate, "mappedStatement");
                this.queryTotalRecord(page, parameterObj, mappedStatement, connection);
            }
            String sql = boundSql.getSql();
            log.info("\u8bbe\u7f6e\u5206\u9875\u524dSQL:" + sql);
            String pageSql = this.buildPageSql(page, sql);
            if (log.isDebugEnabled()) {
                log.debug("\u5206\u9875\u65f6, \u751f\u6210\u5206\u9875pageSql: " + pageSql);
            }
            log.info("\u751f\u6210\u5206\u9875pageSql: " + pageSql);
            ReflectUtil.setFieldValue(boundSql, "sql", pageSql);
            return invocation.proceed();
        }
        Page<?> page = this.findPageObject(invocation.getArgs()[1]);
        if (page == null) {
            if (log.isTraceEnabled()) {
                log.trace("\u6ca1\u6709Page\u5bf9\u8c61\u4f5c\u4e3a\u53c2\u6570, \u4e0d\u662f\u5206\u9875\u67e5\u8be2.");
            }
            return invocation.proceed();
        }
        if (log.isTraceEnabled()) {
            log.trace("\u68c0\u6d4b\u5230\u5206\u9875Page\u5bf9\u8c61, \u4f7f\u7528\u5206\u9875\u67e5\u8be2.");
        }
        invocation.getArgs()[1] = this.extractRealParameterObject(invocation.getArgs()[1]);
        this.pageThreadLocal.set(page);
        try {
            Object resultObj = invocation.proceed();
            if (resultObj instanceof List) {
                page.setResults((List)resultObj);
            }
            Object object = resultObj;
            return object;
        }
        finally {
            this.pageThreadLocal.remove();
        }
    }

    protected Page<?> findPageObject(Object parameterObj) {
        if (parameterObj instanceof Page) {
            return (Page)parameterObj;
        }
        if (parameterObj instanceof Map) {
            for (Object val : ((Map)parameterObj).values()) {
                if (!(val instanceof Page)) continue;
                return (Page)val;
            }
        }
        return null;
    }

    protected Object extractRealParameterObject(Object parameterObj) {
        Map parameterMap;
        if (parameterObj instanceof Map && (parameterMap = (Map)parameterObj).size() == 2) {
            boolean springMapWithNoParamName = true;
            for (Object key : parameterMap.keySet()) {
                if (!(key instanceof String)) {
                    springMapWithNoParamName = false;
                    break;
                }
                String keyStr = (String)key;
                if ("0".equals(keyStr) || "1".equals(keyStr)) continue;
                springMapWithNoParamName = false;
                break;
            }
            if (springMapWithNoParamName) {
                for (Object value : parameterMap.values()) {
                    if (value instanceof Page) continue;
                    return value;
                }
            }
        }
        return parameterObj;
    }

    protected void prepareAndCheckDatabaseType(Connection connection) throws SQLException {
        if (this.databaseType == null) {
            String productName = connection.getMetaData().getDatabaseProductName();
            if (log.isTraceEnabled()) {
                log.trace("Database productName: " + productName);
            }
            if ((productName = productName.toLowerCase()).indexOf(MYSQL) != -1) {
                this.databaseType = MYSQL;
            } else if (productName.indexOf(ORACLE) != -1) {
                this.databaseType = ORACLE;
            } else {
                throw new PageNotSupportException("Page not support for the type of database, database product name [" + productName + "]");
            }
            if (log.isInfoEnabled()) {
                log.info("\u81ea\u52a8\u68c0\u6d4b\u5230\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e3a: " + this.databaseType);
            }
        }
    }

    protected String buildPageSql(Page<?> page, String sql) {
        if (MYSQL.equalsIgnoreCase(this.databaseType)) {
            return this.buildMysqlPageSql(page, sql);
        }
        if (ORACLE.equalsIgnoreCase(this.databaseType)) {
            return this.buildOraclePageSql(page, sql);
        }
        return sql;
    }

    protected String buildMysqlPageSql(Page<?> page, String sql) {
        int offset = (page.getPageNo() - 1) * page.getPageSize();
        return sql + " limit " + offset + "," + page.getPageSize();
    }

    protected String buildOraclePageSql(Page<?> page, String sql) {
        int offset = (page.getPageNo() - 1) * page.getPageSize() + 1;
        StringBuilder sb = new StringBuilder(sql);
        sb.insert(0, "select u.*, rownum r from (").append(") u where rownum < ").append(offset + page.getPageSize());
        sb.insert(0, "select * from (").append(") where r >= ").append(offset);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryTotalRecord(Page<?> page, Object parameterObject, MappedStatement mappedStatement, Connection connection) throws SQLException {
        BoundSql boundSql = mappedStatement.getBoundSql(page);
        String sql = boundSql.getSql();
        String countSql = this.buildCountSql(sql);
        if (log.isDebugEnabled()) {
            log.debug("\u5206\u9875\u65f6, \u751f\u6210countSql: " + countSql);
        }
        List parameterMappings = boundSql.getParameterMappings();
        BoundSql countBoundSql = new BoundSql(mappedStatement.getConfiguration(), countSql, parameterMappings, parameterObject);
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, parameterObject, countBoundSql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(countSql);
            parameterHandler.setParameters(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                long totalRecord = rs.getLong(1);
                page.setTotalRecord(totalRecord);
            }
        }
        finally {
            block17: {
                block16: {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block16;
                            log.warn("\u5173\u95edResultSet\u65f6\u5f02\u5e38.", (Throwable)e);
                        }
                    }
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block17;
                        log.warn("\u5173\u95edPreparedStatement\u65f6\u5f02\u5e38.", (Throwable)e);
                    }
                }
            }
        }
    }

    protected String buildCountSql(String sql) {
        int index = sql.indexOf("from");
        return "select count(*) " + sql.substring(index);
    }

    public static class PageNotSupportException
    extends RuntimeException {
        public PageNotSupportException() {
        }

        public PageNotSupportException(String message, Throwable cause) {
            super(message, cause);
        }

        public PageNotSupportException(String message) {
            super(message);
        }

        public PageNotSupportException(Throwable cause) {
            super(cause);
        }
    }

    private static class ReflectUtil {
        private ReflectUtil() {
        }

        public static Object getFieldValue(Object obj, String fieldName) {
            Object result = null;
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                field.setAccessible(true);
                try {
                    result = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        private static Field getField(Object obj, String fieldName) {
            Field field = null;
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return field;
        }

        public static void setFieldValue(Object obj, String fieldName, String fieldValue) {
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                try {
                    field.setAccessible(true);
                    field.set(obj, fieldValue);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

