/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerIdEntry;
import kafka.log.ProducerIdEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r5t!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\tq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003a\u0001\"!D\r\n\u0005iq!!B*i_J$\bB\u0002\u000f\nA\u0003%\u0001$\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002BqAH\u0005C\u0002\u0013%q$\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001%A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\r\t\u0005\bW%\u0011\r\u0011\"\u0003 \u0003!\u0019%o\u0019$jK2$\u0007BB\u0017\nA\u0003%\u0001%A\u0005De\u000e4\u0015.\u001a7eA!9q&\u0003b\u0001\n\u0013y\u0012a\u0004)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3\t\rEJ\u0001\u0015!\u0003!\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007\u0005C\u00044\u0013\t\u0007I\u0011B\u0010\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG\r\u0003\u00046\u0013\u0001\u0006I\u0001I\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007\u0005C\u00048\u0013\t\u0007I\u0011B\u0010\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0005\u0007s%\u0001\u000b\u0011\u0002\u0011\u0002'A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0011\t\u000fmJ!\u0019!C\u0005?\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG\r\u0003\u0004>\u0013\u0001\u0006I\u0001I\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002BqaP\u0005C\u0002\u0013%q$\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\"1\u0011)\u0003Q\u0001\n\u0001\n\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u0011\u001d\u0019\u0015B1A\u0005\n}\ta\u0002V5nKN$\u0018-\u001c9GS\u0016dG\r\u0003\u0004F\u0013\u0001\u0006I\u0001I\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA!9q)\u0003b\u0001\n\u0013y\u0012\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\r\u0003\u0004J\u0013\u0001\u0006I\u0001I\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0011\u001dY\u0015B1A\u0005\n}\tQcQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\r\u0003\u0004N\u0013\u0001\u0006I\u0001I\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA!9q*\u0003b\u0001\n\u0013y\u0012AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007BB)\nA\u0003%\u0001%A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\r\t\u0005\b'&\u0011\r\u0011\"\u0003U\u000351VM]:j_:|eMZ:fiV\tQ\u000b\u0005\u0002\u000e-&\u0011qK\u0004\u0002\u0004\u0013:$\bBB-\nA\u0003%Q+\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\t\u000fmK!\u0019!C\u0005)\u0006I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007;&\u0001\u000b\u0011B+\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004`\u0013\t\u0007I\u0011\u0002+\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\"1\u0011-\u0003Q\u0001\nU\u000ba\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000f\t\u0005\bG&\u0011\r\u0011\"\u0001e\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\tQ\r\u0005\u0002ge6\tqM\u0003\u0002iS\u0006)A/\u001f9fg*\u0011!n[\u0001\taJ|Go\\2pY*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]4\u0003\rM\u001b\u0007.Z7b\u0011\u0019)\u0018\u0002)A\u0005K\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0003bB<\n\u0005\u0004%\t\u0001Z\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\t\reL\u0001\u0015!\u0003f\u0003U\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0002BQa_\u0005\u0005\u0002q\fAB]3bINs\u0017\r]:i_R$2!`A\r!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0006\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017q\u0001c\u0001\u0005\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003\u001fA\u0013x\u000eZ;dKJLE-\u00128uefDq!a\u0007{\u0001\u0004\ti\"\u0001\u0003gS2,\u0007\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB%\u0001\u0002j_&!\u0011qEA\u0011\u0005\u00111\u0015\u000e\\3\t\u000f\u0005-\u0012\u0002\"\u0003\u0002.\u0005iqO]5uKNs\u0017\r]:i_R$b!a\f\u00026\u0005]\u0002cA\u0007\u00022%\u0019\u00111\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037\tI\u00031\u0001\u0002\u001e!A\u0011\u0011HA\u0015\u0001\u0004\tY$A\u0004f]R\u0014\u0018.Z:\u0011\u0011\u0005u\u0012qIA&\u0003'i!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\b[V$\u0018M\u00197f\u0015\r\t)ED\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u007f\u00111!T1q!\ri\u0011QJ\u0005\u0004\u0003\u001fr!\u0001\u0002'p]\u001eDq!a\u0015\n\t\u0013\t)&\u0001\bjgNs\u0017\r]:i_R4\u0015\u000e\\3\u0015\t\u0005]\u0013Q\f\t\u0004\u001b\u0005e\u0013bAA.\u001d\t9!i\\8mK\u0006t\u0007\u0002CA0\u0003#\u0002\r!!\u0019\u0002\t9\fW.\u001a\t\u0005\u0003G\nYG\u0004\u0003\u0002f\u0005\u001d\u0004cAA\u0001\u001d%\u0019\u0011\u0011\u000e\b\u0002\rA\u0013X\rZ3g\u0013\r9\u0013Q\u000e\u0006\u0004\u0003Sr\u0001\"CA9\u0013E\u0005I\u0011AA:\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u000f\u0016\u0004+\u0006]4FAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\re\"\u0001\u0006b]:|G/\u0019;j_:LA!a\"\u0002~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0007\u000b)\u0011\u0001!a#\u0014\u000b\u0005%E\"!$\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%\u0005\u0003\u0015)H/\u001b7t\u0013\u0011\t9*!%\u0003\u000f1{wmZ5oO\"Y\u00111TAE\u0005\u000b\u0007I\u0011AAO\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!a(\u0011\t\u0005\u0005\u00161U\u0007\u0002W&\u0019\u0011QU6\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"Y\u0011\u0011VAE\u0005\u0003\u0005\u000b\u0011BAP\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003bCAW\u0003\u0013\u0013)\u0019!C\u0001\u0003_\u000ba\u0001\\8h\t&\u0014XCAA\u000f\u0011-\t\u0019,!#\u0003\u0002\u0003\u0006I!!\b\u0002\u000f1|w\rR5sA!Q\u0011qWAE\u0005\u000b\u0007I\u0011\u0001+\u000235\f\u0007\u0010\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0005\u000b\u0003w\u000bII!A!\u0002\u0013)\u0016AG7bqB\u0013x\u000eZ;dKJLE-\u0012=qSJ\fG/[8o\u001bN\u0004\u0003bB\n\u0002\n\u0012\u0005\u0011q\u0018\u000b\t\u0003\u0003\f\u0019-!2\u0002HB\u0019\u0001\"!#\t\u0011\u0005m\u0015Q\u0018a\u0001\u0003?C\u0001\"!,\u0002>\u0002\u0007\u0011Q\u0004\u0005\n\u0003o\u000bi\f%AA\u0002UC!\"a3\u0002\n\n\u0007I\u0011BAg\u0003]1\u0018\r\\5eCR,7+Z9vK:\u001cWMT;nE\u0016\u00148/\u0006\u0002\u0002X!I\u0011\u0011[AEA\u0003%\u0011qK\u0001\u0019m\u0006d\u0017\u000eZ1uKN+\u0017/^3oG\u0016tU/\u001c2feN\u0004\u0003BCAk\u0003\u0013\u0013\r\u0011\"\u0003\u0002X\u0006I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003wA\u0011\"a7\u0002\n\u0002\u0006I!a\u000f\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b\u0005\u0003\u0006\u0002`\u0006%\u0005\u0019!C\u0005\u0003C\fQ\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$XCAA&\u0011)\t)/!#A\u0002\u0013%\u0011q]\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0018\u0003SD!\"a;\u0002d\u0006\u0005\t\u0019AA&\u0003\rAH%\r\u0005\n\u0003_\fI\t)Q\u0005\u0003\u0017\na\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$\b\u0005\u0003\u0006\u0002t\u0006%\u0005\u0019!C\u0005\u0003C\fa\u0002\\1tiNs\u0017\r](gMN,G\u000f\u0003\u0006\u0002x\u0006%\u0005\u0019!C\u0005\u0003s\f!\u0003\\1tiNs\u0017\r](gMN,Go\u0018\u0013fcR!\u0011qFA~\u0011)\tY/!>\u0002\u0002\u0003\u0007\u00111\n\u0005\n\u0003\u007f\fI\t)Q\u0005\u0003\u0017\nq\u0002\\1tiNs\u0017\r](gMN,G\u000f\t\u0005\u000b\u0005\u0007\tII1A\u0005\n\t\u0015\u0011aC8oO>Lgn\u001a+y]N,\"Aa\u0002\u0011\u0011\t%!qBA&\u0005'i!Aa\u0003\u000b\u0007\t5A%\u0001\u0003vi&d\u0017\u0002\u0002B\t\u0005\u0017\u0011q\u0001\u0016:fK6\u000b\u0007\u000fE\u0002\t\u0005+I1Aa\u0006\u0003\u0005-!\u0006P\\'fi\u0006$\u0017\r^1\t\u0013\tm\u0011\u0011\u0012Q\u0001\n\t\u001d\u0011\u0001D8oO>Lgn\u001a+y]N\u0004\u0003B\u0003B\u0010\u0003\u0013\u0013\r\u0011\"\u0003\u0003\u0006\u0005\u0001RO\u001c:fa2L7-\u0019;fIRChn\u001d\u0005\n\u0005G\tI\t)A\u0005\u0005\u000f\t\u0011#\u001e8sKBd\u0017nY1uK\u0012$\u0006P\\:!\u0011!\u00119#!#\u0005\u0002\t%\u0012a\u00054jeN$XK\\:uC\ndWm\u00144gg\u0016$XC\u0001B\u0016!\u0015i!Q\u0006B\u0019\u0013\r\u0011yC\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tM\"\u0011H\u0007\u0003\u0005kQ1Aa\u000e\u0005\u0003\u0019\u0019XM\u001d<fe&!!1\bB\u001b\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u0005\t\u0005\u007f\tI\t\"\u0001\u0003B\u00051rN\u001c%jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,G\r\u0006\u0003\u00020\t\r\u0003\u0002\u0003B#\u0005{\u0001\r!a\u0013\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l\u0011!\u0011I%!#\u0005\u0002\t-\u0013\u0001\u00064jeN$XK\u001c3fG&$W\rZ(gMN,G/\u0006\u0002\u0003NA)QB!\f\u0002L!A!\u0011KAE\t\u0003\t\t/\u0001\u0007nCB,e\u000eZ(gMN,G\u000f\u0003\u0005\u0003V\u0005%E\u0011\u0001B,\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXC\u0001B-!!\u0011YF!\u0019\u0002L\u0005MQB\u0001B/\u0015\u0011\u0011y&a\u0011\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA%\u0005;B\u0001B!\u001a\u0002\n\u0012\u0005\u0011QZ\u0001\bSN,U\u000e\u001d;z\u0011!\u0011I'!#\u0005\n\t-\u0014\u0001\u00057pC\u00124%o\\7T]\u0006\u00048\u000f[8u)\u0019\tyC!\u001c\u0003r!A!q\u000eB4\u0001\u0004\tY%\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u0011\tM$q\ra\u0001\u0003\u0017\n1bY;se\u0016tG\u000fV5nK\"I!qOAE\t\u0003\u0011!\u0011P\u0001\u0012Y>\fG\r\u0015:pIV\u001cWM]#oiJLH\u0003BA\u0018\u0005wB\u0001B! \u0003v\u0001\u0007\u00111C\u0001\u0006K:$(/\u001f\u0005\t\u0005\u0003\u000bI\t\"\u0003\u0003\u0004\u0006\t\u0012n\u001d)s_\u0012,8-\u001a:FqBL'/\u001a3\u0015\r\u0005]#Q\u0011BE\u0011!\u00119Ia A\u0002\u0005-\u0013!D2veJ,g\u000e\u001e+j[\u0016l5\u000f\u0003\u0005\u0003\f\n}\u0004\u0019AA\n\u0003=\u0001(o\u001c3vG\u0016\u0014\u0018\nZ#oiJL\b\u0002\u0003BH\u0003\u0013#\tA!%\u0002-I,Wn\u001c<f\u000bb\u0004\u0018N]3e!J|G-^2feN$B!a\f\u0003\u0014\"A!q\u0011BG\u0001\u0004\tY\u0005\u0003\u0005\u0003\u0018\u0006%E\u0011\u0001BM\u0003E!(/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a\u000b\t\u0003_\u0011YJ!(\u0003\"\"A!q\u000eBK\u0001\u0004\tY\u0005\u0003\u0005\u0003 \nU\u0005\u0019AA&\u00031awnZ#oI>3gm]3u\u0011!\u00119I!&A\u0002\u0005-\u0003\u0002\u0003BS\u0003\u0013#\tAa*\u0002\u001bA\u0014X\r]1sKV\u0003H-\u0019;f)\u0019\u0011IKa,\u00034B\u0019\u0001Ba+\n\u0007\t5&A\u0001\nQe>$WoY3s\u0003B\u0004XM\u001c3J]\u001a|\u0007\u0002\u0003BY\u0005G\u0003\r!a\u0013\u0002\u0015A\u0014x\u000eZ;dKJLE\r\u0003\u0005\u00036\n\r\u0006\u0019AA,\u00039aw.\u00193j]\u001e4%o\\7M_\u001eD\u0001B!/\u0002\n\u0012\u0005!1X\u0001\u0007kB$\u0017\r^3\u0015\t\u0005=\"Q\u0018\u0005\t\u0005\u007f\u00139\f1\u0001\u0003*\u0006Q\u0011\r\u001d9f]\u0012LeNZ8\t\u0011\t\r\u0017\u0011\u0012C\u0001\u0005\u000b\f!#\u001e9eCR,W*\u00199F]\u0012|eMZ:fiR!\u0011q\u0006Bd\u0011!\u0011IM!1A\u0002\u0005-\u0013A\u00037bgR|eMZ:fi\"A!QZAE\t\u0003\u0011y-A\u0005mCN$XI\u001c;ssR!!\u0011\u001bBj!\u0015i!QFA\n\u0011!\u0011\tLa3A\u0002\u0005-\u0003\u0002\u0003Bl\u0003\u0013#\tA!7\u0002\u0019Q\f7.Z*oCB\u001c\bn\u001c;\u0015\u0005\u0005=\u0002\u0002\u0003Bo\u0003\u0013#\tAa\u0013\u0002)1\fG/Z:u':\f\u0007o\u001d5pi>3gm]3u\u0011!\u0011\t/!#\u0005\u0002\t-\u0013\u0001F8mI\u0016\u001cHo\u00158baNDw\u000e^(gMN,G\u000f\u0003\u0005\u0003f\u0006%E\u0011\u0002Bt\u0003II7\u000f\u0015:pIV\u001cWM\u001d*fi\u0006Lg.\u001a3\u0015\r\u0005]#\u0011\u001eBv\u0011!\u0011YIa9A\u0002\u0005M\u0001\u0002\u0003B8\u0005G\u0004\r!a\u0013\t\u0011\t=\u0018\u0011\u0012C\u0001\u0005c\fA\u0002\u001e:v]\u000e\fG/\u001a%fC\u0012$B!a\f\u0003t\"A!q\u000eBw\u0001\u0004\tY\u0005\u0003\u0005\u0003x\u0006%E\u0011\u0002B}\u0003\u0001\u0012X-\\8wK\u00163\u0018n\u0019;fI>swm\\5oOR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005=\"1 \u0005\t\u0005{\u0014)\u00101\u0001\u0003\u0000\u0006\u0011R\r\u001f9je\u0016$\u0007K]8ek\u000e,'/\u00133t!\u0019\u0019\taa\u0001\u0002L5\u0011\u00111I\u0005\u0005\u0007\u000b\t\u0019EA\u0002TKRD\u0001b!\u0003\u0002\n\u0012%11B\u0001\u001fe\u0016lwN^3V]J,\u0007\u000f\\5dCR,G\r\u0016:b]N\f7\r^5p]N$B!a\f\u0004\u000e!A1qBB\u0004\u0001\u0004\tY%\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\t\u0007'\tI\t\"\u0001\u0003Z\u0006AAO];oG\u0006$X\r\u0003\u0005\u0004\u0018\u0005%E\u0011AB\r\u0003-\u0019w.\u001c9mKR,G\u000b\u001f8\u0015\t\u0005-31\u0004\u0005\t\u0007;\u0019)\u00021\u0001\u0004 \u0005a1m\\7qY\u0016$X\r\u001a+y]B\u0019\u0001b!\t\n\u0007\r\r\"A\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000e\u0003\u0005\u0004(\u0005%E\u0011AB\u0015\u0003U!W\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016$B!a\f\u0004,!A1qBB\u0013\u0001\u0004\tY\u0005\u000b\u0003\u0004&\r=\u0002\u0003BAH\u0007cIAaa\r\u0002\u0012\nQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\t\u0011\r]\u0012\u0011\u0012C\u0005\u0007s\t\u0011\u0003\\5tiNs\u0017\r]:i_R4\u0015\u000e\\3t+\t\u0019Y\u0004E\u0003\u007f\u0007{\ti\"\u0003\u0003\u0004@\u0005E!\u0001\u0002'jgRD\u0001ba\u0011\u0002\n\u0012%1QI\u0001\u0013_2$Wm\u001d;T]\u0006\u00048\u000f[8u\r&dW-\u0006\u0002\u0004HA)QB!\f\u0002\u001e!A11JAE\t\u0013\u0019)%\u0001\nmCR,7\u000f^*oCB\u001c\bn\u001c;GS2,\u0007\u0002CB(\u0003\u0013#Ia!\u0015\u0002'\u0011,G.\u001a;f':\f\u0007o\u001d5pi\u001aKG.Z:\u0015\t\u0005=21\u000b\u0005\u000b\u0007+\u001ai\u0005%AA\u0002\r]\u0013!\u00039sK\u0012L7-\u0019;f!\u001di1\u0011LA&\u0003/J1aa\u0017\u000f\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0006\u0004`\u0005%\u0015\u0013!C\u0005\u0007C\nQ\u0004Z3mKR,7K\\1qg\"|GOR5mKN$C-\u001a4bk2$H%M\u000b\u0003\u0007GRCaa\u0016\u0002x!\"\u0011\u0011RB4!\u0011\tyi!\u001b\n\t\r-\u0014\u0011\u0013\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private final File logDir;
    private final int maxProducerIdExpirationMs;
    private final boolean validateSequenceNumbers;
    private final Map<Object, ProducerIdEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerIdEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private boolean validateSequenceNumbers() {
        return this.validateSequenceNumbers;
    }

    private Map<Object, ProducerIdEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TxnMetadata)x$1.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TxnMetadata)x$2.getValue()).firstOffset());
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : var1_1));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$3)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerIdEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        while (true) {
            Option<File> option;
            if ((option = this.latestSnapshotFile()) instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                try {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading producer state from snapshot file ", " for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getName(), this.topicPartition()})));
                    Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, logStartOffset, currentTime, producerEntry)));
                    loadedProducers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                        this.loadProducerEntry(entry);
                        return BoxedUnit.UNIT;
                    });
                    this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFilename(file.getName()));
                    this.lastMapOffset_$eq(this.lastSnapOffset());
                    return;
                }
                catch (CorruptSnapshotException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot file at ", " is corrupt: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getPath(), e.getMessage()})));
                    boolean bl = Files.deleteIfExists(file.toPath());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    this.lastSnapOffset_$eq(logStartOffset);
                    this.lastMapOffset_$eq(logStartOffset);
                    return;
                }
                throw new MatchError(option);
            }
        }
    }

    public void loadProducerEntry(ProducerIdEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerIdEntry producerIdEntry) {
        return producerIdEntry.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerIdEntry.timestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, BoxesRunTime.unboxToLong((Object)x0$2), x1$1)));
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        this.deleteSnapshotFiles((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)snapOffset -> snapOffset > logEndOffset || snapOffset <= logStartOffset);
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean loadingFromLog) {
        return new ProducerAppendInfo(producerId, (ProducerIdEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerIdEntry$.MODULE$.Empty()), this.validateSequenceNumbers(), loadingFromLog);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer id ", " passed to update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId())})));
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated producer ", " state to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId()), appendInfo})));
        ProducerIdEntry entry = appendInfo.lastEntry();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)entry);
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerIdEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        block0: {
            if (this.lastMapOffset() <= this.lastSnapOffset()) break block0;
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.lastMapOffset());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing producer snapshot for partition ", " at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToLong((long)this.lastMapOffset())})));
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFilename(file.getName())));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFilename(file.getName())));
    }

    private boolean isProducerRetained(ProducerIdEntry producerIdEntry, long logStartOffset) {
        return producerIdEntry.lastOffset() >= logStartOffset;
    }

    public void truncateHead(long logStartOffset) {
        Map evictedProducerEntries = (Map)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$truncateHead$1(this, logStartOffset, x0$3)));
        Set evictedProducerIds = evictedProducerEntries.keySet();
        this.producers().$minus$minus$eq((TraversableOnce)evictedProducerIds);
        this.removeEvictedOngoingTransactions((Set<Object>)evictedProducerIds);
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeEvictedOngoingTransactions(Set<Object> expiredProducerIds) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.ongoingTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            if (!expiredProducerIds.contains((Object)BoxesRunTime.boxToLong((long)txnEntry.getValue().producerId()))) continue;
            iterator.remove();
        }
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        this.deleteSnapshotFiles(this.deleteSnapshotFiles$default$1());
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(0L);
    }

    /*
     * WARNING - void declaration
     */
    public long completeTxn(CompletedTxn completedTxn) {
        void var3_3;
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException("Attempted to complete a transaction which was not started");
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        long lastStableOffset = BoxesRunTime.unboxToLong((Object)this.firstUndecidedOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
        return (long)var3_3;
    }

    public void deleteSnapshotsBefore(long offset) {
        this.deleteSnapshotFiles((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> x$5 < offset);
    }

    private List<File> listSnapshotFiles() {
        return this.logDir().exists() && this.logDir().isDirectory() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$listSnapshotFiles$1(f))))).toList() : List$.MODULE$.empty();
    }

    private Option<File> oldestSnapshotFile() {
        List<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFilename(file.getName())), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        List<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFilename(file.getName())), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private void deleteSnapshotFiles(Function1<Object, Object> predicate) {
        ((List)this.listSnapshotFiles().filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)predicate.apply$mcZJ$sp(Log$.MODULE$.offsetFromFilename(file.getName()))))).foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$deleteSnapshotFiles$2(file)));
    }

    private Function1<Object, Object> deleteSnapshotFiles$default$1() {
        return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$6 -> true;
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$3) {
        return ((TxnMetadata)x$3.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long logStartOffset$3, long currentTime$1, ProducerIdEntry producerEntry) {
        return $this.isProducerRetained(producerEntry, logStartOffset$3) && !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, long x0$2, ProducerIdEntry x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerIdEntry lastEntry = (ProducerIdEntry)tuple2._2();
        boolean bl = !$this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$truncateHead$1(ProducerStateManager $this, long logStartOffset$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerIdEntry producerIdEntry = (ProducerIdEntry)tuple2._2();
        boolean bl = !$this.isProducerRetained(producerIdEntry, logStartOffset$2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listSnapshotFiles$1(File f) {
        return f.isFile() && ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$isSnapshotFile(f.getName());
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$2(File file) {
        return Files.deleteIfExists(file.toPath());
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        String string = topicPartition.topic();
        String string2 = "__consumer_offsets";
        this.validateSequenceNumbers = string == null ? string2 != null : !string.equals(string2);
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

