/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.wechat;

import com.alibaba.fastjson.JSONObject;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.wechat.WeiXinConfig;
import com.zhlh.Tiny.wechat.helper.WeiXinMessageHelper;
import com.zhlh.Tiny.wechat.model.TemplateData;
import com.zhlh.karma.service.wechat.TempleteMessageConstants;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);

    public static int notifyPaySuccess(String toOpenId, String nickName, String insuerName, String applicantName, BigDecimal orderMoneySum, Integer orderId, String orderSn, String cityCode) {
        log.info("\u5411" + toOpenId + "\u53d1\u9001\u652f\u4ed8\u6210\u529f\u6a21\u677f\u6d88\u606f");
        String url = WeiXinConfig.getBaseUrl() + "order/orderDetail?orderId=" + orderId;
        double money = orderMoneySum.setScale(2, 4).doubleValue();
        money /= 100.0;
        TemplateData templateData = new TemplateData(toOpenId, TempleteMessageConstants.MESSAGE_TEMPLETEID_PAY_SUCCESS);
        templateData.setUrl(url);
        TemplateData.TemplateDataItem data = new TemplateData.TemplateDataItem(templateData);
        if (CommonUtil.isEmpty((String)nickName)) {
            nickName = "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String date = df.format(new Date());
        data.addItem("first", "\u4eb2\u7231\u7684" + nickName + "," + "\u60a8\u67091\u7b14\u8f66\u9669\u8ba2\u5355\u652f\u4ed8\u6210\u529f!");
        data.addItem("keyword1", money + "\u5143");
        data.addItem("keyword2", insuerName + "\u8f66\u9669");
        if (CommonUtil.isEmpty((String)applicantName)) {
            applicantName = nickName;
        }
        data.addItem("keyword3", applicantName);
        data.addItem("keyword4", date);
        data.addItem("keyword5", orderSn);
        if (!cityCode.equals("110000")) {
            data.addItem("remark", "\u841d\u535c\u4f1a\u572848\u5c0f\u65f6\u5185\u5c06\u4fdd\u5355\u9001\u8fbe\uff0c\u8bf7\u8ba4\u771f\u6838\u5bf9\u4fdd\u5355\u4fe1\u606f!", "#173177");
        }
        templateData.setData(data);
        return MessageHelper.sendTemplate(templateData);
    }

    public static int notifyRakeBack(String toOpenId, String applicantName, BigDecimal amount) {
        log.info("\u5411" + toOpenId + "\u53d1\u9001\u8fd4\u73b0\u6a21\u677f\u6d88\u606f");
        String url = WeiXinConfig.getBaseUrl() + "account/accountInfo";
        double money = amount.setScale(2, 4).doubleValue();
        TemplateData templateData = new TemplateData(toOpenId, TempleteMessageConstants.MESSAGE_TEMPLETEID_GET_RACKBACK);
        templateData.setUrl(url);
        TemplateData.TemplateDataItem data = new TemplateData.TemplateDataItem(templateData);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        data.addItem("first", "\u4e00\u5927\u6346\u7968\u5b50\u6b63\u5728\u5411\u60a8\u98de\u6765\uff0c\u5177\u4f53\u65b9\u4f4d\u8bf7\u770b\u4e0b\u9762\u63d0\u793a\uff01");
        data.addItem("keyword1", applicantName + "\u4fdd\u5355\u5df2\u6210\u529f\u51fa\u5355");
        data.addItem("keyword2", money / 100.0 + "\u5143");
        data.addItem("keyword3", "\u841d\u535c\u8f66\u9669\u5e10\u6237");
        data.addItem("remark", "\u7531\u4e8e\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u73b0\u3002\u5982\u6709\u9700\u6c42\u8bf7\u62e8\u6253400-960-3676\u8054\u7cfb\u5ba2\u670d\u4eba\u5458\u3002", "#173177");
        templateData.setData(data);
        return MessageHelper.sendTemplate(templateData);
    }

    public static int notifyParentRakeBack(String toOpenId, String applicantName, BigDecimal amount) {
        log.info("\u5411" + toOpenId + "\u53d1\u9001\u8fd4\u73b0\u6a21\u677f\u6d88\u606f");
        String url = WeiXinConfig.getBaseUrl() + "account/accountInfo";
        amount = amount.divide(new BigDecimal(100)).setScale(2, 4);
        TemplateData templateData = new TemplateData(toOpenId, TempleteMessageConstants.MESSAGE_TEMPLETEID_CHILD_PAY_SUCCESS);
        templateData.setUrl(url);
        TemplateData.TemplateDataItem data = new TemplateData.TemplateDataItem(templateData);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        data.addItem("first", "\u4e00\u5927\u6346\u7968\u5b50\u6b63\u5728\u5411\u60a8\u98de\u6765\uff0c\u5177\u4f53\u65b9\u4f4d\u8bf7\u770b\u4e0b\u9762\u63d0\u793a\uff01");
        data.addItem("keyword1", applicantName + "\u60a8\u7684\u4e0b\u7ea7\u4ee3\u7406\u4eba\u5df2\u6210\u529f\u51fa\u5355");
        data.addItem("keyword3", "\u5916\u661f\u4eba\u8f66\u9669\u5e10\u6237");
        data.addItem("keyword2", amount + "\u5143");
        data.addItem("keyword4", df.format(new Date()) + "");
        data.addItem("remark", "\u5df2\u5c06\u63d0\u6210\u53d1\u9001\u5230\u60a8\u7684\u8d26\u6237\u4e2d\uff0c\u8bf7\u67e5\u770b\uff01", "#173177");
        templateData.setData(data);
        return MessageHelper.sendTemplate(templateData);
    }

    public static Integer sendTemplate(TemplateData templateData) {
        Integer code = -1;
        try {
            JSONObject jsonObject = WeiXinMessageHelper.templateSend((TemplateData)templateData);
            code = (Integer)jsonObject.get((Object)"errcode");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }
}

