/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.impl;

import com.zhlh.Tiny.page.bean.Page;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.karma.domain.model.AtinUser;
import com.zhlh.karma.domain.model.AtinUserInfo;
import com.zhlh.karma.domain.model.AtinWithdrawCashRecord;
import com.zhlh.karma.dto.WithdrawCashRecordDto;
import com.zhlh.karma.mapper.AtinUserInfoMapper;
import com.zhlh.karma.mapper.AtinUserMapper;
import com.zhlh.karma.mapper.AtinWithdrawCashRecordMapper;
import com.zhlh.karma.mapper.BaseMapper;
import com.zhlh.karma.service.WithdrawCashRecordService;
import com.zhlh.karma.service.impl.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WithdrawCashRecordServiceImpl
extends BaseServiceImpl<AtinWithdrawCashRecord>
implements WithdrawCashRecordService {
    @Autowired
    AtinWithdrawCashRecordMapper withdrawCashRecordMapper;
    @Autowired
    private AtinUserMapper userMapper;
    @Autowired
    private AtinUserInfoMapper userInfoMapper;

    @Override
    public BaseMapper<AtinWithdrawCashRecord> getBaseMapper() {
        return this.withdrawCashRecordMapper;
    }

    @Override
    public Page<WithdrawCashRecordDto> getSelectedWithdrawReqs(String nickName, String seriNum, Integer type, Integer state, Integer pageNo, Integer pageSize) {
        List list;
        List userIdsList = null;
        ArrayList<Integer> idList = new ArrayList<Integer>();
        Integer countRecord = 0;
        Page result = new Page(pageNo.intValue(), pageSize.intValue());
        if (CommonUtil.isNotEmpty((String)seriNum)) {
            if (CommonUtil.isNotEmpty((String)nickName)) {
                userIdsList = this.userMapper.findUserIdsByNickName(nickName);
                for (AtinUser i : userIdsList) {
                    System.out.print(i.getId());
                    idList.add(i.getId());
                }
                if (CommonUtil.isNotEmpty(idList)) {
                    countRecord = this.withdrawCashRecordMapper.countRecord(idList, seriNum, type, state);
                    list = this.withdrawCashRecordMapper.getWithdrawCashReqList(idList, seriNum, type, state, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
                } else {
                    list = null;
                }
            } else {
                countRecord = this.withdrawCashRecordMapper.countRecord(null, seriNum, type, state);
                list = this.withdrawCashRecordMapper.getWithdrawCashReqList(null, seriNum, type, state, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
            }
        } else if (CommonUtil.isNotEmpty((String)nickName)) {
            userIdsList = this.userMapper.findUserIdsByNickName(nickName);
            for (AtinUser i : userIdsList) {
                System.out.print(i.getId());
                idList.add(i.getId());
            }
            if (CommonUtil.isNotEmpty(idList)) {
                countRecord = this.withdrawCashRecordMapper.countRecord(idList, null, type, state);
                list = this.withdrawCashRecordMapper.getWithdrawCashReqList(idList, null, type, state, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
            } else {
                list = null;
            }
        } else {
            countRecord = this.withdrawCashRecordMapper.countRecord(null, null, type, state);
            list = this.withdrawCashRecordMapper.getWithdrawCashReqList(null, null, type, state, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
        }
        result.setPageNo(pageNo.intValue());
        result.setPageSize(pageSize.intValue());
        if (CommonUtil.isNotEmpty((Collection)list)) {
            result.setTotalRecord((long)countRecord.intValue());
            result.setTotalPage(countRecord % pageSize == 0 ? countRecord / pageSize : countRecord / pageSize + 1);
            List<WithdrawCashRecordDto> dtos = this.modelToDto(list);
            result.setResults(dtos);
        } else {
            result.setTotalRecord(0L);
            result.setTotalPage(0);
            result.setResults(null);
        }
        return result;
    }

    private List<WithdrawCashRecordDto> modelToDto(List<AtinWithdrawCashRecord> recordList) {
        ArrayList<WithdrawCashRecordDto> dtos = new ArrayList<WithdrawCashRecordDto>();
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        for (AtinWithdrawCashRecord withdrawCashRecord : recordList) {
            WithdrawCashRecordDto dto = new WithdrawCashRecordDto();
            BeanUtils.copyProperties((Object)withdrawCashRecord, (Object)((Object)dto));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String dateCreate = format.format(withdrawCashRecord.getCreateTime());
            dto.setReqDate(dateCreate);
            if (withdrawCashRecord.getModifyTime() != null) {
                String dateModify = format.format(withdrawCashRecord.getModifyTime());
                dto.setModifyDate(dateModify);
            }
            Integer id = withdrawCashRecord.getUserId();
            userIdList.add(id);
            dtos.add(dto);
        }
        List userList = this.userMapper.getUserListByUserIds(null, userIdList);
        HashMap<Integer, AtinUser> map = new HashMap<Integer, AtinUser>();
        for (AtinUser user : userList) {
            map.put(user.getId(), user);
        }
        for (WithdrawCashRecordDto dto : dtos) {
            AtinUser user;
            Integer id = dto.getUserId();
            if (id == null || (user = (AtinUser)map.get(id)) == null) continue;
            dto.setNickname(user.getNickname());
            dto.setUsername(user.getUsername());
            dto.setAmountBalance(user.getAmountBalance());
            dto.setPhoneNum(user.getMobile());
        }
        return dtos;
    }

    @Override
    public List<WithdrawCashRecordDto> getAllWithDrawByUserId(Integer userId, Integer status) {
        List withdrawCashRecordList = this.withdrawCashRecordMapper.getAllWithDrawByUserId(userId, status);
        ArrayList<WithdrawCashRecordDto> withdrawCashRecordDtoList = new ArrayList<WithdrawCashRecordDto>();
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(userId);
        AtinUserInfo userInfo = this.userInfoMapper.findUserInfoByOpenId(user.getOpenid());
        for (AtinWithdrawCashRecord withdrawCashRecord : withdrawCashRecordList) {
            WithdrawCashRecordDto withdrawCashRecordDto = new WithdrawCashRecordDto();
            BeanUtil.quickCopy((Object)withdrawCashRecord, (Object)((Object)withdrawCashRecordDto));
            withdrawCashRecordDto.setNickname(userInfo.getNickname());
            withdrawCashRecordDto.setUsername(user.getUsername());
            withdrawCashRecordDtoList.add(withdrawCashRecordDto);
        }
        return withdrawCashRecordDtoList;
    }

    @Override
    public AtinWithdrawCashRecord findUserWithdrawCashBankInfoByUserId(Integer userId) {
        List atinWithdrawCashRecordList = this.withdrawCashRecordMapper.getAtinWithdrawCashRecordByUserId(userId);
        return (AtinWithdrawCashRecord)atinWithdrawCashRecordList.get(0);
    }
}

