/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.impl;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.karma.domain.model.RevenueDetail;
import com.zhlh.karma.mapper.BaseMapper;
import com.zhlh.karma.mapper.RevenueDetailMapper;
import com.zhlh.karma.service.RevenueService;
import com.zhlh.karma.service.impl.BaseServiceImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RevenueServiceImpl
extends BaseServiceImpl<RevenueDetail>
implements RevenueService {
    @Autowired
    private RevenueDetailMapper revenueDetailMapper;

    @Override
    public BaseMapper<RevenueDetail> getBaseMapper() {
        return this.revenueDetailMapper;
    }

    @Override
    public List<RevenueDetail> findRevenueListByUserIdAndNowDate(Integer userId, String month) throws UnsupportedEncodingException {
        if (CommonUtil.isEmpty((String)(month = URLDecoder.decode(URLDecoder.decode(month, "UTF-8"))))) {
            month = this.getCunrrentMonth();
        } else if (month.indexOf("\u5e74") > -1) {
            month = month.substring(0, 4) + "-" + month.substring(5, 7);
        }
        List revenueDetailList = this.revenueDetailMapper.findRevenueBusCategory(userId, month);
        return revenueDetailList;
    }

    @Override
    public List<RevenueDetail> ownerCarInsurance(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        } else if (month.indexOf("\u5e74") > -1) {
            month = month.substring(0, 4) + "-" + month.substring(5, 7);
        }
        List ownerCarInsurance = this.revenueDetailMapper.ownerCarInsurance(userId, month);
        return ownerCarInsurance;
    }

    @Override
    public List<RevenueDetail> childrenParterSumPremiumAndAllanceAmount(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        } else if (month.indexOf("\u5e74") > -1) {
            month = month.substring(0, 4) + "-" + month.substring(5, 7);
        }
        List childrenParterSumPremiumAndAllanceAmountList = this.revenueDetailMapper.childrenParterSumPremiumAndAllanceAmount(userId, month);
        return childrenParterSumPremiumAndAllanceAmountList;
    }

    @Override
    public List<RevenueDetail> parterCarInsuranceDetailList(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        } else if (month.indexOf("\u5e74") > -1) {
            month = month.substring(0, 4) + "-" + month.substring(5, 7);
        }
        List parterCarInsuranceDetailList = this.revenueDetailMapper.parterCarInsuranceDetailList(userId, month);
        return parterCarInsuranceDetailList;
    }

    @Override
    public RevenueDetail ownerAccumulatedIncome(Integer userId) {
        RevenueDetail revenueDetail = this.revenueDetailMapper.ownerAccumulatedIncome(userId);
        return revenueDetail;
    }

    @Override
    public List<RevenueDetail> myPartnerList(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        } else if (month.indexOf("\u5e74") > -1) {
            month = month.substring(0, 4) + "-" + month.substring(5, 7);
        }
        List myPartnerList = this.revenueDetailMapper.myPartnerList(userId, month);
        return myPartnerList;
    }

    private String getCunrrentMonth() {
        String nowMonth = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM");
        return nowMonth;
    }
}

