/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.karma.domain.model.AtinAgencySupportInsuc;
import com.zhlh.karma.mapper.AtinAgencySupportInsucMapper;
import com.zhlh.karma.mapper.BaseMapper;
import com.zhlh.karma.service.InsuComCityService;
import com.zhlh.karma.service.constant.ChannelConstants;
import com.zhlh.karma.service.impl.BaseServiceImpl;
import com.zhlh.zeus.api.InsureCityRService;
import com.zhlh.zeus.dto.insureCity.InsurerCity;
import com.zhlh.zeus.dto.insureCity.InsurerCityResDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InsuComCityServiceImpl
extends BaseServiceImpl<AtinAgencySupportInsuc>
implements InsuComCityService {
    @Autowired
    private AtinAgencySupportInsucMapper mapper;
    @Autowired
    private InsureCityRService insureCityRService;

    @Override
    public BaseMapper<AtinAgencySupportInsuc> getBaseMapper() {
        return this.mapper;
    }

    @Override
    public void syncInsuComCity() {
        InsurerCityResDto insurerCityResDto = this.insureCityRService.getAllInsurerCityList("zhlh", ChannelConstants.CHANNEL);
        if (0 != insurerCityResDto.getErrCode()) {
            return;
        }
        List insuComCityList = this.mapper.getAll(null);
        HashMap<String, AtinAgencySupportInsuc> insuComCityMap = new HashMap<String, AtinAgencySupportInsuc>();
        for (AtinAgencySupportInsuc insuComCity : insuComCityList) {
            insuComCityMap.put(insuComCity.getCityCode() + "_" + insuComCity.getInsuCom(), insuComCity);
        }
        ArrayList<AtinAgencySupportInsuc> insertList = new ArrayList<AtinAgencySupportInsuc>();
        ArrayList<AtinAgencySupportInsuc> updateList = new ArrayList<AtinAgencySupportInsuc>();
        for (InsurerCity insurerCity : insurerCityResDto.getInsurerCityList()) {
            String key = insurerCity.getCityCode() + "_" + insurerCity.getInsuCom();
            AtinAgencySupportInsuc insuComCity = (AtinAgencySupportInsuc)insuComCityMap.get(key);
            if (insuComCity == null) {
                AtinAgencySupportInsuc insertInsuComCity = new AtinAgencySupportInsuc();
                BeanUtil.quickCopy((Object)insurerCity, (Object)insertInsuComCity);
                insertInsuComCity.setIsAccess(Integer.valueOf(1));
                insertInsuComCity.setDiscount(new BigDecimal("0.00"));
                insertList.add(insertInsuComCity);
            } else {
                BeanUtil.quickCopy((Object)insurerCity, (Object)insuComCity);
                insuComCity.setIsAccess(Integer.valueOf(1));
                updateList.add(insuComCity);
            }
            insuComCityMap.remove(key);
        }
        if (insuComCityMap.size() > 0) {
            for (String key : insuComCityMap.keySet()) {
                AtinAgencySupportInsuc insuComCity = (AtinAgencySupportInsuc)insuComCityMap.get(key);
                insuComCity.setIsAccess(Integer.valueOf(0));
                updateList.add(insuComCity);
            }
        }
        if (!CommonUtil.isEmpty(insertList)) {
            this.mapper.batchInsert(insertList);
        }
        if (!CommonUtil.isEmpty(updateList)) {
            this.mapper.batchUpdate(updateList);
        }
    }

    @Override
    public List<AtinAgencySupportInsuc> getAll() {
        return this.mapper.getAll(null);
    }
}

