/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.impl;

import com.alibaba.fastjson.JSON;
import com.zhlh.karma.domain.model.AtinModule;
import com.zhlh.karma.domain.model.AtinPermission;
import com.zhlh.karma.domain.model.AtinRolesPermission;
import com.zhlh.karma.domain.model.ModulePermission;
import com.zhlh.karma.dto.TreeElementDto;
import com.zhlh.karma.mapper.AtinModuleMapper;
import com.zhlh.karma.mapper.AtinPermissionMapper;
import com.zhlh.karma.mapper.AtinRolesPermissionMapper;
import com.zhlh.karma.mapper.BaseMapper;
import com.zhlh.karma.mapper.ModulePermissionMapper;
import com.zhlh.karma.service.AtinModuleService;
import com.zhlh.karma.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AtinModuleServiceImpl
extends BaseServiceImpl<AtinModule>
implements AtinModuleService {
    @Autowired
    private AtinModuleMapper moduleMapper;
    @Autowired
    private ModulePermissionMapper modulePermissionMapper;
    @Autowired
    private AtinPermissionMapper permissionMapper;
    @Autowired
    private AtinRolesPermissionMapper rolesPermissionMapper;

    @Override
    public BaseMapper<AtinModule> getBaseMapper() {
        return this.moduleMapper;
    }

    @Override
    public String getTree(Integer roleId) {
        List allModule = this.moduleMapper.getAll();
        List links = this.modulePermissionMapper.getAll();
        List permissions = this.permissionMapper.getAll();
        List rolesPermissions = new ArrayList();
        ArrayList<TreeElementDto> elementDtos = new ArrayList<TreeElementDto>();
        for (AtinModule module : allModule) {
            TreeElementDto pElement = new TreeElementDto();
            pElement.setId(module.getId());
            pElement.setParent(true);
            pElement.setpId(0);
            pElement.setName(module.getModuleName());
            pElement.setType(1);
            elementDtos.add(pElement);
            for (ModulePermission link : links) {
                if (module.getId().intValue() != link.getModuleId().intValue()) continue;
                for (AtinPermission permission : permissions) {
                    if (link.getPermissionId().intValue() != permission.getId().intValue()) continue;
                    TreeElementDto chElement = new TreeElementDto();
                    chElement.setId(permission.getId());
                    chElement.setParent(false);
                    chElement.setpId(module.getId());
                    chElement.setName(permission.getPermissionName());
                    chElement.setType(2);
                    elementDtos.add(chElement);
                }
            }
        }
        if (roleId != 0) {
            rolesPermissions = this.rolesPermissionMapper.findByRoleId(roleId);
        }
        if (rolesPermissions.size() > 0) {
            for (AtinRolesPermission rolesPermission : rolesPermissions) {
                for (TreeElementDto elementDto : elementDtos) {
                    if (rolesPermission.getResourceId().intValue() != elementDto.getId()) continue;
                    elementDto.setChecked(true);
                }
            }
        }
        String json = JSON.toJSONString(elementDtos);
        json = json.replace("parent", "isParent");
        return json;
    }

    @Override
    public void insertPermissionsConfig(Integer roleId, List<TreeElementDto> treeElementDtos) {
        this.rolesPermissionMapper.deleteByRoleId(roleId);
        for (TreeElementDto treeElementDto : treeElementDtos) {
            AtinRolesPermission rolesPermission = new AtinRolesPermission();
            rolesPermission.setRoleId(roleId);
            if (1 == treeElementDto.getType()) {
                rolesPermission.setResource("module");
            } else {
                rolesPermission.setResource("moduleElement");
            }
            rolesPermission.setResourceId(Integer.valueOf(treeElementDto.getId()));
            rolesPermission.setCreateTime(new Date());
            rolesPermission.setModifyTime(new Date());
            rolesPermission.setAction("VIEW");
            this.rolesPermissionMapper.insert((Object)rolesPermission);
        }
    }
}

