/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.aspect;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ServiceAspect {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAspect.class);

    @Around(value="execution(public * com.zhlh.karma.service.*.*(..))")
    public Object aroundServiceMethod(ProceedingJoinPoint pjp) throws Throwable {
        long start = System.currentTimeMillis();
        String serviceName = pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName();
        Object returnVal = pjp.proceed();
        LOG.info("Service: {}, Args: {}, Return: {}, Cost: {}.", new Object[]{serviceName, Arrays.toString(pjp.getArgs()), JSON.toJSONString((Object)returnVal), System.currentTimeMillis() - start + "ms"});
        return returnVal;
    }
}

