/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.util;

import com.zhlh.jarvis.domain.model.AtinModule;
import com.zhlh.jarvis.domain.model.AtinPermission;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SysUserPermissionHolder {
    public static final SysUserPermissionHolder EMPTY = new SysUserPermissionHolder();
    private List<AtinModule> sysModuleList;
    private List<AtinPermission> sysModuleElementList;

    public AtinModule getParentSysModule(AtinModule sysModule) {
        if (sysModule == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.sysModuleList)) {
            return null;
        }
        for (AtinModule tempSysModule : this.sysModuleList) {
            if (!tempSysModule.getId().equals(sysModule.getParent())) continue;
            return tempSysModule;
        }
        return null;
    }

    public List<AtinModule> getSubSysModuleList(AtinModule sysModule) {
        if (sysModule == null) {
            return new ArrayList<AtinModule>();
        }
        if (CollectionUtils.isEmpty(this.sysModuleList)) {
            return new ArrayList<AtinModule>();
        }
        ArrayList<AtinModule> subSysModuleList = new ArrayList<AtinModule>();
        for (AtinModule tempSysModule : this.sysModuleList) {
            if (!tempSysModule.getParent().equals(sysModule.getId())) continue;
            subSysModuleList.add(tempSysModule);
        }
        return subSysModuleList;
    }

    public boolean containsSysModuleElement(String domId) {
        if (!StringUtils.hasText((String)domId)) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.sysModuleElementList)) {
            return false;
        }
        for (AtinPermission sysModuleElement : this.sysModuleElementList) {
            if (!sysModuleElement.getDomId().equals(domId)) continue;
            return true;
        }
        return false;
    }

    public List<AtinModule> getSysModuleList() {
        return this.sysModuleList;
    }

    public void setSysModuleList(List<AtinModule> sysModuleList) {
        this.sysModuleList = sysModuleList;
    }

    public List<AtinPermission> getSysModuleElementList() {
        return this.sysModuleElementList;
    }

    public void setSysModuleElementList(List<AtinPermission> sysModuleElementList) {
        this.sysModuleElementList = sysModuleElementList;
    }

    public String toString() {
        return "SysUserPermissionHolder{sysModuleList=" + this.sysModuleList + ", sysModuleElementList=" + this.sysModuleElementList + '}';
    }

    static {
        EMPTY.setSysModuleList(new ArrayList<AtinModule>());
        EMPTY.setSysModuleElementList(new ArrayList<AtinPermission>());
    }
}

