/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.jarvis.domain.model.AtinVehicle;
import com.zhlh.jarvis.mapper.AtinVehicleMapper;
import com.zhlh.jarvis.mapper.BaseMapper;
import com.zhlh.jarvis.service.VehicleService;
import com.zhlh.jarvis.service.common.ServiceUtil;
import com.zhlh.jarvis.service.constant.ChannelConstants;
import com.zhlh.jarvis.service.impl.BaseServiceImpl;
import com.zhlh.zeus.api.VehicleInfoRService;
import com.zhlh.zeus.dto.vehicle.QueryVehicleReqDto;
import com.zhlh.zeus.dto.vehicle.QueryVehicleResDto;
import com.zhlh.zeus.dto.vehicle.VehicleBaseResDto;
import com.zhlh.zeus.dto.vehicle.VehicleDesInfoDto;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VehicleServiceImpl
extends BaseServiceImpl<AtinVehicle>
implements VehicleService {
    @Autowired
    private AtinVehicleMapper vehicleMapper;
    @Autowired
    private VehicleInfoRService vehicleInfoRService;

    @Override
    public BaseMapper<AtinVehicle> getBaseMapper() {
        return this.vehicleMapper;
    }

    private AtinVehicle cleanVehicle(AtinVehicle vehicle) {
        vehicle.setRbcode("");
        vehicle.setVehicleTypeDesc("");
        vehicle.setPurchasePrice("");
        vehicle.setExhaustcapacity("");
        vehicle.setMarketDate("");
        return vehicle;
    }

    @Override
    public int update(AtinVehicle vehicle) {
        vehicle.setModifyTime(new Date());
        return this.vehicleMapper.updateByPrimaryKeySelective((Object)vehicle);
    }

    @Override
    public QueryVehicleResDto vehicleQuery(AtinVehicle vehicle) {
        QueryVehicleReqDto queryVehicleReqDto = new QueryVehicleReqDto();
        queryVehicleReqDto.setChannel(ChannelConstants.CHANNEL);
        BeanUtil.quickCopy((Object)vehicle, (Object)queryVehicleReqDto);
        queryVehicleReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(vehicle.getLicenseNo()));
        queryVehicleReqDto.setPartner("zhlh");
        queryVehicleReqDto.setInsuCom("I00002");
        queryVehicleReqDto.setOrigin(ChannelConstants.CHANNEL);
        log.info("\u8f66\u8f86\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.beanToJSON((Object)queryVehicleReqDto));
        QueryVehicleResDto queryVehicleResDto = this.vehicleInfoRService.queryVehicleInfo(queryVehicleReqDto);
        log.info("\u8f66\u8f86\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c:" + JsonUtil.beanToJSON((Object)queryVehicleResDto));
        return queryVehicleResDto;
    }

    @Override
    public AtinVehicle getVehicleByUserIdAndLicenseNo(Integer userId, String licenseNo) {
        return this.vehicleMapper.getVehicleByUserIdAndLicenseNo(userId, licenseNo);
    }

    @Override
    public AtinVehicle updateByUserInput(AtinVehicle vehicle, Integer userId) {
        AtinVehicle licenseNoVehicleInfo = this.vehicleMapper.getVehicleByUserIdAndLicenseNo(userId, vehicle.getLicenseNo());
        if (licenseNoVehicleInfo != null) {
            this.cleanVehicle(licenseNoVehicleInfo);
            licenseNoVehicleInfo.setFrameNo(vehicle.getFrameNo());
            licenseNoVehicleInfo.setEnrollDate(vehicle.getEnrollDate());
            licenseNoVehicleInfo.setBrandName(vehicle.getBrandName());
            licenseNoVehicleInfo.setEngineNo(vehicle.getEngineNo());
            licenseNoVehicleInfo.setOwner(vehicle.getOwner());
            licenseNoVehicleInfo.setOwnerCertNo(vehicle.getOwnerCertNo());
            this.update(licenseNoVehicleInfo);
            return licenseNoVehicleInfo;
        }
        vehicle.setUserId(userId);
        this.insert(vehicle);
        return vehicle;
    }

    @Override
    public AtinVehicle updateByVehicleDesInfoDto(VehicleDesInfoDto vehicleDesInfoDto, AtinVehicle vehicle) {
        BeanUtil.quickCopy((Object)vehicleDesInfoDto, (Object)vehicle);
        vehicle.setPurchasePrice(String.valueOf(vehicleDesInfoDto.getPurchasePrice()));
        vehicle.setExhaustcapacity(vehicleDesInfoDto.getExhaustCapacity());
        this.update(vehicle);
        return vehicle;
    }

    @Override
    public AtinVehicle getActiveVehicleByUserId(Integer userId) {
        return this.vehicleMapper.getActiveVehicleByUserId(userId);
    }

    @Override
    public void setActiveVehicleById(Integer id, Integer userId) {
        this.vehicleMapper.setActiveVehicleById(id, userId);
    }

    @Override
    public AtinVehicle getVehicleByLicenseNo(String licenseNo) {
        return this.vehicleMapper.getVehicleByLicenseNo(licenseNo);
    }

    @Override
    public AtinVehicle getVehicleInfoByUserIdAndLicenseNo(Integer userId, String licenseNo) {
        AtinVehicle vehicle = this.vehicleMapper.getVehicleByUserIdAndLicenseNo(userId, licenseNo);
        if (vehicle != null) {
            return vehicle;
        }
        VehicleBaseResDto resDto = this.vehicleInfoRService.queryVehicleBase(licenseNo);
        if (resDto == null || resDto.getErrCode() == null || resDto.getErrCode() != 0) {
            return null;
        }
        vehicle = new AtinVehicle();
        BeanUtil.quickCopy((Object)resDto, (Object)vehicle);
        vehicle.setUserId(userId);
        this.insert(vehicle);
        return vehicle;
    }
}

