/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.impl;

import com.alibaba.fastjson.JSON;
import com.zhlh.Tiny.page.bean.Page;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.EncryptUtil;
import com.zhlh.jarvis.domain.model.AtinAgency;
import com.zhlh.jarvis.domain.model.AtinCompany;
import com.zhlh.jarvis.domain.model.AtinRolesPermission;
import com.zhlh.jarvis.domain.model.AtinUser;
import com.zhlh.jarvis.domain.model.AtinUserAgency;
import com.zhlh.jarvis.domain.model.AtinUserInfo;
import com.zhlh.jarvis.domain.model.AtinUserRoles;
import com.zhlh.jarvis.dto.OrganizationDto;
import com.zhlh.jarvis.mapper.AtinAgencyMapper;
import com.zhlh.jarvis.mapper.AtinCompanyMapper;
import com.zhlh.jarvis.mapper.AtinModuleMapper;
import com.zhlh.jarvis.mapper.AtinPermissionMapper;
import com.zhlh.jarvis.mapper.AtinRolesMapper;
import com.zhlh.jarvis.mapper.AtinRolesPermissionMapper;
import com.zhlh.jarvis.mapper.AtinUserAgencyMapper;
import com.zhlh.jarvis.mapper.AtinUserInfoMapper;
import com.zhlh.jarvis.mapper.AtinUserMapper;
import com.zhlh.jarvis.mapper.AtinUserRolesMapper;
import com.zhlh.jarvis.mapper.BaseMapper;
import com.zhlh.jarvis.service.UserService;
import com.zhlh.jarvis.service.exception.ServiceException;
import com.zhlh.jarvis.service.impl.BaseServiceImpl;
import com.zhlh.jarvis.util.SysUserPermissionHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserServiceImpl
extends BaseServiceImpl<AtinUser>
implements UserService {
    @Autowired
    private AtinUserMapper userMapper;
    @Autowired
    private AtinUserInfoMapper userInfoMapper;
    @Autowired
    private AtinUserRolesMapper userRolesMapper;
    @Autowired
    private AtinUserAgencyMapper userAgencyMapper;
    @Autowired
    private AtinRolesMapper rolesMapper;
    @Autowired
    private AtinCompanyMapper companyMapper;
    @Autowired
    private AtinAgencyMapper agencyMapper;
    @Autowired
    private AtinRolesPermissionMapper rolesPermissionMapper;
    @Autowired
    private AtinModuleMapper moduleMapper;
    @Autowired
    private AtinPermissionMapper permissionMapper;

    @Override
    public BaseMapper<AtinUser> getBaseMapper() {
        return this.userMapper;
    }

    @Override
    public AtinUser findOneByOpenId(String openId) {
        return this.userMapper.findOneByOpenId(openId);
    }

    @Override
    public Integer findUserIdByOpenId(String openId) {
        return this.userMapper.findUserIdByOpenId(openId);
    }

    @Override
    public Integer findUserByMobile(String mobile) {
        return this.userMapper.findUserByMobile(mobile);
    }

    @Override
    public AtinUser findOneByMobile(String mobile) {
        return this.userMapper.findOneByMobile(mobile);
    }

    @Override
    public List obscureSelectByNickName(String name) {
        return this.userMapper.obscureSelectByNickName(name);
    }

    @Override
    public AtinUserInfo findUserInfoById(String openid) {
        return this.userInfoMapper.findUserInfoByOpenId(openid);
    }

    @Override
    public Integer login(String loginName, String password) {
        Assert.hasText((String)loginName, (String)"\u7528\u6237\u540d\u4e3a\u7a7a");
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e3a\u7a7a");
        AtinUser user = this.findOneByLoginName(loginName);
        if (user == null) {
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!password.equalsIgnoreCase(user.getPassword())) {
            throw new ServiceException("\u5bc6\u7801\u9519\u8bef");
        }
        if (user.getStatus() == 2) {
            throw new ServiceException("\u7528\u6237\u540d\u5df2\u505c\u7528");
        }
        return user.getId();
    }

    @Override
    public String parseToCookieValue(AtinUser user) {
        if (user == null) {
            return "";
        }
        return EncryptUtil.encrypt((String)JSON.toJSONString((Object)user));
    }

    @Override
    public AtinUser parseFromCookieValue(String cookieValue) {
        if (!StringUtils.hasText((String)cookieValue)) {
            return null;
        }
        return (AtinUser)JSON.parseObject((String)EncryptUtil.decrypt((String)cookieValue), AtinUser.class);
    }

    @Override
    public List obsureByNameOrPhone(String queryStr, boolean isNumber, Integer agencyId) {
        List userAgencyList = this.userAgencyMapper.getUserAgencyListByAgencyId(agencyId);
        List userRolesList = this.userRolesMapper.queryRolesByAgencyIdAndRoleId(agencyId, Integer.valueOf(5));
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        List users = new ArrayList();
        for (AtinUserAgency userAgency : userAgencyList) {
            userIds.add(userAgency.getUserId());
        }
        if (CommonUtil.isNotEmpty((Collection)userRolesList)) {
            for (AtinUserRoles userRoles : userRolesList) {
                if (userIds.contains(userRoles.getUserId())) continue;
                userIds.add(userRoles.getUserId());
            }
        }
        if (userIds != null) {
            users = this.userMapper.obscureSelectByNameOrPhone(queryStr, isNumber, userIds);
            ArrayList userList = new ArrayList();
            userIds.clear();
            for (AtinUser user : users) {
                userIds.add(user.getId());
            }
            if (CommonUtil.isNotEmpty(users) && users.size() > 5) {
                users = users.subList(0, 4);
            }
        }
        return users;
    }

    @Override
    public AtinUser findOneByLoginName(String loginName) {
        return this.userMapper.findOneByLoginName(loginName);
    }

    @Override
    public List<AtinUser> findAll() {
        return this.userMapper.findAll();
    }

    @Override
    public Page<AtinUser> queryUserDtoList(AtinUser user, Integer pageNo, Integer pageSize) {
        List<Object> idList = new ArrayList();
        AtinUserRoles atinUserRoles = this.userRolesMapper.findByUserId(user.getId());
        idList = this.queryUserIds(atinUserRoles.getRoleId(), atinUserRoles.getAgencyId());
        Page result = new Page(pageNo.intValue(), pageSize.intValue());
        if (CommonUtil.isNotEmpty(idList)) {
            Integer count = this.userMapper.countByUserIds(idList);
            List atinUserList = this.userMapper.selectUserListByUserIds(idList, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
            if (CommonUtil.isNotEmpty((Collection)atinUserList)) {
                result.setTotalPage(count % pageSize == 0 ? count / pageSize : count / pageSize + 1);
                result.setTotalRecord((long)count.intValue());
                result.setResults(atinUserList);
            }
        } else {
            result.setTotalRecord(0L);
            result.setTotalPage(0);
            result.setResults(null);
        }
        return result;
    }

    private List<Integer> queryUserIds(Integer roleId, Integer agencyId) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        List userRolesList = new ArrayList();
        switch (roleId) {
            case 1: {
                userRolesList = this.userRolesMapper.selectUserIdsByRole(roleId, null, Integer.valueOf(0));
                break;
            }
            case 2: {
                userRolesList = this.userRolesMapper.selectUserIdsByRole(roleId, null, agencyId);
                break;
            }
            default: {
                userRolesList = this.userRolesMapper.selectUserIdsByRole(roleId, agencyId, null);
            }
        }
        for (AtinUserRoles atinUserRoles : userRolesList) {
            idList.add(atinUserRoles.getUserId());
        }
        return idList;
    }

    @Override
    public List<OrganizationDto> getOrgnization(Integer roleId, Integer userId) {
        ArrayList<OrganizationDto> organizationDtoList = new ArrayList<OrganizationDto>();
        switch (roleId) {
            case 1: {
                List companyList = new ArrayList();
                companyList = this.companyMapper.getAllCompany();
                for (AtinCompany atinCompany : companyList) {
                    OrganizationDto organizationDto = new OrganizationDto();
                    organizationDto.setId(atinCompany.getId());
                    organizationDto.setName(atinCompany.getCompanyName());
                    organizationDtoList.add(organizationDto);
                }
                break;
            }
            case 2: {
                AtinUserRoles userRoles = this.userRolesMapper.findByUserId(userId);
                Integer companyId = userRoles.getAgencyId();
                List agencyList = new ArrayList();
                agencyList = this.agencyMapper.getAllAgency(companyId);
                for (AtinAgency atinAgency : agencyList) {
                    OrganizationDto organizationDto = new OrganizationDto();
                    organizationDto.setId(atinAgency.getId());
                    organizationDto.setName(atinAgency.getAgencyName());
                    organizationDtoList.add(organizationDto);
                }
                break;
            }
            default: {
                AtinUserRoles atinUserRoles = this.userRolesMapper.findByUserId(userId);
                AtinAgency atinAgency = (AtinAgency)this.agencyMapper.selectByPrimaryKey(atinUserRoles.getAgencyId());
                OrganizationDto organizationDto = new OrganizationDto();
                organizationDto.setId(atinAgency.getId());
                organizationDto.setName(atinAgency.getAgencyName());
                organizationDtoList.add(organizationDto);
            }
        }
        return organizationDtoList;
    }

    @Override
    public boolean saveManager(AtinUser user, Integer agencyId, Integer roleId, List<Integer> roleIds) {
        AtinUser existUser = this.userMapper.findOneByMobile(user.getMobile());
        AtinAgency atinAgency = new AtinAgency();
        if (existUser != null) {
            return false;
        }
        this.userMapper.insertSelective((Object)user);
        AtinUserRoles atinUserRoles = new AtinUserRoles();
        atinUserRoles.setAgencyId(agencyId);
        atinUserRoles.setUserId(user.getId());
        switch (roleId) {
            case 1: {
                atinUserRoles.setParentId(Integer.valueOf(0));
                atinUserRoles.setRoleId(Integer.valueOf(roleId + 1));
                break;
            }
            case 3: {
                atinAgency = (AtinAgency)this.agencyMapper.selectByPrimaryKey(agencyId);
                atinUserRoles.setParentId(atinAgency.getCompanyId());
                atinUserRoles.setRoleId(roleIds.get(0));
                break;
            }
            default: {
                atinAgency = (AtinAgency)this.agencyMapper.selectByPrimaryKey(agencyId);
                atinUserRoles.setParentId(atinAgency.getCompanyId());
                atinUserRoles.setRoleId(Integer.valueOf(roleId + 1));
            }
        }
        this.userRolesMapper.insertSelective((Object)atinUserRoles);
        if (roleIds.size() > 1) {
            atinUserRoles.setId(null);
            atinUserRoles.setParentId(atinAgency.getCompanyId());
            atinUserRoles.setRoleId(roleIds.get(1));
            this.userRolesMapper.insertSelective((Object)atinUserRoles);
        }
        return true;
    }

    @Override
    public boolean updateUserStatus(Integer userId, Integer roleId) {
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(userId);
        user.setStatus(Integer.valueOf(0));
        this.userMapper.updateByPrimaryKeySelective((Object)user);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List atinUserRolesList = this.userRolesMapper.queryRolesByUserId(userId.intValue());
        if (CommonUtil.isNotEmpty((Collection)atinUserRolesList)) {
            for (AtinUserRoles atinUserRoles : atinUserRolesList) {
                ids.add(atinUserRoles.getId());
            }
            this.userRolesMapper.updateStatusByUserId(userId);
        }
        return true;
    }

    @Override
    public SysUserPermissionHolder getPermissionHolder(Integer userId, List<Integer> roleIds) {
        if (userId == null || userId == 0) {
            return SysUserPermissionHolder.EMPTY;
        }
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(userId);
        if (user == null) {
            return SysUserPermissionHolder.EMPTY;
        }
        if (CollectionUtils.isEmpty(roleIds)) {
            return SysUserPermissionHolder.EMPTY;
        }
        ArrayList permissionList = new ArrayList();
        List rolesPermissions = this.rolesPermissionMapper.findByRoleIds(roleIds);
        ArrayList<Integer> moduleIds = new ArrayList<Integer>();
        ArrayList<Integer> permissionIds = new ArrayList<Integer>();
        for (AtinRolesPermission rolesPermission : rolesPermissions) {
            if ("module".toString().equals(rolesPermission.getResource())) {
                moduleIds.add(rolesPermission.getResourceId());
            }
            if (!"moduleElement".toString().equals(rolesPermission.getResource())) continue;
            permissionIds.add(rolesPermission.getResourceId());
        }
        HashSet<Integer> moduleIdSet = new HashSet<Integer>();
        HashSet<Integer> permissionIdSet = new HashSet<Integer>();
        moduleIdSet.addAll(moduleIds);
        moduleIds.clear();
        moduleIds.addAll(moduleIdSet);
        permissionIdSet.addAll(permissionIds);
        permissionIds.clear();
        permissionIds.addAll(permissionIdSet);
        SysUserPermissionHolder holder = new SysUserPermissionHolder();
        holder.setSysModuleList(this.moduleMapper.findByIdList(moduleIds));
        holder.setSysModuleElementList(this.permissionMapper.findByIdList(permissionIds));
        return holder;
    }

    @Override
    public AtinUser findOneByInvitCode(String invitCode) {
        return this.userMapper.findOneByInvitCode(invitCode);
    }
}

