/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.impl;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.jarvis.domain.model.Revenue;
import com.zhlh.jarvis.domain.model.RevenueDetail;
import com.zhlh.jarvis.mapper.BaseMapper;
import com.zhlh.jarvis.mapper.RevenueDetailMapper;
import com.zhlh.jarvis.service.RevenueService;
import com.zhlh.jarvis.service.impl.BaseServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RevenueServiceImpl
extends BaseServiceImpl<Revenue>
implements RevenueService {
    @Autowired
    private RevenueDetailMapper revenueDetailMapper;

    @Override
    public BaseMapper<Revenue> getBaseMapper() {
        return this.revenueDetailMapper;
    }

    @Override
    public List<RevenueDetail> findRevenueListByUserIdAndNowDate(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        }
        List revenueDetailList = this.revenueDetailMapper.findRevenueBusCategory(userId, month);
        return revenueDetailList;
    }

    @Override
    public List<RevenueDetail> ownerCarInsurance(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        }
        List ownerCarInsurance = this.revenueDetailMapper.ownerCarInsurance(userId, month);
        return ownerCarInsurance;
    }

    @Override
    public List<RevenueDetail> childrenParterSumPremiumAndAllanceAmount(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        }
        List childrenParterSumPremiumAndAllanceAmountList = this.revenueDetailMapper.childrenParterSumPremiumAndAllanceAmount(userId, month);
        return childrenParterSumPremiumAndAllanceAmountList;
    }

    @Override
    public List<RevenueDetail> parterCarInsuranceDetailList(Integer userId, String month) {
        if (CommonUtil.isEmpty((String)month)) {
            month = this.getCunrrentMonth();
        }
        List parterCarInsuranceDetailList = this.revenueDetailMapper.parterCarInsuranceDetailList(userId, month);
        return parterCarInsuranceDetailList;
    }

    @Override
    public RevenueDetail ownerAccumulatedIncome(Integer userId) {
        RevenueDetail revenueDetail = this.revenueDetailMapper.ownerAccumulatedIncome(userId);
        return revenueDetail;
    }

    private String getCunrrentMonth() {
        String nowMonth = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM");
        return nowMonth;
    }
}

