/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.impl;

import com.zhlh.jarvis.domain.model.AtinBalanceRecord;
import com.zhlh.jarvis.domain.model.AtinOrder;
import com.zhlh.jarvis.domain.model.AtinOrderRoles;
import com.zhlh.jarvis.domain.model.AtinPolicy;
import com.zhlh.jarvis.domain.model.AtinRakebackRecord;
import com.zhlh.jarvis.domain.model.AtinUser;
import com.zhlh.jarvis.mapper.AtinBalanceRecordMapper;
import com.zhlh.jarvis.mapper.AtinOrderMapper;
import com.zhlh.jarvis.mapper.AtinOrderRolesMapper;
import com.zhlh.jarvis.mapper.AtinPolicyMapper;
import com.zhlh.jarvis.mapper.AtinRakebackInfoMapper;
import com.zhlh.jarvis.mapper.AtinRakebackRecordMapper;
import com.zhlh.jarvis.mapper.AtinUserMapper;
import com.zhlh.jarvis.service.RakeBackService;
import com.zhlh.jarvis.service.wechat.MessageHelper;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RakeBackServiceImpl
implements RakeBackService {
    @Autowired
    private AtinUserMapper userMapper;
    @Autowired
    private AtinOrderMapper orderMapper;
    @Autowired
    private AtinPolicyMapper policyMapper;
    @Autowired
    private AtinBalanceRecordMapper balanceRecordMapper;
    @Autowired
    private AtinRakebackRecordMapper rakebackRecordMapper;
    @Autowired
    private AtinRakebackInfoMapper rakebackInfoMapper;
    @Autowired
    private AtinOrderRolesMapper orderRolesMapper;
    @Autowired
    private AtinRakebackRecordMapper atinRakebackRecordMapper;

    @Override
    public void rakeBack(Integer userId, Integer orderId) {
        AtinOrder order = (AtinOrder)this.orderMapper.selectByPrimaryKey(orderId);
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(userId);
        BigDecimal backCount = order.getRackbackPremium();
        BigDecimal premium = order.getSumAmount();
        this.processBalance(user, backCount, order.getId(), premium);
        if (null != premium) {
            AtinOrderRoles orderRoles = (AtinOrderRoles)this.orderRolesMapper.selectByPrimaryKey(order.getOrderRolesId());
            MessageHelper.notifyRakeBack(user.getOpenid(), orderRoles.getApplicantName(), backCount);
        }
    }

    @Override
    public void notifyRakeAndParentRakeFee(String innerPlcyNo) {
        AtinPolicy policy = this.policyMapper.getPolicyByInnerPlcyNo(innerPlcyNo);
        AtinOrder lbOrder = this.orderMapper.getOrderByPolicyId(policy.getId());
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(lbOrder.getUserId());
        AtinUser parentUser = (AtinUser)this.userMapper.selectByPrimaryKey(user.getParentId());
        AtinRakebackRecord atinRakebackRecord = this.atinRakebackRecordMapper.getRecordByOrderId(lbOrder.getId());
        if (parentUser.getInvitCode().indexOf("ZHLH") > -1) {
            this.rakeBack(lbOrder.getUserId(), lbOrder.getId());
        } else {
            this.rakeBack(lbOrder.getUserId(), lbOrder.getId());
            if (atinRakebackRecord.getParentRakebackAmount().compareTo(new BigDecimal("0.00")) != 0) {
                MessageHelper.notifyParentRakeBack(parentUser.getOpenid(), user.getUsername(), atinRakebackRecord.getParentRakebackAmount().setScale(2, 4));
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized void processBalance(AtinUser user, BigDecimal backCount, Integer orderId, BigDecimal premium) {
        AtinRakebackRecord rakebackRecordExist = this.rakebackRecordMapper.getRecordByOrderId(orderId);
        if (null != rakebackRecordExist && rakebackRecordExist.getUserId() == user.getId()) {
            return;
        }
        BigDecimal oldBalance = user.getAmountBalance();
        AtinBalanceRecord balanceRecord = new AtinBalanceRecord();
        balanceRecord.setAmountBalance(oldBalance);
        balanceRecord.setAmount(backCount);
        balanceRecord.setUserId(user.getId());
        balanceRecord.setSourceType(Integer.valueOf(0));
        balanceRecord.setChangeType(Integer.valueOf(1));
        balanceRecord.setRemark("\u8fd4\u4f63\u4f59\u989d\u589e\u52a0");
        balanceRecord.setOccurTime(new Date());
        this.balanceRecordMapper.insertSelective((Object)balanceRecord);
    }
}

