/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.impl;

import com.zhlh.Tiny.page.bean.Page;
import com.zhlh.jarvis.domain.model.AtinBalanceRecord;
import com.zhlh.jarvis.domain.model.AtinUser;
import com.zhlh.jarvis.domain.model.AtinWithdrawCashRecord;
import com.zhlh.jarvis.dto.BalanceRecordDto;
import com.zhlh.jarvis.mapper.AtinBalanceRecordMapper;
import com.zhlh.jarvis.mapper.AtinUserMapper;
import com.zhlh.jarvis.mapper.AtinWithdrawCashRecordMapper;
import com.zhlh.jarvis.mapper.BaseMapper;
import com.zhlh.jarvis.service.BalanceRecordService;
import com.zhlh.jarvis.service.impl.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BalanceRecordServiceImpl
extends BaseServiceImpl<AtinBalanceRecord>
implements BalanceRecordService {
    @Autowired
    public AtinBalanceRecordMapper atinBalanceRecordMapper;
    @Autowired
    public AtinWithdrawCashRecordMapper withdrawCashRecordMapper;
    @Autowired
    public AtinUserMapper userMapper;

    @Override
    public BaseMapper<AtinBalanceRecord> getBaseMapper() {
        return this.atinBalanceRecordMapper;
    }

    @Override
    public Page<BalanceRecordDto> getAllBalanceRecords(Integer userId, String seriNum, Integer pageNo, Integer pageSize) {
        String userName = this.userMapper.selectByPrimaryKey(userId) == null ? "" : ((AtinUser)this.userMapper.selectByPrimaryKey(userId)).getUsername();
        Page result = new Page();
        ArrayList<BalanceRecordDto> dtos = new ArrayList<BalanceRecordDto>();
        Page page = new Page(pageNo.intValue(), pageSize.intValue());
        this.atinBalanceRecordMapper.getAllBalanceRecords(userId, page);
        result.setPageNo(pageNo.intValue());
        result.setPageSize(pageSize.intValue());
        result.setTotalRecord(page.getTotalRecord());
        result.setTotalPage(page.getTotalPage());
        ArrayList<Integer> recordIdList = new ArrayList<Integer>();
        for (AtinBalanceRecord balanceRecord : page.getResults()) {
            BalanceRecordDto dto = new BalanceRecordDto();
            BeanUtils.copyProperties((Object)balanceRecord, (Object)((Object)dto));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String dateCreate = format.format(balanceRecord.getOccurTime());
            dto.setOccurDate(dateCreate);
            dto.setUserName(userName);
            recordIdList.add(balanceRecord.getSourceId());
            dtos.add(dto);
        }
        List recordList = this.withdrawCashRecordMapper.selectRecordByIds(recordIdList);
        HashMap<Integer, AtinWithdrawCashRecord> map = new HashMap<Integer, AtinWithdrawCashRecord>();
        for (AtinWithdrawCashRecord record : recordList) {
            map.put(record.getId(), record);
        }
        for (BalanceRecordDto dto : dtos) {
            Integer id = dto.getSourceId();
            if (id == null) continue;
            String serilizeNum = map.get(id) == null ? "" : ((AtinWithdrawCashRecord)map.get(id)).getSerialNumberId();
            dto.setSeriNum(serilizeNum);
        }
        result.setResults(dtos);
        return result;
    }
}

