/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.impl;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CityLicense;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.jarvis.domain.model.AtinAgency;
import com.zhlh.jarvis.domain.model.AtinAgencySupportInsuc;
import com.zhlh.jarvis.domain.model.AtinInsurer;
import com.zhlh.jarvis.domain.model.AtinUserAgency;
import com.zhlh.jarvis.domain.model.AtinUserRoles;
import com.zhlh.jarvis.dto.AgencyDto;
import com.zhlh.jarvis.dto.AgencyInsuComDto;
import com.zhlh.jarvis.dto.AgencySupportDto;
import com.zhlh.jarvis.dto.InsurerDto;
import com.zhlh.jarvis.dto.InsurerListDto;
import com.zhlh.jarvis.mapper.AtinAgencyMapper;
import com.zhlh.jarvis.mapper.AtinAgencySupportInsucMapper;
import com.zhlh.jarvis.mapper.AtinUserAgencyMapper;
import com.zhlh.jarvis.mapper.AtinUserRolesMapper;
import com.zhlh.jarvis.mapper.BaseMapper;
import com.zhlh.jarvis.service.AgencyService;
import com.zhlh.jarvis.service.common.ServiceUtil;
import com.zhlh.jarvis.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgencyServiceImpl
extends BaseServiceImpl<AtinAgency>
implements AgencyService {
    @Autowired
    AtinUserAgencyMapper userAgencyMapper;
    @Autowired
    AtinAgencyMapper agencyMapper;
    @Autowired
    AtinAgencySupportInsucMapper agencySupportInsucMapper;
    @Autowired
    AtinUserRolesMapper userRolesMapper;

    @Override
    public BaseMapper<AtinAgency> getBaseMapper() {
        return this.agencyMapper;
    }

    @Override
    public List<AgencyInsuComDto> getAgencyListByUserId(Integer userId) {
        List userAgencyList = this.userAgencyMapper.getUserAgencyListByUserId(userId);
        ArrayList<AgencyInsuComDto> agencyDtoList = new ArrayList<AgencyInsuComDto>();
        for (AtinUserAgency atinUserAgency : userAgencyList) {
            if (null == atinUserAgency) continue;
            AgencyInsuComDto agencyDto = new AgencyInsuComDto();
            Integer agencyId = atinUserAgency.getAgencyId();
            AtinAgency agency = (AtinAgency)this.agencyMapper.selectByPrimaryKey(agencyId);
            agencyDto.setAgency(agency);
            agencyDtoList.add(agencyDto);
        }
        return agencyDtoList;
    }

    @Override
    public List<AgencyDto> getAgencyDtoListById(Integer userId) {
        List userAgencyList = this.userAgencyMapper.getUserAgencyListByUserId(userId);
        ArrayList<AgencyDto> agencyDtoList = new ArrayList<AgencyDto>();
        if (CommonUtil.isEmpty((Collection)userAgencyList)) {
            List userRolesList = new ArrayList();
            userRolesList = this.userRolesMapper.queryRolesByUserId(userId.intValue());
            for (AtinUserRoles userRoles : userRolesList) {
                AgencyDto agencyDto = new AgencyDto();
                Integer agencyId = userRoles.getAgencyId();
                AtinAgency agency = (AtinAgency)this.agencyMapper.selectByPrimaryKey(agencyId);
                BeanUtil.quickCopy((Object)agency, (Object)((Object)agencyDto));
                if (agencyDtoList.contains((Object)agencyDto)) continue;
                agencyDtoList.add(agencyDto);
            }
        } else {
            for (AtinUserAgency userAgency : userAgencyList) {
                AgencyDto agencyDto = new AgencyDto();
                Integer agencyId = userAgency.getAgencyId();
                AtinAgency agency = (AtinAgency)this.agencyMapper.selectByPrimaryKey(agencyId);
                BeanUtil.quickCopy((Object)agency, (Object)((Object)agencyDto));
                agencyDtoList.add(agencyDto);
            }
        }
        return agencyDtoList;
    }

    @Override
    public AtinAgency getAgencyDtoByAgencyId(Integer id) {
        return (AtinAgency)this.agencyMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<AgencyDto> getAgencyDtoListByUserId(Integer userId) {
        List<AgencyDto> agencyList = this.getAgencyDtoListById(userId);
        List supportInsucList = this.agencySupportInsucMapper.findListByAgencyId(Integer.valueOf(1));
        for (AgencyDto agencyDto : agencyList) {
            ArrayList<InsurerDto> insurerList = new ArrayList<InsurerDto>();
            for (AtinAgencySupportInsuc atinAgencySupportInsuc : supportInsucList) {
                if (null == atinAgencySupportInsuc || !atinAgencySupportInsuc.getAgencyId().equals(agencyDto.getId())) continue;
                List<InsurerDto> insurerDtoList = agencyDto.getInsurerList();
                if (null != insurerDtoList) {
                    boolean isAdd = false;
                    for (InsurerDto insurerDto : insurerDtoList) {
                        if (!insurerDto.getCode().equals(atinAgencySupportInsuc.getInsuCom())) continue;
                        isAdd = true;
                    }
                    if (isAdd) continue;
                    InsurerDto insurerDto = new InsurerDto();
                    insurerDto.setCode(atinAgencySupportInsuc.getInsuCom());
                    insurerDto.setDiscount(atinAgencySupportInsuc.getDiscount());
                    AtinInsurer insurer = ServiceUtil.getInsurerByCode(atinAgencySupportInsuc.getInsuCom());
                    if (insurer != null) {
                        BeanUtil.quickCopy((Object)insurer, (Object)((Object)insurerDto));
                    }
                    insurerList.add(insurerDto);
                    agencyDto.setInsurerList(insurerList);
                    continue;
                }
                InsurerDto insurerDto = new InsurerDto();
                insurerDto.setCode(atinAgencySupportInsuc.getInsuCom());
                insurerDto.setDiscount(atinAgencySupportInsuc.getDiscount());
                AtinInsurer insurer = ServiceUtil.getInsurerByCode(atinAgencySupportInsuc.getInsuCom());
                if (insurer != null) {
                    BeanUtil.quickCopy((Object)insurer, (Object)((Object)insurerDto));
                }
                insurerList.add(insurerDto);
                agencyDto.setInsurerList(insurerList);
            }
        }
        return agencyList;
    }

    @Override
    public List<AgencySupportDto> getAgencyDtoListByAgencyId(Integer agencyId, String insuComCode) {
        AtinAgency agency = (AtinAgency)this.agencyMapper.selectByPrimaryKey(agencyId);
        ArrayList<AgencySupportDto> agencySupportList = new ArrayList<AgencySupportDto>();
        List agencySupportInsucList = this.agencySupportInsucMapper.findListByAgencyId(agencyId);
        ArrayList agencySupportInsucs = new ArrayList();
        if (CommonUtil.isNotEmpty((String)insuComCode)) {
            for (int i = 0; i < agencySupportInsucList.size(); ++i) {
                String code = ((AtinAgencySupportInsuc)agencySupportInsucList.get(i)).getInsuCom();
                if (!code.equals(insuComCode)) continue;
                agencySupportInsucs.add(agencySupportInsucList.get(i));
            }
        } else {
            agencySupportInsucs.addAll(agencySupportInsucList);
        }
        for (AtinAgencySupportInsuc agencySupportInsuc : agencySupportInsucs) {
            AgencySupportDto agencySupportDto = new AgencySupportDto();
            BeanUtil.quickCopy((Object)agencySupportInsuc, (Object)((Object)agencySupportDto));
            String shortLicenseNo = agencySupportInsuc.getShortLicenseNo();
            shortLicenseNo = shortLicenseNo + "******";
            CityLicense city = CityLicense.getCityByLicense((String)shortLicenseNo);
            if (null != city) {
                String cityName = city.getName();
                cityName = cityName.replaceAll("\u7701", "");
                agencySupportDto.setCityName(cityName);
            }
            agencySupportDto.setAgencyName(agency.getAgencyName());
            AtinInsurer insurer = ServiceUtil.getInsurerByCode(agencySupportDto.getInsuCom());
            agencySupportDto.setInsuComName(insurer.getAbbreviation());
            agencySupportList.add(agencySupportDto);
        }
        return agencySupportList;
    }

    @Override
    public List<InsurerListDto> getInsurerDtoListByUserId(Integer userId, String type) {
        ArrayList<InsurerListDto> insurerListDtoList = new ArrayList<InsurerListDto>();
        List<AgencyDto> agencyList = this.getAgencyDtoListByUserId(userId);
        if (null == agencyList || agencyList.size() == 0) {
            return null;
        }
        AgencyDto agencyDto = agencyList.get(0);
        List supportInsucList = this.agencySupportInsucMapper.findListByAgencyId(Integer.valueOf(1));
        List<InsurerDto> insurerList = agencyDto.getInsurerList();
        Integer agencyId = 0;
        AtinUserAgency userAgency = this.userAgencyMapper.findByUserType(userId, type);
        for (InsurerDto insurerDto : insurerList) {
            String code = insurerDto.getCode();
            InsurerListDto insurerListDto = new InsurerListDto();
            insurerListDtoList.add(insurerListDto);
            ArrayList<InsurerDto> insurerDtoList = new ArrayList<InsurerDto>();
            insurerListDto.setInsurerList(insurerDtoList);
            for (AtinAgencySupportInsuc atinAgencySupportInsuc : supportInsucList) {
                AtinInsurer insurer;
                if (!atinAgencySupportInsuc.getInsuCom().equals(code)) continue;
                InsurerDto insurerDtoAdd = new InsurerDto();
                insurerListDto.setCode(atinAgencySupportInsuc.getInsuCom());
                insurerDtoAdd.setCode(atinAgencySupportInsuc.getInsuCom());
                insurerDtoAdd.setDiscount(atinAgencySupportInsuc.getDiscount());
                String shortLicenseNo = atinAgencySupportInsuc.getShortLicenseNo();
                insurerDtoAdd.setShortLicenseNo(shortLicenseNo);
                shortLicenseNo = shortLicenseNo + "******";
                CityLicense city = CityLicense.getCityByLicense((String)shortLicenseNo);
                if (null != city) {
                    String cityName = city.getName();
                    cityName = cityName.replaceAll("\u7701", "");
                    insurerDtoAdd.setCityName(cityName);
                    insurerDtoAdd.setCityCode(city.getCode());
                }
                if ((insurer = ServiceUtil.getInsurerByCode(atinAgencySupportInsuc.getInsuCom())) != null) {
                    BeanUtil.quickCopy((Object)insurer, (Object)((Object)insurerDtoAdd));
                }
                insurerListDto.getInsurerList().add(insurerDtoAdd);
                if (null == insurer) continue;
                insurerListDto.setAbbreviation(insurer.getAbbreviation());
            }
        }
        return insurerListDtoList;
    }

    @Override
    public List<AtinAgency> getAllAgency() {
        return this.agencyMapper.getAllAgency(null);
    }
}

