/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.common;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.jarvis.domain.model.AtinAgencySupportInsuc;
import com.zhlh.jarvis.domain.model.AtinCoverage;
import com.zhlh.jarvis.domain.model.AtinInsurer;
import com.zhlh.jarvis.mapper.AtinAgencySupportInsucMapper;
import com.zhlh.jarvis.mapper.AtinCoverageMapper;
import com.zhlh.jarvis.mapper.AtinInsurerMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceCache {
    private static final Logger log = LoggerFactory.getLogger(ServiceCache.class);
    public static Map<String, Object> SERVICE_CACHE;
    public static final String CACHE_COVERAGE_NAME = "coverage";
    public static final String CACHE_INSURER_NAME = "insurer";
    public static final String CACHE_INSU_COM_CITY_NAME = "insu_com_city";
    public static final String CACHE_AGENCY_INSU_COM_NAME = "agency_insu_com";
    @Autowired
    private AtinCoverageMapper coverageMapper;
    @Autowired
    private AtinInsurerMapper insurerMapper;
    @Autowired
    private AtinAgencySupportInsucMapper supportInsucMapper;

    @PostConstruct
    public void initServiceCache() {
        SERVICE_CACHE = new HashMap<String, Object>();
        this.cacheCoverage();
        this.cacheInsurer();
        this.cacheInsurerCity();
        this.cacheAgencyInsurer();
    }

    private void cacheCoverage() {
        List coverageList = this.coverageMapper.getAll();
        HashMap<String, AtinCoverage> coverageMap = new HashMap<String, AtinCoverage>();
        for (AtinCoverage coverage : coverageList) {
            coverageMap.put(coverage.getCoverageCode(), coverage);
        }
        SERVICE_CACHE.put(CACHE_COVERAGE_NAME, coverageMap);
        log.info("\u7f13\u5b58\u9669\u79cd\u5b8c\u6bd5");
    }

    private void cacheInsurer() {
        List insurerList = this.insurerMapper.getAll(null);
        HashMap<String, AtinInsurer> insurerMap = new HashMap<String, AtinInsurer>();
        for (AtinInsurer insurer : insurerList) {
            insurerMap.put(insurer.getCode(), insurer);
        }
        SERVICE_CACHE.put(CACHE_INSURER_NAME, insurerMap);
        log.info("\u7f13\u5b58\u4fdd\u9669\u516c\u53f8\u4fe1\u606f\u5b8c\u6bd5");
    }

    public void cacheInsurerCity() {
        List allInsuComCityList = this.supportInsucMapper.getAll(Integer.valueOf(1));
        HashMap<String, ArrayList<AtinAgencySupportInsuc>> insuComCityListMap = new HashMap<String, ArrayList<AtinAgencySupportInsuc>>();
        for (AtinAgencySupportInsuc insuComCity : allInsuComCityList) {
            ArrayList<AtinAgencySupportInsuc> insuComCityList = (ArrayList<AtinAgencySupportInsuc>)insuComCityListMap.get(insuComCity.getShortLicenseNo());
            if (CommonUtil.isEmpty((Collection)insuComCityList)) {
                insuComCityList = new ArrayList<AtinAgencySupportInsuc>();
            }
            insuComCityList.add(insuComCity);
            insuComCityListMap.put(insuComCity.getShortLicenseNo(), insuComCityList);
        }
        SERVICE_CACHE.put(CACHE_INSU_COM_CITY_NAME, insuComCityListMap);
        log.info("\u7f13\u5b58\u5f00\u901a\u57ce\u5e02\u5b8c\u6bd5");
    }

    public void cacheAgencyInsurer() {
        List allInsuComCityList = this.supportInsucMapper.getAll(Integer.valueOf(1));
        SERVICE_CACHE.put(CACHE_AGENCY_INSU_COM_NAME, allInsuComCityList);
        log.info("\u7f13\u5b58\u4ee3\u7406\u516c\u53f8");
    }
}

