/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.jarvis.service.aspect;

import com.alibaba.fastjson.JSON;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.jarvis.service.common.ErrorMessageConvert;
import com.zhlh.jarvis.service.constant.ChannelConstants;
import com.zhlh.zeus.dto.BaseReqDto;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ZeusServiceAspect {
    private static final Logger LOG = LoggerFactory.getLogger((String)"http");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Around(value="execution(public * com.zhlh.zeus.api.*.*(..))")
    public Object aroundServiceMethod(ProceedingJoinPoint pjp) throws Throwable {
        long start = System.currentTimeMillis();
        String serviceName = pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName();
        String insuCom = "";
        String requestStr = "";
        try {
            Object[] args = pjp.getArgs();
            BaseReqDto reqDto = (BaseReqDto)args[0];
            reqDto.setChannel(ChannelConstants.CHANNEL);
            reqDto.setPartner("zhlh");
            reqDto.setOrigin(ChannelConstants.CHANNEL);
            insuCom = reqDto.getInsuCom();
            requestStr = JsonUtil.beanToJSON((Object)args[0]);
        }
        catch (Exception ignored) {
            Object returnVal = pjp.proceed();
            LOG.info("Service: {}, InsuCom: {}, Request: {}, Return: {}, Cost: {}.", new Object[]{serviceName, insuCom, requestStr, JSON.toJSONString((Object)returnVal), System.currentTimeMillis() - start + "ms"});
            ErrorMessageConvert.errorConvert(returnVal);
            return returnVal;
            catch (Throwable throwable) {
                Object returnVal2 = pjp.proceed();
                LOG.info("Service: {}, InsuCom: {}, Request: {}, Return: {}, Cost: {}.", new Object[]{serviceName, insuCom, requestStr, JSON.toJSONString((Object)returnVal2), System.currentTimeMillis() - start + "ms"});
                ErrorMessageConvert.errorConvert(returnVal2);
                return returnVal2;
            }
        }
        Object returnVal = pjp.proceed();
        LOG.info("Service: {}, InsuCom: {}, Request: {}, Return: {}, Cost: {}.", new Object[]{serviceName, insuCom, requestStr, JSON.toJSONString((Object)returnVal), System.currentTimeMillis() - start + "ms"});
        ErrorMessageConvert.errorConvert(returnVal);
        return returnVal;
    }
}

