/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.util;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.RegexUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberUtil {
    public static final String CURRENCY_FEN_REGEX = "\\-?[0-9]+";
    private static final int DEFAULT_DIV_SCALE = 10;
    private static final int DEFAULT_DIV_ROUND_MODE = 4;

    public static Integer nullToZero(Integer number) {
        if (null == number) {
            return 0;
        }
        return number;
    }

    public static Integer nullToZero(String number) {
        if (CommonUtil.isEmpty((String)number)) {
            return 0;
        }
        return Integer.parseInt(number);
    }

    public static String nullToZeroStr(String number) {
        if (CommonUtil.isEmpty((String)number)) {
            return "0";
        }
        return number;
    }

    public static String changeFToY(int amount) {
        return BigDecimal.valueOf(amount).divide(new BigDecimal(100)).toString();
    }

    public static String changeFToY(String amount) {
        BigDecimal b = new BigDecimal(amount);
        return b.divide(new BigDecimal(100)).toString();
    }

    public static String changeYToF(String amount) {
        return NumberUtil.multiply(amount, "100");
    }

    public static String add(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).toString();
    }

    public static String subtract(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).toString();
    }

    public static String multiply(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).toString();
    }

    public static String divide(String v1, String v2, int scale, int roundMode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, scale, roundMode).toString();
    }

    public static String divide(String v1, String v2) {
        return NumberUtil.divide(v1, v2, 10, 4);
    }

    public static String divide(String v1, String v2, int scale) {
        return NumberUtil.divide(v1, v2, scale, 4);
    }

    public static String round(String v, int scale) {
        return NumberUtil.round(v, scale, 4);
    }

    public static String round(String v, int scale, int round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v);
        return b.setScale(scale, round_mode).toString();
    }

    public static int toInt(String str) {
        return NumberUtils.toInt((String)str, (int)-1);
    }

    public static int toInt(String str, int def) {
        return NumberUtils.toInt((String)str, (int)def);
    }

    public static int changeFToInt(String f) {
        return NumberUtil.toInt(NumberUtil.round(f, 0, 4));
    }

    public static String toStr(int i) {
        return Integer.toString(i);
    }

    public static String toStr(long l) {
        return Long.toString(l);
    }

    public static String toStr(Object o) {
        return ToStringBuilder.reflectionToString((Object)o);
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.multiply("1.0", "100"));
        System.out.println(RegexUtil.checkDecimals((String)"12.3"));
    }
}

