/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.impl.atin;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.arthas.domain.model.AtinVehicle;
import com.zhlh.arthas.mapper.AtinVehicleMapper;
import com.zhlh.arthas.mapper.BaseMapper;
import com.zhlh.arthas.service.VehicleService;
import com.zhlh.arthas.service.common.ServiceUtil;
import com.zhlh.arthas.service.constant.ChannelConstants;
import com.zhlh.arthas.service.impl.BaseServiceImpl;
import com.zhlh.zeus.api.VehicleInfoRService;
import com.zhlh.zeus.dto.vehicle.QueryVehicleReqDto;
import com.zhlh.zeus.dto.vehicle.QueryVehicleResDto;
import com.zhlh.zeus.dto.vehicle.VehicleDesInfoDto;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VehicleServiceImpl
extends BaseServiceImpl<AtinVehicle>
implements VehicleService {
    private static final Logger log = LoggerFactory.getLogger(VehicleServiceImpl.class);
    @Autowired
    private AtinVehicleMapper vehicleMapper;
    @Autowired
    private VehicleInfoRService vehicleInfoRService;
    protected final transient Logger LOG = LoggerFactory.getLogger(VehicleServiceImpl.class);

    @Override
    public BaseMapper<AtinVehicle> getBaseMapper() {
        return this.vehicleMapper;
    }

    private AtinVehicle cleanVehicle(AtinVehicle vehicle) {
        vehicle.setRbcode("");
        vehicle.setVehicleTypeDesc("");
        vehicle.setPurchasePrice("");
        vehicle.setExhaustcapacity("");
        vehicle.setMarketDate("");
        return vehicle;
    }

    @Override
    public int update(AtinVehicle vehicle) {
        vehicle.setModifyTime(new Date());
        return this.vehicleMapper.updateByPrimaryKeySelective((Object)vehicle);
    }

    @Override
    public QueryVehicleResDto vehicleQuery(AtinVehicle atinVehicle, Integer isModify) {
        QueryVehicleReqDto queryVehicleReqDto = new QueryVehicleReqDto();
        queryVehicleReqDto.setChannel(ChannelConstants.CHANNEL);
        BeanUtil.quickCopy((Object)atinVehicle, (Object)queryVehicleReqDto);
        queryVehicleReqDto.setIsModify(isModify);
        queryVehicleReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(atinVehicle.getLicenseNo()));
        queryVehicleReqDto.setPartner("zhlh");
        queryVehicleReqDto.setInsuCom("I00002");
        queryVehicleReqDto.setOrigin(atinVehicle.getOriginCode());
        log.info("\u8f66\u8f86\u4fe1\u606f\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570" + JsonUtil.beanToJSON((Object)queryVehicleReqDto));
        QueryVehicleResDto queryVehicleResDto = this.vehicleInfoRService.queryVehicleInfo(queryVehicleReqDto);
        log.info("\u8f66\u8f86\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c" + JsonUtil.beanToJSON((Object)queryVehicleResDto));
        return queryVehicleResDto;
    }

    @Override
    public AtinVehicle getVehicleByUserIdAndLicenseNo(Integer userId, String licenseNo, String originCode) {
        return this.vehicleMapper.getVehicleByUserIdAndLicenseNo(userId, licenseNo, originCode);
    }

    @Override
    public AtinVehicle updateOrInsertVehicle(AtinVehicle atinVehicle, Integer userId, String originCode) {
        try {
            AtinVehicle dbAtinVehicle = this.vehicleMapper.getVehicleByUserIdAndLicenseNo(userId, atinVehicle.getLicenseNo(), originCode);
            if (dbAtinVehicle != null) {
                this.cleanVehicle(dbAtinVehicle);
                dbAtinVehicle.setFrameNo(atinVehicle.getFrameNo());
                dbAtinVehicle.setEnrollDate(atinVehicle.getEnrollDate());
                dbAtinVehicle.setBrandName(atinVehicle.getBrandName());
                dbAtinVehicle.setEngineNo(atinVehicle.getEngineNo());
                dbAtinVehicle.setOwner(atinVehicle.getOwner());
                dbAtinVehicle.setOriginCode(originCode);
                String marketDate = atinVehicle.getMarketDate();
                dbAtinVehicle.setMarketDate(marketDate);
                dbAtinVehicle.setType(ChannelConstants.WEBTYPE);
                this.update(dbAtinVehicle);
                return dbAtinVehicle;
            }
            atinVehicle.setUserId(userId);
            atinVehicle.setType(ChannelConstants.WEBTYPE);
            atinVehicle.setOriginCode(originCode);
            this.insert(atinVehicle);
            return atinVehicle;
        }
        catch (Exception e) {
            this.LOG.error("updateOrInsertVehicle error:{}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public AtinVehicle updateByVehicleDesInfoDto(VehicleDesInfoDto vehicleDesInfoDto, AtinVehicle vehicle) {
        BeanUtil.quickCopy((Object)vehicleDesInfoDto, (Object)vehicle);
        vehicle.setPurchasePrice(String.valueOf(vehicleDesInfoDto.getPurchasePrice()));
        vehicle.setExhaustcapacity(vehicleDesInfoDto.getExhaustCapacity());
        this.update(vehicle);
        return vehicle;
    }

    @Override
    public AtinVehicle getActiveVehicleByUserId(Integer userId) {
        return this.vehicleMapper.getActiveVehicleByUserId(userId);
    }

    @Override
    public void setActiveVehicleById(Integer id, Integer userId) {
        this.vehicleMapper.setActiveVehicleById(id, userId);
    }

    @Override
    public AtinVehicle getVehicleByLicenseNo(String licenseNo, String originCode) {
        return this.vehicleMapper.getVehicleByLicenseNo(licenseNo, originCode);
    }

    @Override
    public void upsertBasicVehicle(AtinVehicle atinVehicle) {
        try {
            String originCode = atinVehicle.getOriginCode();
            AtinVehicle dbAtinVehicle = this.vehicleMapper.getVehicleByUserIdAndLicenseNo(null, atinVehicle.getLicenseNo(), originCode);
            if (dbAtinVehicle != null) {
                dbAtinVehicle.setFrameNo(atinVehicle.getFrameNo());
                dbAtinVehicle.setEnrollDate(atinVehicle.getEnrollDate());
                dbAtinVehicle.setBrandName(atinVehicle.getBrandName());
                dbAtinVehicle.setEngineNo(atinVehicle.getEngineNo());
                dbAtinVehicle.setOwner(atinVehicle.getOwner());
                dbAtinVehicle.setOriginCode(originCode);
                this.update(dbAtinVehicle);
            } else {
                this.insert(atinVehicle);
            }
        }
        catch (Exception e) {
            this.LOG.error("upsertBasicVehicle error:{}", (Object)e.getMessage());
        }
    }
}

