/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.impl.atin;

import com.zhlh.Tiny.exception.CommonException;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.arthas.domain.dto.atin.QuotationCoverageDto;
import com.zhlh.arthas.domain.dto.atin.QuotationDto;
import com.zhlh.arthas.domain.dto.atin.QuotePriceResultDto;
import com.zhlh.arthas.domain.model.AtinCoverage;
import com.zhlh.arthas.domain.model.AtinInsurer;
import com.zhlh.arthas.domain.model.AtinOrder;
import com.zhlh.arthas.domain.model.AtinOrderAction;
import com.zhlh.arthas.domain.model.AtinOrderRoles;
import com.zhlh.arthas.domain.model.AtinOriginCity;
import com.zhlh.arthas.domain.model.AtinPayLog;
import com.zhlh.arthas.domain.model.AtinPolicy;
import com.zhlh.arthas.domain.model.AtinPolicyCoverage;
import com.zhlh.arthas.domain.model.AtinQuotation;
import com.zhlh.arthas.domain.model.AtinQuotationCoverage;
import com.zhlh.arthas.domain.model.AtinVehicle;
import com.zhlh.arthas.domain.model.AtinVehicleRoles;
import com.zhlh.arthas.domain.model.OriginUser;
import com.zhlh.arthas.mapper.AtinOrderActionMapper;
import com.zhlh.arthas.mapper.AtinOrderMapper;
import com.zhlh.arthas.mapper.AtinOrderRolesMapper;
import com.zhlh.arthas.mapper.AtinOriginCityMapper;
import com.zhlh.arthas.mapper.AtinPayLogMapper;
import com.zhlh.arthas.mapper.AtinPolicyCoverageMapper;
import com.zhlh.arthas.mapper.AtinPolicyMapper;
import com.zhlh.arthas.mapper.AtinQuotationCoverageMapper;
import com.zhlh.arthas.mapper.AtinQuotationMapper;
import com.zhlh.arthas.mapper.AtinVehicleMapper;
import com.zhlh.arthas.mapper.AtinVehicleRolesMapper;
import com.zhlh.arthas.mapper.BaseMapper;
import com.zhlh.arthas.service.QuotationService;
import com.zhlh.arthas.service.common.ServiceUtil;
import com.zhlh.arthas.service.constant.ChannelConstants;
import com.zhlh.arthas.service.impl.BaseServiceImpl;
import com.zhlh.arthas.util.ErrorMessageUtil;
import com.zhlh.arthas.util.NumberUtil;
import com.zhlh.zeus.api.EndDateRService;
import com.zhlh.zeus.api.QuotePriceRService;
import com.zhlh.zeus.dto.endDate.EndDateReqDto;
import com.zhlh.zeus.dto.endDate.EndDateResDto;
import com.zhlh.zeus.dto.quote.CoverageDataDto;
import com.zhlh.zeus.dto.quote.CustomerDataDto;
import com.zhlh.zeus.dto.quote.QuotePriceReqDto;
import com.zhlh.zeus.dto.quote.QuotePriceResDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuotationServiceImpl
extends BaseServiceImpl<AtinQuotation>
implements QuotationService {
    private static final Logger log = LoggerFactory.getLogger(QuotationServiceImpl.class);
    @Autowired
    EndDateRService endDateRService;
    @Autowired
    private AtinQuotationMapper quotationMapper;
    @Autowired
    private AtinQuotationCoverageMapper quotationCoverageMapper;
    @Autowired
    private QuotePriceRService quotePriceRService;
    @Autowired
    private AtinVehicleMapper vehicleMapper;
    @Autowired
    private AtinPolicyMapper policyMapper;
    @Autowired
    private AtinPolicyCoverageMapper policyCoverageMapper;
    @Autowired
    private AtinOrderRolesMapper orderRolesMapper;
    @Autowired
    private AtinPayLogMapper payLogMapper;
    @Autowired
    private AtinOrderMapper lbOrderMapper;
    @Autowired
    private AtinOrderActionMapper orderActionMapper;
    @Autowired
    private AtinVehicleRolesMapper vehicleRolesMapper;
    @Autowired
    private AtinOriginCityMapper atinOriginCityMapper;

    @Override
    public BaseMapper<AtinQuotation> getBaseMapper() {
        return this.quotationMapper;
    }

    @Override
    public int isChangedQuotePriceReqDto(Integer userId, QuotePriceReqDto quotePriceReqDto) {
        String quoteQueryStr;
        QuotePriceReqDto quotePriceReqDtoBaseCustom = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        String quoteQueryBaseCustonStr = ServiceUtil.getQuoteQueryStr(quotePriceReqDtoBaseCustom);
        if (quoteQueryBaseCustonStr.equals(quoteQueryStr = ServiceUtil.getQuoteQueryStr(quotePriceReqDto))) {
            return 0;
        }
        return 1;
    }

    @Override
    public int isChangedQuotePriceReqDto(Integer orderId) {
        AtinOrder lbOrder = (AtinOrder)this.lbOrderMapper.selectByPrimaryKey(orderId);
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(lbOrder.getPolicyId());
        QuotePriceReqDto quotePriceReqDto = this.getQuotePriceReqDtoByQuotationId(policy.getQuotationId());
        return this.isChangedQuotePriceReqDto(lbOrder.getUserId(), quotePriceReqDto);
    }

    private QuotePriceReqDto getQuotePriceReqDtoByQuotationId(Integer quotationId) {
        QuotePriceReqDto quotePriceReqDto = new QuotePriceReqDto();
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        BeanUtil.quickCopy((Object)quotation, (Object)quotePriceReqDto);
        quotePriceReqDto.setMarketDate(quotation.getMarketDate());
        quotePriceReqDto.setPurchasePrice(Integer.valueOf(Integer.parseInt(quotation.getPurchasePrice())));
        quotePriceReqDto.setActualValue(Integer.valueOf(Integer.parseInt(quotation.getActualValue())));
        quotePriceReqDto.setTciStartDate(DateUtil.formatDate((Date)quotation.getTciStartDate()));
        quotePriceReqDto.setVciStartDate(DateUtil.formatDate((Date)quotation.getVciStartDate()));
        quotePriceReqDto.setTciDefaultStartDate(DateUtil.formatDate((Date)quotation.getTciDefaultStartDate()));
        quotePriceReqDto.setVciDefaultStartDate(DateUtil.formatDate((Date)quotation.getVciDefaultStartDate()));
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        List<CoverageDataDto> coverageDataDtoList = this.quotationCoverageListToCoverageDataDtoList(quotationCoverageList);
        quotePriceReqDto.setCoverageDataDtoList(coverageDataDtoList);
        return quotePriceReqDto;
    }

    @Override
    public QuotationDto getQuotationDtoByVehicleId(Integer vehicleId) {
        AtinVehicle vehicleInfo = (AtinVehicle)this.vehicleMapper.selectByPrimaryKey(vehicleId);
        AtinVehicle vehicle = (AtinVehicle)this.vehicleMapper.selectByPrimaryKey(vehicleId);
        Integer userId = vehicleInfo.getUserId();
        if (null != vehicle) {
            String queryLicenseNo;
            String licenseNo = vehicle.getLicenseNo();
            QuotePriceReqDto quotePriceReqDtoCustom = ServiceUtil.getQuoteReqDtoFromRedis(userId);
            if (null != quotePriceReqDtoCustom && CommonUtil.isNotEmpty((String)(queryLicenseNo = quotePriceReqDtoCustom.getLicenseNo())) && queryLicenseNo.equals(licenseNo)) {
                log.info("\u53d6\u51fa\u7f13\u5b58\u5404\u7c7b\u8bf7\u6c42\u53c2\u6570");
                QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDtoCustom);
                return quotationDto;
            }
        }
        QuotePriceReqDto quotePriceReqDto = this.vehicleToQuotePriceReqDto(vehicleInfo);
        ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, userId);
        log.info("\u7f13\u5b58\u7a7a\u7684\u8bf7\u6c42\u53c2\u6570");
        QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationDtoBySubmitCoverage(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        List coverageDataDtoList = (quotePriceReqDto = this.formatQuotePriceReqDto(quotePriceReqDto, userId)).getCoverageDataDtoList();
        if (null != coverageDataDtoList) {
            for (CoverageDataDto coverageDataDto : coverageDataDtoList) {
                Integer isDeductibleChoice = coverageDataDto.getIsDeductibleChoice();
                if (null == isDeductibleChoice || isDeductibleChoice != 1) continue;
                CoverageDataDto coverageDataDtoUsual = new CoverageDataDto();
                coverageDataDtoUsual.setCoverageCode("M");
                coverageDataDtoUsual.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual);
                break;
            }
        }
        for (CoverageDataDto coverageDataDto : coverageDataDtoList) {
            coverageDataDto.setAmount(Integer.valueOf(Integer.parseInt(NumberUtil.changeYToF(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getAmount()))))));
            coverageDataDto.setUnitAmount(Integer.valueOf(Integer.parseInt(NumberUtil.changeYToF(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getUnitAmount()))))));
        }
        quotePriceReqDto.setCoverageDataDtoList(coverageDataDtoList);
        ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, userId);
        QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationDtoByOrderId(Integer orderId) {
        AtinOrder lbOrder = (AtinOrder)this.lbOrderMapper.selectByPrimaryKey(orderId);
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(lbOrder.getPolicyId());
        QuotationDto quotationDto = this.getQuotationDtoByQuotationId(policy.getQuotationId());
        quotationDto.setId(policy.getQuotationId());
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationDtoByQuotationId(Integer quotationId) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        QuotePriceReqDto quotePriceReqDto = this.getQuotePriceReqDtoByQuotation(quotation);
        QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
        ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, ((AtinQuotation)this.getByID(quotationId)).getUserId());
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationDtoFromRedis(Integer userId) {
        QuotePriceReqDto quotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        if (quotePriceReqDto == null || quotePriceReqDto.getCoverageDataDtoList() == null || quotePriceReqDto.getCoverageDataDtoList().size() == 0 || CommonUtil.isEmpty((String)quotePriceReqDto.getLicenseNo())) {
            quotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        }
        if (null != quotePriceReqDto) {
            ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, userId);
        }
        QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
        QuotePriceResultDto quotePriceResultDtoEasy = ServiceUtil.getQuoteResultDtoFromRedis(userId);
        String tciStartDateDefault = "";
        String vciStartDateDefault = "";
        if (null != quotePriceResultDtoEasy) {
            Map<String, QuotePriceResDto> map = quotePriceResultDtoEasy.getResultMap();
            for (Map.Entry<String, QuotePriceResDto> entry : map.entrySet()) {
                QuotePriceResDto quotePriceResDto = entry.getValue();
                String tciStartDate = quotePriceResDto.getTciStartDate();
                String vciStartDate = quotePriceResDto.getVciStartDate();
                if (CommonUtil.isNotEmpty((String)tciStartDate)) {
                    tciStartDateDefault = tciStartDate;
                }
                if (!CommonUtil.isNotEmpty((String)vciStartDate)) continue;
                vciStartDateDefault = vciStartDate;
            }
        }
        if (CommonUtil.isNotEmpty((String)tciStartDateDefault)) {
            quotationDto.setTciStartDate(DateUtil.parseDate((String)tciStartDateDefault, (String)"yyyy-MM-dd"));
        }
        if (CommonUtil.isNotEmpty((String)vciStartDateDefault)) {
            quotationDto.setVciStartDate(DateUtil.parseDate((String)vciStartDateDefault, (String)"yyyy-MM-dd"));
        }
        return quotationDto;
    }

    private QuotePriceReqDto vehicleToQuotePriceReqDto(AtinVehicle vehicleInfo) {
        QuotePriceReqDto quotePriceReqDto = new QuotePriceReqDto();
        BeanUtil.quickCopy((Object)vehicleInfo, (Object)quotePriceReqDto);
        quotePriceReqDto.setPurchasePrice(Integer.valueOf(Integer.parseInt(String.valueOf(new BigDecimal(vehicleInfo.getPurchasePrice()).setScale(0, 4)))));
        ArrayList<CoverageDataDto> coverageDataDtoList = new ArrayList<CoverageDataDto>();
        int quoteType = 0;
        switch (quoteType) {
            case 0: {
                CoverageDataDto coverageDataDto = new CoverageDataDto();
                coverageDataDto.setCoverageCode("BZ");
                coverageDataDto.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDto);
                CoverageDataDto coverageDataDto1 = new CoverageDataDto();
                coverageDataDto1.setCoverageCode("A");
                coverageDataDto1.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDto1);
                CoverageDataDto coverageDataDto2 = new CoverageDataDto();
                coverageDataDto2.setCoverageCode("B");
                coverageDataDto2.setAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("300000"))));
                coverageDataDto2.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDto2);
                CoverageDataDto coverageDataDto3 = new CoverageDataDto();
                coverageDataDto3.setCoverageCode("M");
                coverageDataDto3.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDto3);
                break;
            }
            case 1: {
                CoverageDataDto coverageDataDtoUsual = new CoverageDataDto();
                coverageDataDtoUsual.setCoverageCode("BZ");
                coverageDataDtoUsual.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual);
                CoverageDataDto coverageDataDtoUsual1 = new CoverageDataDto();
                coverageDataDtoUsual1.setCoverageCode("A");
                coverageDataDtoUsual1.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual1);
                CoverageDataDto coverageDataDtoUsual2 = new CoverageDataDto();
                coverageDataDtoUsual2.setCoverageCode("B");
                coverageDataDtoUsual2.setAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("500000"))));
                coverageDataDtoUsual2.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual2);
                CoverageDataDto coverageDataDtoUsual3 = new CoverageDataDto();
                coverageDataDtoUsual3.setCoverageCode("G1");
                coverageDataDtoUsual3.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual3);
                CoverageDataDto coverageDataDtoUsual4 = new CoverageDataDto();
                coverageDataDtoUsual4.setCoverageCode("D3");
                coverageDataDtoUsual4.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoUsual4.setUnitAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("10000"))));
                coverageDataDtoList.add(coverageDataDtoUsual4);
                CoverageDataDto coverageDataDtoUsual5 = new CoverageDataDto();
                coverageDataDtoUsual5.setCoverageCode("D4");
                coverageDataDtoUsual5.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoUsual5.setUnitAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("10000"))));
                coverageDataDtoList.add(coverageDataDtoUsual5);
                CoverageDataDto coverageDataDtoUsual6 = new CoverageDataDto();
                coverageDataDtoUsual6.setCoverageCode("F");
                coverageDataDtoUsual6.setModelCode("1");
                coverageDataDtoList.add(coverageDataDtoUsual6);
                CoverageDataDto coverageDataDtoUsual7 = new CoverageDataDto();
                coverageDataDtoUsual7.setCoverageCode("M");
                coverageDataDtoUsual7.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual7);
                break;
            }
            case 2: {
                CoverageDataDto coverageDataDtoTotal = new CoverageDataDto();
                coverageDataDtoTotal.setCoverageCode("BZ");
                coverageDataDtoTotal.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoTotal);
                CoverageDataDto coverageDataDtoTotal1 = new CoverageDataDto();
                coverageDataDtoTotal1.setCoverageCode("A");
                coverageDataDtoTotal1.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoTotal1);
                CoverageDataDto coverageDataDtoTotal2 = new CoverageDataDto();
                coverageDataDtoTotal2.setCoverageCode("B");
                coverageDataDtoTotal2.setAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("500000"))));
                coverageDataDtoTotal2.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoTotal2);
                CoverageDataDto coverageDataDtoTotal3 = new CoverageDataDto();
                coverageDataDtoTotal3.setCoverageCode("G1");
                coverageDataDtoTotal3.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoTotal3);
                CoverageDataDto coverageDataDtoTotal4 = new CoverageDataDto();
                coverageDataDtoTotal4.setCoverageCode("D3");
                coverageDataDtoTotal4.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoTotal4.setUnitAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("10000"))));
                coverageDataDtoList.add(coverageDataDtoTotal4);
                CoverageDataDto coverageDataDtoTotal5 = new CoverageDataDto();
                coverageDataDtoTotal5.setCoverageCode("D4");
                coverageDataDtoTotal5.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoTotal5.setUnitAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("10000"))));
                coverageDataDtoList.add(coverageDataDtoTotal5);
                CoverageDataDto coverageDataDtoTotal6 = new CoverageDataDto();
                coverageDataDtoTotal6.setCoverageCode("F");
                coverageDataDtoTotal6.setModelCode("1");
                coverageDataDtoList.add(coverageDataDtoTotal6);
                CoverageDataDto coverageDataDtoTotal7 = new CoverageDataDto();
                coverageDataDtoTotal7.setCoverageCode("L");
                coverageDataDtoTotal7.setAmount(Integer.valueOf(NumberUtil.toInt(NumberUtil.changeYToF("5000"))));
                coverageDataDtoTotal7.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoTotal7);
                CoverageDataDto coverageDataDtoTotal8 = new CoverageDataDto();
                coverageDataDtoTotal8.setCoverageCode("X1");
                coverageDataDtoTotal8.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoTotal8);
                CoverageDataDto coverageDataDtoUsual9 = new CoverageDataDto();
                coverageDataDtoUsual9.setCoverageCode("M");
                coverageDataDtoUsual9.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual9);
                break;
            }
        }
        quotePriceReqDto.setCoverageDataDtoList(coverageDataDtoList);
        EndDateReqDto endDateReqDto = new EndDateReqDto();
        BeanUtil.quickCopy((Object)vehicleInfo, (Object)endDateReqDto);
        endDateReqDto.setInsuCom("I00002");
        endDateReqDto.setChannel(ChannelConstants.CHANNEL);
        endDateReqDto.setPartner("zhlh");
        endDateReqDto.setOrigin("");
        endDateReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(endDateReqDto.getLicenseNo()));
        log.info("\u4e0a\u5e74\u6b62\u671f\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a" + JsonUtil.beanToJSON((Object)endDateReqDto));
        EndDateResDto endDateResDto = this.endDateRService.queryPolicyEndDate(endDateReqDto);
        log.info("\u4e0a\u5e74\u6b62\u671f\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a" + JsonUtil.beanToJSON((Object)endDateResDto));
        if (null != endDateResDto) {
            String tciStartDateStr = endDateResDto.getTciLastEndDate();
            String vciStartDateStr = endDateResDto.getVciLastEndDate();
            if (CommonUtil.isNotEmpty((String)tciStartDateStr)) {
                Date tciStartDate = DateUtil.parseDate((String)endDateResDto.getTciLastEndDate(), (String)"yyyy-MM-dd");
                tciStartDate = DateUtil.addDays((Date)tciStartDate, (int)1);
                tciStartDateStr = DateUtil.formatDate((Date)tciStartDate);
                quotePriceReqDto.setTciStartDate(tciStartDateStr);
            }
            if (CommonUtil.isNotEmpty((String)vciStartDateStr)) {
                Date vcitartDate = DateUtil.parseDate((String)endDateResDto.getVciLastEndDate(), (String)"yyyy-MM-dd");
                vcitartDate = DateUtil.addDays((Date)vcitartDate, (int)1);
                vciStartDateStr = DateUtil.formatDate((Date)vcitartDate);
                quotePriceReqDto.setVciStartDate(vciStartDateStr);
            }
        }
        return quotePriceReqDto;
    }

    @Override
    public QuotationDto quotePriceReqDtoToQuotationDto(QuotePriceReqDto quotePriceReqDto) {
        QuotationDto quotationDto = new QuotationDto();
        BeanUtil.quickCopy((Object)quotePriceReqDto, (Object)((Object)quotationDto));
        quotationDto.setTciStartDate(DateUtil.parseDate((String)quotePriceReqDto.getTciStartDate(), (String)"yyyy-MM-dd"));
        quotationDto.setVciStartDate(DateUtil.parseDate((String)quotePriceReqDto.getVciStartDate(), (String)"yyyy-MM-dd"));
        ArrayList<QuotationCoverageDto> coverageList = new ArrayList<QuotationCoverageDto>();
        for (CoverageDataDto coverageDataDto : quotePriceReqDto.getCoverageDataDtoList()) {
            QuotationCoverageDto quotationCoverageDto = new QuotationCoverageDto();
            BeanUtil.quickCopy((Object)coverageDataDto, (Object)quotationCoverageDto);
            AtinCoverage coverage = ServiceUtil.getCoverageByCode(quotationCoverageDto.getCoverageCode());
            quotationCoverageDto.setName(coverage.getName());
            quotationCoverageDto.setAmount(new BigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getAmount()))));
            quotationCoverageDto.setUnimount(new BigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getUnitAmount()))));
            quotationCoverageDto.setModelCode(CommonUtil.isNotEmpty((String)coverageDataDto.getModelCode()) ? new Integer(coverageDataDto.getModelCode()) : 0);
            quotationCoverageDto.setDiscount(ServiceUtil.getBigDecimal(coverageDataDto.getDiscount()));
            quotationCoverageDto.setBenchmarkPremium(new BigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getBenchmarkPremium()))));
            quotationCoverageDto.setPremium(new BigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getPremium()))));
            quotationCoverageDto.setQuantity(coverageDataDto.getQuantity());
            coverageList.add(quotationCoverageDto);
        }
        quotationDto.setCoverageList(coverageList);
        return quotationDto;
    }

    private QuotePriceReqDto formatQuotePriceReqDto(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        quotePriceReqDto.setTciStartDate(ServiceUtil.formatStartDate(quotePriceReqDto.getTciStartDate()));
        quotePriceReqDto.setVciStartDate(ServiceUtil.formatStartDate(quotePriceReqDto.getVciStartDate()));
        QuotePriceReqDto redisQuotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        AtinVehicle vehicleInfo = new AtinVehicle();
        if (redisQuotePriceReqDto == null) {
            vehicleInfo = this.vehicleMapper.getActiveVehicleByUserId(userId);
        } else {
            BeanUtil.quickCopy((Object)redisQuotePriceReqDto, (Object)vehicleInfo);
            BeanUtil.quickCopy((Object)vehicleInfo, (Object)quotePriceReqDto);
            vehicleInfo.setPurchasePrice(redisQuotePriceReqDto.getPurchasePrice() + "");
            if (null != vehicleInfo) {
                BeanUtil.quickCopy((Object)vehicleInfo, (Object)quotePriceReqDto);
            }
        }
        vehicleInfo = this.vehicleMapper.getActiveVehicleByUserId(userId);
        if (null != vehicleInfo) {
            quotePriceReqDto.setPurchasePrice(Integer.valueOf(Integer.parseInt(String.valueOf(new BigDecimal(vehicleInfo.getPurchasePrice()).setScale(0, 4)))));
        }
        return quotePriceReqDto;
    }

    private QuotePriceReqDto getQuotePriceReqDtoByQuotation(AtinQuotation quotation) {
        QuotePriceReqDto quotePriceReqDto = new QuotePriceReqDto();
        BeanUtil.quickCopy((Object)quotation, (Object)quotePriceReqDto);
        quotePriceReqDto.setMarketDate(quotation.getMarketDate());
        quotePriceReqDto.setPurchasePrice(Integer.valueOf(Integer.parseInt(quotation.getPurchasePrice())));
        quotePriceReqDto.setActualValue(Integer.valueOf(Integer.parseInt(quotation.getActualValue())));
        quotePriceReqDto.setTciStartDate(DateUtil.formatDate((Date)quotation.getTciStartDate()));
        quotePriceReqDto.setVciStartDate(DateUtil.formatDate((Date)quotation.getVciStartDate()));
        quotePriceReqDto.setTciDefaultStartDate(DateUtil.formatDate((Date)quotation.getTciDefaultStartDate()));
        quotePriceReqDto.setVciDefaultStartDate(DateUtil.formatDate((Date)quotation.getVciDefaultStartDate()));
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotation.getId());
        List<CoverageDataDto> coverageDataDtoList = this.quotationCoverageListToCoverageDataDtoList(quotationCoverageList);
        quotePriceReqDto.setCoverageDataDtoList(coverageDataDtoList);
        return quotePriceReqDto;
    }

    private List<CoverageDataDto> quotationCoverageListToCoverageDataDtoList(List<AtinQuotationCoverage> quotationCoverageList) {
        ArrayList<CoverageDataDto> coverageDataDtoList = new ArrayList<CoverageDataDto>();
        for (AtinQuotationCoverage quotationCoverage : quotationCoverageList) {
            CoverageDataDto coverageDataDto = new CoverageDataDto();
            coverageDataDto.setAmount(Integer.valueOf(NumberUtil.changeFToInt(quotationCoverage.getAmount().toPlainString())));
            coverageDataDto.setUnitAmount(Integer.valueOf(NumberUtil.changeFToInt(quotationCoverage.getUnimount().toPlainString())));
            coverageDataDto.setIsDeductibleChoice(quotationCoverage.getIsDeductibleChoice());
            coverageDataDto.setModelCode(quotationCoverage.getModelCode().toString());
            coverageDataDto.setCoverageCode(quotationCoverage.getCoverageCode());
            coverageDataDtoList.add(coverageDataDto);
        }
        return coverageDataDtoList;
    }

    @Override
    public QuotationDto quotePrice(Integer userId, String insuCom, String originCode) {
        QuotePriceReqDto quotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        if (CommonUtil.isEmpty((String)quotePriceReqDto.getLicenseNo())) {
            throw new CommonException(1, "\u672a\u9009\u62e9\u9669\u79cd,\u65e0\u62a5\u4ef7");
        }
        if (!ServiceUtil.isSupportByInsurerCode(insuCom, quotePriceReqDto.getLicenseNo(), originCode).booleanValue()) {
            throw new CommonException(1, "\u672c\u5730\u533a\u6682\u4e0d\u652f\u6301");
        }
        String quoteQueryStr = ServiceUtil.getQuoteQueryStr(quotePriceReqDto);
        QuotePriceResultDto resultDto = ServiceUtil.getQuoteResultDtoFromRedis(userId);
        QuotePriceResDto quotePriceResDto = null;
        QuotationDto quotationDto = null;
        if (resultDto != null && resultDto.getQuoteQueryStr().equals(quoteQueryStr) && CommonUtil.isNotEmpty(resultDto.getResultMap()) && resultDto.getResultMap().get(insuCom) != null) {
            log.info("\u4eceredis\u4e2d\u53d6\u51fa\u8be2\u4ef7\u7ed3\u679cinsuCom:" + insuCom);
            quotePriceResDto = resultDto.getResultMap().get(insuCom);
            AtinQuotation atinQuotation = this.quotationMapper.getQuotationByQuoteNo(quotePriceResDto.getQuoteNo());
            List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(atinQuotation.getId());
            quotationDto = this.quotationToDto(atinQuotation, quotationCoverageList);
        } else {
            log.info("\u91cd\u65b0\u8be2\u4ef7");
            quotePriceReqDto.setInsuCom(insuCom);
            quotePriceReqDto.setChannel(ChannelConstants.CHANNEL);
            quotePriceReqDto.setPartner("zhlh");
            quotePriceReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(quotePriceReqDto.getLicenseNo()));
            quotePriceReqDto.setOrigin(originCode);
            if (null != quotePriceReqDto) {
                log.info(insuCom + "\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto:" + JsonUtil.beanToJSON((Object)quotePriceReqDto));
            } else {
                log.info(insuCom + "\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto\u4e3a\u7a7a");
            }
            quotePriceResDto = this.quotePriceRService.quotePrice(quotePriceReqDto);
            if (null != quotePriceResDto) {
                log.info("\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto:" + JsonUtil.beanToJSON((Object)quotePriceResDto));
            } else {
                log.info("\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto\u4e3a\u7a7a");
            }
            if (quotePriceResDto == null || quotePriceResDto.getErrCode() == null || quotePriceResDto.getErrCode() != 0) {
                throw new CommonException(1, ErrorMessageUtil.errorConvert(quotePriceResDto.getErrCode(), quotePriceResDto.getErrMsg()));
            }
            String modelCodeRes = "";
            String modelCodeReq = "";
            for (CoverageDataDto coverageDataDto : quotePriceReqDto.getCoverageDataDtoList()) {
                if (!coverageDataDto.getCoverageCode().equals("F")) continue;
                modelCodeReq = coverageDataDto.getModelCode();
            }
            for (CoverageDataDto coverageDataDto : quotePriceResDto.getCoverageList()) {
                if (!coverageDataDto.getCoverageCode().equals("F")) continue;
                modelCodeRes = coverageDataDto.getModelCode();
                if (CommonUtil.isEmpty((String)modelCodeRes)) {
                    coverageDataDto.setModelCode(modelCodeReq);
                    continue;
                }
                if (!modelCodeRes.equals("0")) continue;
                coverageDataDto.setModelCode(modelCodeReq);
            }
            quotationDto = this.saveQuotePriceResDtoToQuotation(quotePriceResDto, quotePriceReqDto, userId, originCode);
            if (resultDto == null || !resultDto.getQuoteQueryStr().equals(quoteQueryStr)) {
                resultDto = new QuotePriceResultDto();
                resultDto.setQuoteQueryStr(quoteQueryStr);
                resultDto.setResultMap(new HashMap<String, QuotePriceResDto>());
            }
            resultDto.getResultMap().put(insuCom, quotePriceResDto);
            ServiceUtil.saveQuoteResultDtoToRedis(resultDto, userId);
        }
        return quotationDto;
    }

    @Override
    public QuotePriceResDto quotePriceApi(String insuCom, QuotePriceReqDto quotePriceReqDto, String originCode) {
        if (!ServiceUtil.isSupportByInsurerCode(insuCom, quotePriceReqDto.getLicenseNo(), originCode).booleanValue()) {
            throw new CommonException(1, "\u672c\u5730\u533a\u6682\u4e0d\u652f\u6301");
        }
        quotePriceReqDto.setInsuCom(insuCom);
        quotePriceReqDto.setChannel(ChannelConstants.CHANNEL);
        quotePriceReqDto.setPartner("zhlh");
        quotePriceReqDto.setIsInsureConfirm(Integer.valueOf(0));
        quotePriceReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(quotePriceReqDto.getLicenseNo()));
        quotePriceReqDto.setOrigin(originCode);
        log.info("quotePriceReqDto:" + JsonUtil.beanToJSON((Object)quotePriceReqDto));
        QuotePriceResDto quotePriceResDto = this.quotePriceRService.quotePrice(quotePriceReqDto);
        log.info("quotePriceResDto:" + JsonUtil.beanToJSON((Object)quotePriceResDto));
        if (quotePriceResDto == null || quotePriceResDto.getErrCode() == null || quotePriceResDto.getErrCode() != 0) {
            throw new CommonException(1, ErrorMessageUtil.errorConvert(quotePriceResDto.getErrCode(), quotePriceResDto.getErrMsg()));
        }
        this.updateVehicle(quotePriceReqDto);
        this.saveQuotePriceResDtoToQuotation(quotePriceResDto, quotePriceReqDto, null, originCode);
        return quotePriceResDto;
    }

    private void updateVehicle(QuotePriceReqDto quotePriceReqDto) {
        AtinVehicle atinVehicle = new AtinVehicle();
        atinVehicle.setLicenseNo(quotePriceReqDto.getLicenseNo());
        atinVehicle.setFrameNo(quotePriceReqDto.getFrameNo());
        atinVehicle.setOriginCode(quotePriceReqDto.getOrigin());
        atinVehicle.setMarketDate(quotePriceReqDto.getMarketDate());
        atinVehicle.setPurchasePrice(com.zhlh.Tiny.util.NumberUtil.changeFToY((int)quotePriceReqDto.getPurchasePrice()));
        this.vehicleMapper.updateByUnique(atinVehicle);
    }

    private QuotationDto saveQuotePriceResDtoToQuotation(QuotePriceResDto quotePriceResDto, QuotePriceReqDto quotePriceReqDto, Integer userId, String originCode) {
        AtinQuotation quotation = new AtinQuotation();
        quotation.setOriginCode(originCode);
        quotation.setType(ChannelConstants.WEBTYPE);
        BeanUtil.quickCopy((Object)quotePriceResDto, (Object)quotation);
        quotation.setChannel(ChannelConstants.CHANNEL);
        quotation.setUserId(userId);
        quotation.setSumTravelTax(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getSumTravelTax())));
        quotation.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getBenchmarkPremium())));
        quotation.setDiscount(ServiceUtil.getBigDecimal(quotePriceResDto.getDiscount()));
        quotation.setPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getPremium())));
        quotation.setTciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getTciPremium())));
        quotation.setVciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getVciPremium())));
        quotation.setTciDefaultStartDate(this.formatToDate(quotePriceResDto.getTciDefaultStartDate()));
        quotation.setVciDefaultStartDate(this.formatToDate(quotePriceResDto.getVciDefaultStartDate()));
        quotation.setTciStartDate(this.formatToDate(quotePriceResDto.getTciStartDate()));
        quotation.setVciStartDate(this.formatToDate(quotePriceResDto.getVciStartDate()));
        quotation.setPurchasePrice(String.valueOf(quotePriceResDto.getPurchasePrice()));
        if (null != quotePriceReqDto) {
            quotation.setMarketDate(quotePriceReqDto.getMarketDate());
        }
        quotation.setActualValue(String.valueOf(quotePriceResDto.getActualValue()));
        quotation.setQueryNo(quotePriceResDto.getQuoteNo());
        quotation.setInsuStartDate(new Date());
        BigDecimal luborDiscount = ServiceUtil.getLuborDiscount(quotation.getInsuCom(), quotation.getLicenseNo(), originCode);
        quotation.setLuborDiscount(luborDiscount);
        BigDecimal luborPremium = quotation.getVciPremium().multiply(new BigDecimal(1).subtract(luborDiscount));
        luborPremium = luborPremium.add(quotation.getTciPremium()).add(quotation.getSumTravelTax());
        luborPremium.setScale(0, 4);
        quotation.setLuborPremium(luborPremium);
        quotation.setMarketPremium(ServiceUtil.getMarketPremium(quotation.getInsuCom(), quotation.getLicenseNo(), quotation.getPremium()));
        this.insert(quotation);
        ArrayList<AtinQuotationCoverage> quotationCoverageList = new ArrayList<AtinQuotationCoverage>();
        for (CoverageDataDto coverageDataDto : quotePriceResDto.getCoverageList()) {
            AtinQuotationCoverage quotationCoverage = new AtinQuotationCoverage();
            BeanUtil.quickCopy((Object)coverageDataDto, (Object)quotationCoverage);
            quotationCoverage.setReason(CommonUtil.isEmpty((String)coverageDataDto.getReason()) ? "" : coverageDataDto.getReason());
            quotationCoverage.setQuantity(NumberUtil.nullToZero(coverageDataDto.getQuantity()));
            quotationCoverage.setAmount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getAmount()))));
            quotationCoverage.setUnimount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getUnitAmount()))));
            quotationCoverage.setModelCode(Integer.valueOf(CommonUtil.isNotEmpty((String)coverageDataDto.getModelCode()) ? new Integer(coverageDataDto.getModelCode()) : 0));
            quotationCoverage.setPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getPremium()))));
            quotationCoverage.setDiscount(ServiceUtil.getBigDecimal(coverageDataDto.getDiscount()));
            quotationCoverage.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getBenchmarkPremium()))));
            quotationCoverage.setQuotationId(quotation.getId());
            quotationCoverageList.add(quotationCoverage);
        }
        List coverageDtoList = quotePriceReqDto.getCoverageDataDtoList();
        for (AtinQuotationCoverage quotationCoverage : quotationCoverageList) {
            for (CoverageDataDto coverageDataDto : coverageDtoList) {
                if (!quotationCoverage.getCoverageCode().equals(coverageDataDto.getCoverageCode())) continue;
                quotationCoverage.setAmount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getAmount()))));
                quotationCoverage.setUnimount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getUnitAmount()))));
            }
        }
        this.quotationCoverageMapper.batchInsert(quotationCoverageList);
        return this.quotationToDto(quotation, quotationCoverageList);
    }

    private QuotationDto quotationToDto(AtinQuotation quotation, List<AtinQuotationCoverage> quotationCoverageList) {
        QuotationDto quotationDto = new QuotationDto();
        BeanUtil.quickCopy((Object)quotation, (Object)((Object)quotationDto));
        AtinInsurer insurer = ServiceUtil.getInsurerByCode(quotation.getInsuCom());
        quotationDto.setInsuComName(insurer.getAbbreviation());
        ArrayList<QuotationCoverageDto> coverageList = new ArrayList<QuotationCoverageDto>();
        for (AtinQuotationCoverage quotationCoverage : quotationCoverageList) {
            QuotationCoverageDto quotationCoverageDto = new QuotationCoverageDto();
            BeanUtil.quickCopy((Object)quotationCoverage, (Object)quotationCoverageDto);
            AtinCoverage coverage = ServiceUtil.getCoverageByCode(quotationCoverageDto.getCoverageCode());
            quotationCoverageDto.setName(coverage.getName());
            quotationCoverageDto.setAssortment(coverage.getAssortment());
            coverageList.add(quotationCoverageDto);
        }
        quotationDto.setCoverageList(coverageList);
        return quotationDto;
    }

    @Override
    public Integer preciseQuotePrice(AtinOrderRoles orderRoles, String quoteNo, String originCode) {
        log.info("\u7cbe\u786e\u62a5\u4ef7\u5f00\u59cb");
        AtinQuotation quotation = this.quotationMapper.getQuotationByQuoteNo(quoteNo);
        return this.preciseQuotePrice(orderRoles, quotation, null, originCode);
    }

    @Override
    public Integer preciseQuotePrice(AtinOrderRoles orderRoles, Integer quotationId, OriginUser user, String originCode) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        return this.preciseQuotePrice(orderRoles, quotation, user, originCode);
    }

    private Integer preciseQuotePrice(AtinOrderRoles orderRoles, AtinQuotation quotation, OriginUser user, String originCode) {
        Integer userId = user == null ? null : user.getId();
        orderRoles = this.changeOrderRoles(orderRoles, user);
        QuotePriceReqDto quotePriceReqDto = this.getQuotePriceReqDtoByQuotation(quotation);
        quotePriceReqDto = this.setOrderRolesToQuotePriceReqDto(quotePriceReqDto, orderRoles);
        quotePriceReqDto.setIsInsureConfirm(Integer.valueOf(1));
        this.saveOrUpdateVehicleRoles(orderRoles, userId, quotePriceReqDto.getLicenseNo(), originCode);
        quotePriceReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(quotePriceReqDto.getLicenseNo()));
        quotePriceReqDto.setPartner("zhlh");
        if (null != quotePriceReqDto) {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto:" + JsonUtil.beanToJSON((Object)quotePriceReqDto));
        } else {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto\u4e3a\u7a7a");
        }
        quotePriceReqDto.setOrigin(originCode);
        QuotePriceResDto quotePriceResDto = this.quotePriceRService.quotePrice(quotePriceReqDto);
        if (null != quotePriceResDto) {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto:" + JsonUtil.beanToJSON((Object)quotePriceResDto));
        } else {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto\u4e3a\u7a7a");
        }
        log.info("\u6b63\u5728\u8fdb\u884c\u7cbe\u786e\u62a5\u4ef7");
        if (quotePriceResDto.getErrCode() != 0) {
            throw new CommonException(quotePriceResDto.getErrCode().intValue(), ErrorMessageUtil.errorConvert(quotePriceResDto.getErrCode(), quotePriceResDto.getErrMsg()));
        }
        this.orderRolesMapper.insertSelective((Object)orderRoles);
        QuotationDto quotationDto = this.saveQuotePriceResDtoToQuotation(quotePriceResDto, quotePriceReqDto, userId, originCode);
        AtinPolicy policy = this.saveQuotePriceResDtoToPolicy(quotePriceResDto, quotePriceReqDto, quotationDto.getId(), originCode);
        AtinOrder lbOrder = this.saveLbOrder(policy, userId, orderRoles, originCode);
        return lbOrder.getId();
    }

    private void saveOrUpdateVehicleRoles(AtinOrderRoles orderRoles, Integer userId, String licenseNo, String originCode) {
        AtinVehicleRoles vehicleRoles = this.vehicleRolesMapper.selectByUserIdAndLicenseNo(userId, licenseNo, originCode);
        if (vehicleRoles == null) {
            vehicleRoles = new AtinVehicleRoles();
            vehicleRoles.setType(ChannelConstants.WEBTYPE);
            vehicleRoles.setOriginCode(originCode);
            BeanUtil.quickCopy((Object)orderRoles, (Object)vehicleRoles);
            vehicleRoles.setUserId(userId);
            vehicleRoles.setLicenseNo(licenseNo);
            this.vehicleRolesMapper.insertSelective((Object)vehicleRoles);
        } else {
            BeanUtil.quickCopy((Object)orderRoles, (Object)vehicleRoles);
            this.vehicleRolesMapper.updateByPrimaryKeySelective((Object)vehicleRoles);
        }
    }

    @Override
    public QuotationDto getQuotationResultByQuotationId(Integer quotationId) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        QuotationDto quotationDto = this.quotationToDto(quotation, quotationCoverageList);
        Collections.sort(quotationDto.getCoverageList());
        return quotationDto;
    }

    private AtinOrderRoles changeOrderRoles(AtinOrderRoles orderRoles, OriginUser user) {
        orderRoles.setApplicantCertType("01");
        orderRoles.setInsuredCertNo(orderRoles.getApplicantCertNo());
        orderRoles.setInsuredCertType("01");
        orderRoles.setInsuredMobile(orderRoles.getApplicantMobile());
        orderRoles.setInsuredName(orderRoles.getApplicantName());
        orderRoles.setOwnerCertType("01");
        if (user != null) {
            orderRoles.setOpenid(user.getOpenid());
        }
        return orderRoles;
    }

    private QuotePriceReqDto setOrderRolesToQuotePriceReqDto(QuotePriceReqDto quotePriceReqDto, AtinOrderRoles orderRoles) {
        CustomerDataDto ownerData = new CustomerDataDto();
        ownerData.setCertNo(orderRoles.getOwnerCertNo());
        ownerData.setCertType(orderRoles.getOwnerCertType());
        ownerData.setName(orderRoles.getOwnerName());
        ownerData.setPersonType("0");
        CustomerDataDto insurantData = new CustomerDataDto();
        insurantData.setName(orderRoles.getInsuredName());
        insurantData.setCertType(orderRoles.getInsuredCertType());
        insurantData.setCertNo(orderRoles.getInsuredCertNo());
        insurantData.setMobile(orderRoles.getInsuredMobile());
        insurantData.setPersonType("1");
        CustomerDataDto policyHolderData = new CustomerDataDto();
        policyHolderData.setMobile(orderRoles.getApplicantMobile());
        policyHolderData.setCertType(orderRoles.getApplicantCertType());
        policyHolderData.setCertNo(orderRoles.getApplicantCertNo());
        policyHolderData.setName(orderRoles.getApplicantName());
        policyHolderData.setPersonType("2");
        quotePriceReqDto.setOwnerData(ownerData);
        quotePriceReqDto.setInsurantData(insurantData);
        quotePriceReqDto.setPolicyHolderData(policyHolderData);
        return quotePriceReqDto;
    }

    private AtinOrder saveLbOrder(AtinPolicy policy, Integer userId, AtinOrderRoles orderRoles, String originCode) {
        AtinOrder lbOrder = new AtinOrder();
        lbOrder.setOriginCode(originCode);
        lbOrder.setType(ChannelConstants.WEBTYPE);
        lbOrder.setOrderSn(ServiceUtil.randomOrderSn());
        lbOrder.setOrderStatus(AtinOrder.ORDER_STATUS_SUBMIT);
        lbOrder.setPayStatus(AtinOrder.PAY_STATUS_UNPAID);
        lbOrder.setShippingStatus(AtinOrder.SHIP_STATUS_UN_SEND);
        lbOrder.setPremium(policy.getPremium());
        lbOrder.setMarketPremium(policy.getMarketPremium());
        lbOrder.setLuborPremium(policy.getLuborPremium());
        lbOrder.setLuborDiscount(policy.getLuborDiscount());
        lbOrder.setSumAmount(policy.getLuborPremium());
        lbOrder.setPolicyId(policy.getId());
        lbOrder.setOrderRolesId(orderRoles.getId());
        lbOrder.setUserId(userId);
        this.lbOrderMapper.insertSelective((Object)lbOrder);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)lbOrder, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setActionUser("\u7528\u6237");
        orderAction.setActionContent("\u7528\u6237\u4e0b\u5355");
        this.orderActionMapper.insertSelective((Object)orderAction);
        AtinPayLog payLog = new AtinPayLog();
        payLog.setOrderId(lbOrder.getId());
        payLog.setSumAmount(lbOrder.getSumAmount());
        payLog.setIsPaid(Integer.valueOf(0));
        this.payLogMapper.insertSelective((Object)payLog);
        return lbOrder;
    }

    private AtinPolicy saveQuotePriceResDtoToPolicy(QuotePriceResDto quotePriceResDto, QuotePriceReqDto quotePriceReqDto, Integer quotationId, String originCode) {
        AtinPolicy policy = new AtinPolicy();
        policy.setQuotationId(quotationId);
        policy.setChannel(ChannelConstants.CHANNEL);
        BeanUtil.quickCopy((Object)quotePriceResDto, (Object)policy);
        policy.setSumTravelTax(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getSumTravelTax())));
        policy.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getBenchmarkPremium())));
        policy.setDiscount(ServiceUtil.getBigDecimal(NumberUtil.nullToZeroStr(quotePriceResDto.getDiscount())));
        policy.setPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getPremium())));
        policy.setTciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getTciPremium())));
        policy.setVciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getVciPremium())));
        policy.setTciDefaultStartDate(this.formatToDate(quotePriceResDto.getTciDefaultStartDate()));
        policy.setVciDefaultStartDate(this.formatToDate(quotePriceResDto.getVciDefaultStartDate()));
        policy.setTciStartDate(this.formatToDate(quotePriceResDto.getTciStartDate()));
        policy.setVciStartDate(this.formatToDate(quotePriceResDto.getVciStartDate()));
        policy.setQueryNo(quotePriceResDto.getQuoteNo());
        policy.setInsuStartDate(new Date());
        BigDecimal luborDiscount = ServiceUtil.getLuborDiscount(policy.getInsuCom(), policy.getLicenseNo(), originCode);
        policy.setLuborDiscount(luborDiscount);
        BigDecimal luborPremium = policy.getVciPremium().multiply(new BigDecimal(1).subtract(luborDiscount));
        luborPremium = luborPremium.add(policy.getTciPremium()).add(policy.getSumTravelTax());
        policy.setLuborPremium(luborPremium);
        policy.setMarketPremium(ServiceUtil.getMarketPremium(policy.getInsuCom(), policy.getLicenseNo(), policy.getPremium()));
        this.policyMapper.insertSelective((Object)policy);
        ArrayList<AtinPolicyCoverage> policyCoverageList = new ArrayList<AtinPolicyCoverage>();
        for (CoverageDataDto coverageDataDto : quotePriceResDto.getCoverageList()) {
            AtinPolicyCoverage policyCoverage = new AtinPolicyCoverage();
            BeanUtil.quickCopy((Object)coverageDataDto, (Object)policyCoverage);
            policyCoverage.setReason(CommonUtil.isEmpty((String)coverageDataDto.getReason()) ? "" : coverageDataDto.getReason());
            policyCoverage.setQuantity(NumberUtil.nullToZero(coverageDataDto.getQuantity()));
            policyCoverage.setAmount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getAmount()))));
            policyCoverage.setUnimount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getUnitAmount()))));
            policyCoverage.setModelCode(Integer.valueOf(CommonUtil.isNotEmpty((String)coverageDataDto.getModelCode()) ? new Integer(coverageDataDto.getModelCode()) : 0));
            policyCoverage.setPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getPremium()))));
            policyCoverage.setDiscount(ServiceUtil.getBigDecimal(NumberUtil.nullToZeroStr(coverageDataDto.getDiscount())));
            policyCoverage.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getBenchmarkPremium()))));
            policyCoverage.setPolicyId(policy.getId());
            policyCoverageList.add(policyCoverage);
        }
        List coverageDataDtoList = quotePriceReqDto.getCoverageDataDtoList();
        for (CoverageDataDto coverageDataDto : coverageDataDtoList) {
            for (AtinPolicyCoverage policyCoverage : policyCoverageList) {
                if (!policyCoverage.getCoverageCode().equals(coverageDataDto.getCoverageCode())) continue;
                policyCoverage.setAmount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getAmount()))));
                policyCoverage.setUnimount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero(coverageDataDto.getUnitAmount()))));
            }
        }
        this.policyCoverageMapper.batchInsert(policyCoverageList);
        return policy;
    }

    private Date formatToDate(String dstr) {
        return DateUtil.parseDate((String)dstr, (String)"yyyy-MM-dd");
    }

    @Override
    public Boolean isSupportInsuCom(String insucom, String originCode) {
        List insuComList = this.atinOriginCityMapper.getSupportInsuCom(insucom, originCode);
        if (insuComList != null && insuComList.size() >= 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isSupportCity(String cityCode, String originCode, String insuCom) {
        AtinOriginCity city = this.atinOriginCityMapper.getSupportCity(cityCode, originCode, insuCom);
        if (city != null) {
            return true;
        }
        return false;
    }
}

