/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.impl.atin;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.arthas.domain.dto.atin.api.JsonPolicyStatusResDto;
import com.zhlh.arthas.domain.model.AtinOrder;
import com.zhlh.arthas.domain.model.AtinOrderRoles;
import com.zhlh.arthas.domain.model.AtinPolicy;
import com.zhlh.arthas.mapper.AtinOrderMapper;
import com.zhlh.arthas.mapper.AtinOrderRolesMapper;
import com.zhlh.arthas.mapper.AtinPolicyMapper;
import com.zhlh.arthas.mapper.BaseMapper;
import com.zhlh.arthas.service.PolicyStatusService;
import com.zhlh.arthas.service.constant.AbbcConsts;
import com.zhlh.arthas.service.constant.IndlConsts;
import com.zhlh.arthas.service.impl.BaseServiceImpl;
import com.zhlh.arthas.util.NumberUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PolicyStatusServiceImpl
extends BaseServiceImpl<AtinPolicy>
implements PolicyStatusService,
AbbcConsts,
IndlConsts {
    @Autowired
    private AtinPolicyMapper atinPolicyMapper;
    @Autowired
    private AtinOrderRolesMapper atinOrderRolesMapper;
    @Autowired
    private AtinOrderMapper atinOrderMapper;

    @Override
    public BaseMapper<AtinPolicy> getBaseMapper() {
        return this.atinPolicyMapper;
    }

    @Override
    public JsonPolicyStatusResDto policyStatus(String innerPlcyNo) {
        Integer status;
        JsonPolicyStatusResDto jsonPolicyStatusResDto = new JsonPolicyStatusResDto();
        AtinPolicy policy = this.atinPolicyMapper.getPolicyByInnerPlcyNo(innerPlcyNo);
        BeanUtil.adviceCopy((Object)policy, (Object)jsonPolicyStatusResDto);
        jsonPolicyStatusResDto.setOwnerName(policy.getOwner());
        int policyId = policy.getId();
        AtinOrder order = this.atinOrderMapper.getOrderByPolicyId(Integer.valueOf(policyId));
        String insuCom = jsonPolicyStatusResDto.getInsuCom();
        if (CommonUtil.isNotEmpty((String)insuCom) && "I00001".equals(insuCom) && null != order && PAY_STATUS_PAY_INSURE != (status = order.getPayStatus())) {
            jsonPolicyStatusResDto.setVciPolicyNo("");
            jsonPolicyStatusResDto.setTciPolicyNo("");
        }
        if (jsonPolicyStatusResDto.getPremium() != null) {
            jsonPolicyStatusResDto.setPremium(NumberUtil.changeFToY(jsonPolicyStatusResDto.getPremium()));
        }
        if (jsonPolicyStatusResDto.getVciPremium() != null) {
            jsonPolicyStatusResDto.setVciPremium(NumberUtil.changeFToY(jsonPolicyStatusResDto.getVciPremium()));
        }
        if (jsonPolicyStatusResDto.getTciPremium() != null) {
            jsonPolicyStatusResDto.setTciPremium(NumberUtil.changeFToY(jsonPolicyStatusResDto.getTciPremium()));
        }
        if (jsonPolicyStatusResDto.getSumTravelTax() != null) {
            jsonPolicyStatusResDto.setSumTravelTax(NumberUtil.changeFToY(jsonPolicyStatusResDto.getSumTravelTax()));
        }
        int roleId = order.getOrderRolesId();
        AtinOrderRoles roles = (AtinOrderRoles)this.atinOrderRolesMapper.selectByPrimaryKey(Integer.valueOf(roleId));
        jsonPolicyStatusResDto.setAppName(roles.getApplicantName());
        if (order != null) {
            jsonPolicyStatusResDto.setPolicyStatus(PolicyStatusServiceImpl.convertPolicyStatus(order.getOrderStatus()));
            jsonPolicyStatusResDto.setPayStatus(PolicyStatusServiceImpl.convertPayStatus(order.getPayStatus()));
            jsonPolicyStatusResDto.setShipStatus(PolicyStatusServiceImpl.convertShipStatus(order.getShippingStatus()));
        } else {
            jsonPolicyStatusResDto.setPolicyStatus("2");
            jsonPolicyStatusResDto.setPayStatus("0");
            jsonPolicyStatusResDto.setShipStatus("0");
        }
        return jsonPolicyStatusResDto;
    }

    private static String convertPolicyStatus(Integer policyStatus) {
        switch (policyStatus) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return "1";
            }
        }
        return "2";
    }

    private static String convertPayStatus(Integer payStatus) {
        switch (payStatus) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
        }
        return "0";
    }

    private static String convertShipStatus(Integer shipstatus) {
        switch (shipstatus) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
        }
        return "0";
    }
}

