/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.impl.atin;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.arthas.domain.dto.atin.PayCallBackResultDto;
import com.zhlh.arthas.domain.model.AtinOrder;
import com.zhlh.arthas.domain.model.AtinOrderAction;
import com.zhlh.arthas.domain.model.AtinPayLog;
import com.zhlh.arthas.domain.model.AtinPolicy;
import com.zhlh.arthas.mapper.AtinOrderActionMapper;
import com.zhlh.arthas.mapper.AtinOrderMapper;
import com.zhlh.arthas.mapper.AtinOrderRolesMapper;
import com.zhlh.arthas.mapper.AtinPayLogMapper;
import com.zhlh.arthas.mapper.AtinPolicyMapper;
import com.zhlh.arthas.mapper.BaseMapper;
import com.zhlh.arthas.service.PayCallBackService;
import com.zhlh.arthas.service.constant.ChannelConstants;
import com.zhlh.arthas.service.impl.BaseServiceImpl;
import com.zhlh.arthas.util.NumberUtil;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayCallBackServiceImpl
extends BaseServiceImpl<AtinPolicy>
implements PayCallBackService {
    @Autowired
    private AtinPolicyMapper atinPolicyMapper;
    @Autowired
    private AtinOrderMapper atinOrderMapper;
    @Autowired
    private AtinPayLogMapper atinPayLogMapper;
    @Autowired
    private AtinOrderActionMapper atinOrderActionMapper;
    @Autowired
    private AtinOrderRolesMapper atinOrderRolesMapper;

    @Override
    public BaseMapper<AtinPolicy> getBaseMapper() {
        return this.atinPolicyMapper;
    }

    @Override
    public PayCallBackResultDto execute(String innerPlcyNo, String amount, Integer payStatus, String outChargeNo, String chargeComCode, String chargeComName, String payTime, String originCode) {
        AtinOrder order;
        PayCallBackResultDto payCallBackResultDto = new PayCallBackResultDto();
        payStatus = this.convertPayStatus(payStatus);
        AtinPolicy policy = this.atinPolicyMapper.getPolicyByInnerPlcyNo(innerPlcyNo);
        if (policy != null && (order = this.atinOrderMapper.getOrderByPolicyId(policy.getId())) != null && order.getSumAmount().setScale(0, 5).equals(new BigDecimal(amount).multiply(new BigDecimal(100)).setScale(0, 5)) && payStatus.intValue() == AtinOrder.PAY_STATUS_PAID.intValue() && (order.getOrderStatus().intValue() == AtinOrder.ORDER_STATUS_SUBMIT.intValue() || order.getOrderStatus().intValue() == AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS.intValue() || order.getOrderStatus().intValue() == AtinOrder.ORDER_STATUS_TIMEOUT.intValue())) {
            order.setPayStatus(AtinOrder.PAY_STATUS_PAID);
            order.setOrderStatus(AtinOrder.ORDER_STATUS_USER_PAID);
            this.atinOrderMapper.updateByPrimaryKey((Object)order);
            AtinPayLog payLog = new AtinPayLog();
            payLog.setOrderId(order.getId());
            payLog.setSumAmount(order.getSumAmount());
            payLog.setPayAmount(new BigDecimal(NumberUtil.changeYToF(amount)));
            payLog.setPayTime(DateUtil.parseDate((String)payTime, (String)"yyyy-MM-dd HH:mm:ss"));
            payLog.setIsPaid(payStatus);
            payLog.setPayTime(new Date());
            payLog.setOutChargeNo(outChargeNo);
            payLog.setChargeComCode(chargeComCode);
            payLog.setChargeComName(chargeComName);
            payLog.setChargeStatus("ACH");
            payLog.setChargeResult("Y");
            AtinPayLog payLogExist = this.atinPayLogMapper.getByOrderId(order.getId());
            if (null == payLogExist) {
                this.atinPayLogMapper.insert((Object)payLog);
            } else {
                this.atinPayLogMapper.updateByPrimaryKeySelective((Object)payLog);
            }
            Date now = new Date();
            AtinOrderAction orderAction = new AtinOrderAction();
            orderAction.setOrderId(order.getId());
            BeanUtil.quickCopy((Object)order, (Object)orderAction);
            orderAction.setId(null);
            orderAction.setCreateTime(now);
            orderAction.setActionUser("\u7cfb\u7edf");
            orderAction.setActionContent("\u4ed8\u6b3e\u6210\u529f");
            this.atinOrderActionMapper.insertSelective((Object)orderAction);
            AtinPolicy atinPolicy = (AtinPolicy)this.atinPolicyMapper.selectByPrimaryKey(order.getPolicyId());
            payCallBackResultDto.setResult(true);
            payCallBackResultDto.setOutChargeNo(outChargeNo);
            payCallBackResultDto.setOriginCode(originCode);
            payCallBackResultDto.setInnerPlcyNo(atinPolicy.getInnerPlcyNo());
            payCallBackResultDto.setChannel(ChannelConstants.CHANNEL);
            payCallBackResultDto.setChargeComCode(chargeComCode);
            payCallBackResultDto.setTotalFee(NumberUtil.changeFToInt(NumberUtil.changeYToF(com.zhlh.Tiny.util.NumberUtil.nullToZeroStr((String)amount))));
            payCallBackResultDto.setCityCode(atinPolicy.getCityCode());
            payCallBackResultDto.setInsuCom(atinPolicy.getInsuCom());
        }
        return payCallBackResultDto;
    }

    private Integer convertPayStatus(int status) {
        if (status == 0) {
            status = 1;
        } else if (status == 1) {
            status = 0;
        }
        return status;
    }
}

