/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.impl.atin;

import com.zhlh.Tiny.exception.CommonException;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.arthas.domain.dto.atin.CbsNotifyDto;
import com.zhlh.arthas.domain.dto.atin.CbsOutNotifyDto;
import com.zhlh.arthas.domain.dto.atin.OrderDto;
import com.zhlh.arthas.domain.dto.atin.OrderInfoDto;
import com.zhlh.arthas.domain.dto.atin.PayDto;
import com.zhlh.arthas.domain.dto.atin.PolicyCoverageDto;
import com.zhlh.arthas.domain.dto.atin.PolicyDto;
import com.zhlh.arthas.domain.dto.atin.RmNotifyDto;
import com.zhlh.arthas.domain.dto.atin.RmOutNotifyCoverageDto;
import com.zhlh.arthas.domain.dto.atin.RmOutNotifyDto;
import com.zhlh.arthas.domain.model.AtinCoverage;
import com.zhlh.arthas.domain.model.AtinOrder;
import com.zhlh.arthas.domain.model.AtinOrderAction;
import com.zhlh.arthas.domain.model.AtinOrderRoles;
import com.zhlh.arthas.domain.model.AtinPayLog;
import com.zhlh.arthas.domain.model.AtinPolicy;
import com.zhlh.arthas.domain.model.AtinPolicyCoverage;
import com.zhlh.arthas.domain.model.OriginUser;
import com.zhlh.arthas.mapper.AtinOrderActionMapper;
import com.zhlh.arthas.mapper.AtinOrderMapper;
import com.zhlh.arthas.mapper.AtinOrderRolesMapper;
import com.zhlh.arthas.mapper.AtinPayLogMapper;
import com.zhlh.arthas.mapper.AtinPolicyCoverageMapper;
import com.zhlh.arthas.mapper.AtinPolicyMapper;
import com.zhlh.arthas.mapper.BaseMapper;
import com.zhlh.arthas.mapper.OriginUserMapper;
import com.zhlh.arthas.service.OrderService;
import com.zhlh.arthas.service.common.ServiceUtil;
import com.zhlh.arthas.service.constant.ChannelConstants;
import com.zhlh.arthas.service.impl.BaseServiceImpl;
import com.zhlh.arthas.util.ErrorMessageUtil;
import com.zhlh.arthas.util.NumberUtil;
import com.zhlh.zeus.api.IdentityCollectRService;
import com.zhlh.zeus.api.InsureConfirmRService;
import com.zhlh.zeus.api.LuobarPayRService;
import com.zhlh.zeus.dto.identityCollect.IdentityCollectReqDto;
import com.zhlh.zeus.dto.identityCollect.IdentityCollectResDto;
import com.zhlh.zeus.dto.insureConfirm.InsureConfirmReqDto;
import com.zhlh.zeus.dto.insureConfirm.InsureConfirmResDto;
import com.zhlh.zeus.dto.pay.LuoberPayReqDto;
import com.zhlh.zeus.dto.pay.LuoberPayResDto;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
extends BaseServiceImpl<AtinOrder>
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private AtinOrderMapper orderMapper;
    @Autowired
    private AtinPolicyMapper policyMapper;
    @Autowired
    private AtinPolicyCoverageMapper policyCoverageMapper;
    @Autowired
    private AtinOrderRolesMapper orderRolesMapper;
    @Autowired
    private AtinOrderMapper lbOrderMapper;
    @Autowired
    private IdentityCollectRService identityCollectRService;
    @Autowired
    private InsureConfirmRService insureConfirmRService;
    @Autowired
    private LuobarPayRService luobarPayRService;
    @Autowired
    private AtinOrderActionMapper orderActionMapper;
    @Autowired
    private AtinPayLogMapper payLogMapper;
    @Autowired
    private OriginUserMapper originUserMapper;

    @Override
    public BaseMapper<AtinOrder> getBaseMapper() {
        return this.orderMapper;
    }

    private List<OrderDto> findOrderDtoListByOrderList(List<AtinOrder> orderList) {
        ArrayList<OrderDto> orderDtoList = new ArrayList<OrderDto>();
        ArrayList<Integer> policyIdList = new ArrayList<Integer>();
        ArrayList<Integer> orderRolesIdList = new ArrayList<Integer>();
        if (null == orderList) {
            return orderDtoList;
        }
        for (int i = 0; i < orderList.size(); ++i) {
            Integer orderRolesId;
            AtinOrder order = orderList.get(i);
            OrderDto orderDto = new OrderDto();
            BeanUtil.quickCopy((Object)order, (Object)((Object)orderDto));
            orderDtoList.add(orderDto);
            Integer policyId = order.getPolicyId();
            if (null != policyId) {
                policyIdList.add(policyId);
            }
            if (null == (orderRolesId = order.getOrderRolesId())) continue;
            orderRolesIdList.add(orderRolesId);
        }
        List orderRolesList = new ArrayList();
        if (orderRolesIdList.size() > 0) {
            orderRolesList = this.orderRolesMapper.getOrderRolesListByIdList(orderRolesIdList);
        }
        List policyList = new ArrayList();
        if (policyIdList.size() > 0) {
            policyList = this.policyMapper.getPolicyListByIdList(policyIdList);
        }
        List policyCountList = new ArrayList();
        if (policyIdList.size() > 0) {
            policyCountList = this.policyCoverageMapper.getCountList(policyIdList);
        }
        HashMap<Integer, String> orderRolesMap = new HashMap<Integer, String>();
        for (AtinOrderRoles orderRoles : orderRolesList) {
            orderRolesMap.put(orderRoles.getId(), orderRoles.getInsuredName());
        }
        HashMap<Integer, AtinPolicy> policyMap = new HashMap<Integer, AtinPolicy>();
        for (AtinPolicy policy : policyList) {
            policyMap.put(policy.getId(), policy);
        }
        HashMap<Integer, Long> policyCoverageMap = new HashMap<Integer, Long>();
        for (Map map : policyCountList) {
            Integer policyMapId = (Integer)map.get("policyId");
            Long count = (Long)map.get("count");
            policyCoverageMap.put(policyMapId, count);
        }
        for (OrderDto orderDto : orderDtoList) {
            Long count;
            String insuredName;
            Object policyObject = policyMap.get(orderDto.getPolicyId());
            if (null == policyObject) continue;
            AtinPolicy policy = (AtinPolicy)policyObject;
            orderDto.setLicenseNo(policy.getLicenseNo());
            orderDto.setInsuCom(policy.getInsuCom());
            Date date = orderDto.getCreateTime();
            if (null != date) {
                String createTime = DateFormat.getDateInstance(2).format(date);
                orderDto.setCreateOrderTime(createTime);
            }
            Integer policyId = policy.getId();
            Integer rolesId = orderDto.getOrderRolesId();
            Object insuredNameObject = orderRolesMap.get(rolesId);
            if (null != insuredNameObject && CommonUtil.isNotEmpty((String)(insuredName = (String)insuredNameObject))) {
                orderDto.setInsuredName(insuredName);
            }
            if (null != policyCoverageMap.get(policyId) && null != (count = (Long)policyCoverageMap.get(policyId))) {
                orderDto.setCoverageCount(count.intValue());
            }
            orderDto.setInsuComName(ServiceUtil.getInsurerByCode(policy.getInsuCom()).getAbbreviation());
            orderDto.setInsurerImgUrl(ServiceUtil.getInsurerByCode(policy.getInsuCom()).getImgUrl());
        }
        return orderDtoList;
    }

    @Override
    public List<OrderDto> findOrderDtoListByPayStatus(Integer userId, Integer payStatus) {
        List orderList = this.orderMapper.findOrderListByStatus(userId, payStatus);
        return this.findOrderDtoListByOrderList(orderList);
    }

    @Override
    public int cancelOrder(Integer id) {
        AtinOrder orderInfoDto = (AtinOrder)this.getByID(id);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(orderInfoDto.getId());
        BeanUtil.quickCopy((Object)orderInfoDto, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(new Date());
        orderAction.setActionUser("\u7528\u6237");
        orderAction.setActionContent("\u7528\u6237\u53d6\u6d88\u8ba2\u5355");
        this.orderActionMapper.insertSelective((Object)orderAction);
        return this.orderMapper.changeOrderStatus(AtinOrder.ORDER_STATUS_CANCEL, id);
    }

    @Override
    public Integer findCountByPayStatus(Integer userId, Integer payStatus) {
        return this.orderMapper.getCountByStatus(userId, payStatus);
    }

    @Override
    public OrderInfoDto getOrderInfoDtoByOrderId(Integer orderId) {
        OrderInfoDto orderInfoDto = new OrderInfoDto();
        AtinOrder lbOrder = (AtinOrder)this.lbOrderMapper.selectByPrimaryKey(orderId);
        if (null == lbOrder) {
            return orderInfoDto;
        }
        BeanUtil.quickCopy((Object)lbOrder, (Object)((Object)orderInfoDto));
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(lbOrder.getPolicyId());
        PolicyDto policyDto = new PolicyDto();
        BeanUtil.quickCopy((Object)policy, (Object)((Object)policyDto));
        policyDto.setInsuComName(ServiceUtil.getInsurerByCode(policy.getInsuCom()).getAbbreviation());
        ArrayList<PolicyCoverageDto> policyCoverageDtoList = new ArrayList<PolicyCoverageDto>();
        List policyCoverageList = this.policyCoverageMapper.getCoverageList(policy.getId());
        for (AtinPolicyCoverage policyCoverage : policyCoverageList) {
            PolicyCoverageDto policyCoverageDto = new PolicyCoverageDto();
            BeanUtil.quickCopy((Object)policyCoverage, (Object)policyCoverageDto);
            AtinCoverage coverage = ServiceUtil.getCoverageByCode(policyCoverage.getCoverageCode());
            policyCoverageDto.setName(coverage.getName());
            policyCoverageDto.setAssortment(coverage.getAssortment());
            policyCoverageDtoList.add(policyCoverageDto);
        }
        policyDto.setCoverageList(policyCoverageDtoList);
        orderInfoDto.setPolicyDto(policyDto);
        AtinOrderRoles orderRoles = (AtinOrderRoles)this.orderRolesMapper.selectByPrimaryKey(lbOrder.getOrderRolesId());
        orderInfoDto.setOrderRoles(orderRoles);
        Collections.sort(policyDto.getCoverageList());
        return orderInfoDto;
    }

    private void changeOrderStatus(PolicyDto policyDto) {
        if (policyDto != null && (CommonUtil.isSame((String)policyDto.getInsuCom(), (String)"I00001") && policyDto.getCityCode() != "110000" || CommonUtil.isSame((String)policyDto.getInsuCom(), (String)"I00009"))) {
            List policyIdList = this.policyMapper.queryPolicyIdListByLicenseNoAndOrderStatus(policyDto.getLicenseNo(), policyDto.getInsuCom());
            List orderList = this.orderMapper.getOrderListByPolicyList(policyIdList);
            HashMap<Integer, AtinOrder> orderMap = new HashMap<Integer, AtinOrder>();
            for (AtinOrder order : orderList) {
                orderMap.put(order.getPolicyId(), order);
            }
            ArrayList<Integer> changePolicyIdList = new ArrayList<Integer>();
            if (policyIdList != null && policyIdList.size() >= 1 && orderList != null && orderList.size() >= 1) {
                for (Integer policyId : policyIdList) {
                    if (policyId == policyDto.getId() || orderMap.get(policyId) == null || ((AtinOrder)orderMap.get(policyId)).getOrderStatus() != AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS) continue;
                    changePolicyIdList.add(policyId);
                }
                if (changePolicyIdList != null && changePolicyIdList.size() >= 1) {
                    this.orderMapper.changeOrderStatusByPolicyIdList(changePolicyIdList, AtinOrder.ORDER_STATUS_REVOKE);
                }
            }
        }
    }

    @Override
    public AtinPolicy insureConfirm(Integer orderId, String code) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrderId(orderId);
        if (AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS == orderInfoDto.getOrderStatus()) {
            return orderInfoDto.getPolicyDto();
        }
        PolicyDto policyDto = orderInfoDto.getPolicyDto();
        this.changeOrderStatus(policyDto);
        InsureConfirmReqDto insureConfirmReqDto = this.getInsureConfirmReqDtoByOrderInfo(orderInfoDto);
        insureConfirmReqDto.setVerificationCode(code);
        insureConfirmReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(orderInfoDto.getPolicyDto().getLicenseNo()));
        insureConfirmReqDto.setInsuCom(orderInfoDto.getPolicyDto().getInsuCom());
        insureConfirmReqDto.setPartner("zhlh");
        InsureConfirmResDto insureConfirmResDto = this.insureConfirmRService.insureConfirm(insureConfirmReqDto);
        log.info("insureConfirmResDto:" + JsonUtil.beanToJSON((Object)insureConfirmResDto));
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(orderInfoDto.getId());
        BeanUtil.quickCopy((Object)((Object)orderInfoDto), (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(new Date());
        orderAction.setActionUser("\u7cfb\u7edf");
        if (insureConfirmResDto.getErrCode() != 0) {
            orderAction.setActionContent("\u6838\u4fdd\u5931\u8d25");
            orderAction.setActionNote(insureConfirmResDto.getErrMsg());
            this.orderActionMapper.insertSelective((Object)orderAction);
            throw new CommonException(insureConfirmResDto.getErrCode().intValue(), ErrorMessageUtil.errorConvert(insureConfirmResDto.getErrCode(), insureConfirmResDto.getErrMsg()));
        }
        if ("N".equalsIgnoreCase(insureConfirmResDto.getInsureSuccessFlag())) {
            orderAction.setActionContent("\u6838\u4fdd\u5931\u8d25");
            orderAction.setActionNote(insureConfirmResDto.getInsureFailReason());
            this.orderActionMapper.insertSelective((Object)orderAction);
            AtinPolicy policy = new AtinPolicy();
            policy.setId(orderInfoDto.getPolicyDto().getId());
            policy.setModifyTime(new Date());
            BeanUtil.quickCopy((Object)insureConfirmResDto, (Object)policy);
            policy.setVciUdwrtFlag("");
            policy.setTciUdwrtMessage("");
            this.policyMapper.updateByPrimaryKeySelective((Object)policy);
            throw new CommonException(insureConfirmResDto.getErrCode().intValue(), ErrorMessageUtil.errorConvert(insureConfirmResDto.getErrCode(), insureConfirmResDto.getErrMsg()));
        }
        orderAction.setActionContent("\u6838\u4fdd\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
        AtinPolicy policy = new AtinPolicy();
        policy.setId(orderInfoDto.getPolicyDto().getId());
        policy.setModifyTime(new Date());
        BeanUtil.quickCopy((Object)insureConfirmResDto, (Object)policy);
        this.policyMapper.updateByPrimaryKeySelective((Object)policy);
        this.orderMapper.changeOrderStatus(AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS, orderId);
        return policy;
    }

    @Override
    public void identityCollect(Integer orderId, String phone) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrderId(orderId);
        IdentityCollectReqDto identityCollectReqDto = this.getIdentityCollectReqDtoByOrderInfo(orderInfoDto);
        identityCollectReqDto.setMobile(phone);
        identityCollectReqDto.setPartner("zhlh");
        log.info("\u8eab\u4efd\u91c7\u96c6\u53c2\u6570identityCollectReqDto:" + JsonUtil.beanToJSON((Object)identityCollectReqDto));
        IdentityCollectResDto identityCollectResDto = this.identityCollectRService.identityCollect(identityCollectReqDto);
        log.info("\u8eab\u4efd\u91c7\u96c6\u7ed3\u679cidentityCollectResDto:" + JsonUtil.beanToJSON((Object)identityCollectResDto));
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(orderInfoDto.getId());
        BeanUtil.quickCopy((Object)((Object)orderInfoDto), (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(new Date());
        orderAction.setActionUser("\u7cfb\u7edf");
        if (identityCollectResDto.getErrCode() != 0) {
            orderAction.setActionContent("\u8eab\u4efd\u91c7\u96c6\u5931\u8d25");
            orderAction.setActionNote(identityCollectResDto.getErrMsg());
            this.orderActionMapper.insertSelective((Object)orderAction);
            throw new CommonException(identityCollectResDto.getErrCode().intValue(), ErrorMessageUtil.errorConvert(identityCollectResDto.getErrCode(), identityCollectResDto.getErrMsg()));
        }
        orderAction.setActionContent("\u8eab\u4efd\u91c7\u96c6\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
    }

    @Override
    public PayDto orderPay(Integer orderId, String tradeType) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrderId(orderId);
        if (AtinOrder.PAY_STATUS_PAID == orderInfoDto.getPayStatus()) {
            throw new CommonException("\u8be5\u8ba2\u5355\u5df2\u4ed8\u6b3e");
        }
        if (AtinOrder.ORDER_STATUS_SUBMIT == orderInfoDto.getOrderStatus()) {
            throw new CommonException("\u6838\u4fdd\u672a\u901a\u8fc7\u6216\u672a\u6838\u4fdd,\u8bf7\u91cd\u65b0\u8be2\u4ef7");
        }
        LuoberPayReqDto luoberPayReqDto = this.getLuoberPayReqDtoByOrderInfo(orderInfoDto);
        luoberPayReqDto.setTradeType(tradeType);
        luoberPayReqDto.setPartner("zhlh");
        luoberPayReqDto.setInsuCom(orderInfoDto.getPolicyDto().getInsuCom());
        luoberPayReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(orderInfoDto.getPolicyDto().getLicenseNo()));
        log.info("luoberPayReqDto:" + JsonUtil.beanToJSON((Object)luoberPayReqDto));
        LuoberPayResDto luoberPayResDto = this.luobarPayRService.luoberPay(luoberPayReqDto);
        if (luoberPayResDto.getErrCode() != 0) {
            throw new CommonException(luoberPayResDto.getErrCode().intValue(), ErrorMessageUtil.errorConvert(luoberPayResDto.getErrCode(), luoberPayResDto.getErrMsg()));
        }
        PayDto payDto = new PayDto();
        BeanUtil.quickCopy((Object)luoberPayResDto, (Object)payDto);
        return payDto;
    }

    @Override
    public AtinOrder rmNotify(RmNotifyDto rmNotify) {
        Date now = new Date();
        AtinPolicy policy = this.policyMapper.getPolicyByInnerPlcyNo(rmNotify.getInnerPlcyNo());
        AtinOrder lbOrder = this.orderMapper.getOrderByPolicyId(policy.getId());
        if (lbOrder.getPayStatus().intValue() == AtinOrder.PAY_STATUS_PAID.intValue()) {
            return lbOrder;
        }
        AtinPayLog payLog = this.payLogMapper.getByOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)rmNotify, (Object)payLog);
        payLog.setIsPaid(Integer.valueOf(1));
        payLog.setPayTime(now);
        payLog.setPayAmount(new BigDecimal(rmNotify.getTotalFee()));
        this.payLogMapper.updateByPrimaryKeySelective((Object)payLog);
        lbOrder.setPayStatus(AtinOrder.PAY_STATUS_PAID);
        lbOrder.setOrderStatus(AtinOrder.ORDER_STATUS_USER_PAID);
        this.lbOrderMapper.updateByPrimaryKeySelective((Object)lbOrder);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)lbOrder, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(now);
        orderAction.setActionUser("\u7cfb\u7edf");
        orderAction.setActionContent("\u4ed8\u6b3e\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
        return lbOrder;
    }

    @Override
    public AtinOrder cbsNotify(CbsNotifyDto cbsNotify) {
        Date now = new Date();
        AtinPolicy policy = this.policyMapper.getPolicyByInnerPlcyNo(cbsNotify.getInnerPlcyNo());
        AtinOrder lbOrder = this.orderMapper.getOrderByPolicyId(policy.getId());
        if (lbOrder.getPayStatus().intValue() == AtinOrder.PAY_STATUS_PAY_INSURE.intValue()) {
            return lbOrder;
        }
        BeanUtil.quickCopy((Object)cbsNotify, (Object)policy);
        policy.setModifyTime(now);
        this.policyMapper.updateByPrimaryKeySelective((Object)policy);
        lbOrder.setPayStatus(AtinOrder.PAY_STATUS_PAY_INSURE);
        lbOrder.setOrderStatus(AtinOrder.ORDER_STATUS_LUOBO_PAID);
        this.lbOrderMapper.updateByPrimaryKeySelective((Object)lbOrder);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)lbOrder, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(now);
        orderAction.setActionUser("\u7cfb\u7edf");
        orderAction.setActionContent("\u5411\u4fdd\u9669\u516c\u53f8\u4ed8\u6b3e\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
        return lbOrder;
    }

    private InsureConfirmReqDto getInsureConfirmReqDtoByOrderInfo(OrderInfoDto orderInfoDto) {
        InsureConfirmReqDto insureConfirmReqDto = new InsureConfirmReqDto();
        PolicyDto policy = orderInfoDto.getPolicyDto();
        BeanUtil.quickCopy((Object)((Object)policy), (Object)insureConfirmReqDto);
        insureConfirmReqDto.setQuoteNo(policy.getQueryNo());
        insureConfirmReqDto.setPostName(orderInfoDto.getOrderRoles().getPostContact());
        insureConfirmReqDto.setPostAddr(orderInfoDto.getOrderRoles().getPostAddress());
        insureConfirmReqDto.setPostMobile(orderInfoDto.getOrderRoles().getPostMobile());
        return insureConfirmReqDto;
    }

    private IdentityCollectReqDto getIdentityCollectReqDtoByOrderInfo(OrderInfoDto orderInfoDto) {
        IdentityCollectReqDto identityCollectReqDto = new IdentityCollectReqDto();
        PolicyDto policy = orderInfoDto.getPolicyDto();
        BeanUtil.quickCopy((Object)((Object)policy), (Object)identityCollectReqDto);
        identityCollectReqDto.setQuoteNo(policy.getQueryNo());
        AtinOrderRoles orderRoles = orderInfoDto.getOrderRoles();
        identityCollectReqDto.setCertNo(orderRoles.getInsuredCertNo());
        identityCollectReqDto.setName(orderRoles.getInsuredName());
        identityCollectReqDto.setInsuCom(orderInfoDto.getPolicyDto().getInsuCom());
        identityCollectReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(orderInfoDto.getPolicyDto().getLicenseNo()));
        return identityCollectReqDto;
    }

    private LuoberPayReqDto getLuoberPayReqDtoByOrderInfo(OrderInfoDto orderInfoDto) {
        LuoberPayReqDto luoberPayReqDto = new LuoberPayReqDto();
        AtinOrderRoles orderRoles = orderInfoDto.getOrderRoles();
        PolicyDto policyDto = orderInfoDto.getPolicyDto();
        luoberPayReqDto.setChannel(ChannelConstants.CHANNEL);
        luoberPayReqDto.setInsuCom(policyDto.getInsuCom());
        luoberPayReqDto.setInnerPlcyNo(policyDto.getInnerPlcyNo());
        luoberPayReqDto.setChargeComCode("WX");
        luoberPayReqDto.setOpenId(orderInfoDto.getOrderRoles().getOpenid());
        luoberPayReqDto.setOrderPremium(Integer.valueOf(Integer.parseInt(NumberUtil.nullToZeroStr(orderInfoDto.getSumAmount().setScale(0, 4).toPlainString()))));
        return luoberPayReqDto;
    }

    @Override
    public void cancelTimeOutOrder() {
        Calendar rightNow = Calendar.getInstance();
        rightNow.add(11, -23);
        List orderList = this.orderMapper.getOrderListBeforeTime(rightNow.getTime());
        if (CommonUtil.isEmpty((Collection)orderList)) {
            return;
        }
        ArrayList<Integer> orderIdList = new ArrayList<Integer>();
        ArrayList<AtinOrderAction> orderActionList = new ArrayList<AtinOrderAction>();
        Date now = new Date();
        rightNow.add(11, -1);
        for (AtinOrder order : orderList) {
            if (order.getPayStatus().intValue() == AtinOrder.PAY_STATUS_PAID.intValue() || order.getCreateTime().getTime() < rightNow.getTime().getTime()) continue;
            orderIdList.add(order.getId());
            AtinOrderAction orderAction = new AtinOrderAction();
            orderAction.setOrderId(order.getId());
            BeanUtil.quickCopy((Object)order, (Object)orderAction);
            orderAction.setId(null);
            orderAction.setOrderStatus(AtinOrder.ORDER_STATUS_TIMEOUT);
            orderAction.setCreateTime(now);
            orderAction.setActionUser("\u7cfb\u7edf");
            orderAction.setActionContent("\u8d85\u65f6\u5173\u95ed\u8ba2\u5355");
            orderAction.setActionNote("");
            orderActionList.add(orderAction);
        }
        if (CommonUtil.isEmpty(orderIdList)) {
            return;
        }
        this.orderActionMapper.batchInsert(orderActionList);
        this.orderMapper.changeOrderStatusByOrderIdList(orderIdList, AtinOrder.ORDER_STATUS_TIMEOUT);
    }

    @Override
    public AtinOrderRoles getOrderRolesByOpenId(String openId) {
        AtinOrderRoles orderRoles = this.orderRolesMapper.selectUserOrderByOpenId(openId);
        return orderRoles;
    }

    @Override
    public String getIdentityCollectPhoneByOrderId(Integer orderId) {
        AtinOrder order = (AtinOrder)this.lbOrderMapper.selectByPrimaryKey(orderId);
        AtinOrderRoles orderRoles = (AtinOrderRoles)this.orderRolesMapper.selectByPrimaryKey(order.getOrderRolesId());
        return orderRoles == null ? "" : orderRoles.getApplicantMobile();
    }

    @Override
    public RmOutNotifyDto getRmOutNotify(AtinOrder order) {
        RmOutNotifyDto rmOutNotifyDto = new RmOutNotifyDto();
        OriginUser originUser = (OriginUser)this.originUserMapper.selectByPrimaryKey(order.getUserId());
        AtinPolicy atinPolicy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(order.getPolicyId());
        BeanUtil.quickCopy((Object)atinPolicy, (Object)rmOutNotifyDto);
        rmOutNotifyDto.setOriginDiscount(ServiceUtil.getBigDic(atinPolicy.getLuborDiscount()).toPlainString());
        rmOutNotifyDto.setOriginPremium(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicy.getLuborPremium()).toPlainString()));
        rmOutNotifyDto.setPayStatus(order.getPayStatus());
        rmOutNotifyDto.setInnerPlcyNo(atinPolicy.getInnerPlcyNo());
        rmOutNotifyDto.setInsuComName(ServiceUtil.getInsurerByCode(atinPolicy.getInsuCom()).getAbbreviation());
        rmOutNotifyDto.setUniqueId(originUser.getUniqueId());
        rmOutNotifyDto.setPremium(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicy.getPremium()).toPlainString()));
        rmOutNotifyDto.setTciPremium(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicy.getTciPremium()).toPlainString()));
        rmOutNotifyDto.setVciPremium(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicy.getVciPremium()).toPlainString()));
        rmOutNotifyDto.setSumTravelTax(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicy.getSumTravelTax()).toPlainString()));
        rmOutNotifyDto.setTciStartDate(DateUtil.formatDateTime((Date)atinPolicy.getTciStartDate()));
        rmOutNotifyDto.setVciStartDate(DateUtil.formatDateTime((Date)atinPolicy.getVciStartDate()));
        rmOutNotifyDto.setInsuStartDate(DateUtil.formatDateTime((Date)atinPolicy.getInsuStartDate()));
        List atinPolicyCoverageList = this.policyCoverageMapper.getCoverageList(order.getPolicyId());
        ArrayList<RmOutNotifyCoverageDto> rmOutNotifyCoverageDtoList = new ArrayList<RmOutNotifyCoverageDto>();
        for (AtinPolicyCoverage atinPolicyCoverage : atinPolicyCoverageList) {
            RmOutNotifyCoverageDto out = new RmOutNotifyCoverageDto();
            out.setReason(atinPolicyCoverage.getReason());
            out.setCoverageCode(atinPolicyCoverage.getCoverageCode());
            out.setQuantity(atinPolicyCoverage.getQuantity().toString());
            out.setAmount(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicyCoverage.getAmount()).toPlainString()));
            out.setUnimount(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicyCoverage.getUnimount()).toPlainString()));
            out.setModelCode(atinPolicyCoverage.getModelCode().toString());
            out.setIsDeductibleChoice(atinPolicyCoverage.getIsDeductibleChoice().toString());
            out.setPremium(NumberUtil.changeFToY(ServiceUtil.getBigDic(atinPolicyCoverage.getPremium()).toPlainString()));
            out.setIsApprove(atinPolicyCoverage.getIsApprove().toString());
            out.setName(ServiceUtil.getCoverageByCode(atinPolicyCoverage.getCoverageCode()).getName());
            rmOutNotifyCoverageDtoList.add(out);
        }
        rmOutNotifyDto.setCoverageList(rmOutNotifyCoverageDtoList);
        return rmOutNotifyDto;
    }

    @Override
    public CbsOutNotifyDto getCbsNotifyDto(AtinOrder order) {
        AtinPolicy atinPolicy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(order.getPolicyId());
        CbsOutNotifyDto cbsOutNotifyDto = new CbsOutNotifyDto();
        cbsOutNotifyDto.setInnerPlcyNo(atinPolicy.getInnerPlcyNo());
        cbsOutNotifyDto.setPayStatus(order.getPayStatus());
        cbsOutNotifyDto.setTciPolicyNo(atinPolicy.getTciPolicyNo());
        cbsOutNotifyDto.setVciPolicyNo(atinPolicy.getVciPolicyNo());
        return cbsOutNotifyDto;
    }
}

